/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.almintegrations;

import org.sonarqube.ws.AlmIntegrations;
import org.sonarqube.ws.Projects;
import org.sonarqube.ws.client.BaseService;
import org.sonarqube.ws.client.GetRequest;
import org.sonarqube.ws.client.PostRequest;
import org.sonarqube.ws.client.RequestWithPayload;
import org.sonarqube.ws.client.RequestWithoutPayload;
import org.sonarqube.ws.client.WsConnector;
import org.sonarqube.ws.client.almintegrations.CheckPatRequest;
import org.sonarqube.ws.client.almintegrations.ImportAzureProjectRequest;
import org.sonarqube.ws.client.almintegrations.ImportBitbucketcloudRepoRequest;
import org.sonarqube.ws.client.almintegrations.ImportBitbucketserverProjectRequest;
import org.sonarqube.ws.client.almintegrations.ImportGitLabProjectRequest;
import org.sonarqube.ws.client.almintegrations.ImportGithubProjectRequest;
import org.sonarqube.ws.client.almintegrations.ListAzureProjectsRequest;
import org.sonarqube.ws.client.almintegrations.ListBitbucketserverProjectsRequest;
import org.sonarqube.ws.client.almintegrations.ListGithubOrganizationsRequest;
import org.sonarqube.ws.client.almintegrations.SearchBitbucketcloudReposRequest;
import org.sonarqube.ws.client.almintegrations.SearchBitbucketserverReposRequest;
import org.sonarqube.ws.client.almintegrations.SearchGitlabReposRequest;
import org.sonarqube.ws.client.almintegrations.SendGithubCodeScanningAlertWebhookPayloadRequest;
import org.sonarqube.ws.client.almintegrations.SetPatRequest;

public class AlmIntegrationsService
extends BaseService {
    public AlmIntegrationsService(WsConnector wsConnector) {
        super(wsConnector, "api/alm_integrations");
    }

    public void checkPat(CheckPatRequest request) {
        this.call(((RequestWithoutPayload)new GetRequest(this.path("check_pat")).setParam("almSetting", request.getAlmSetting())).setMediaType("application/json")).content();
    }

    public Projects.CreateWsResponse importBitbucketserverProject(ImportBitbucketserverProjectRequest request) {
        return this.call(((RequestWithPayload)((RequestWithPayload)((RequestWithPayload)new PostRequest(this.path("import_bitbucketserver_project")).setParam("almSetting", request.getAlmSetting())).setParam("projectKey", request.getProjectKey())).setParam("repositorySlug", request.getRepositorySlug())).setMediaType("application/json"), Projects.CreateWsResponse.parser());
    }

    public Projects.CreateWsResponse importBitbucketcloudProject(ImportBitbucketcloudRepoRequest request) {
        return this.call(((RequestWithPayload)((RequestWithPayload)new PostRequest(this.path("import_bitbucketcloud_repo")).setParam("almSetting", request.getAlmSetting())).setParam("repositorySlug", request.getRepositorySlug())).setMediaType("application/json"), Projects.CreateWsResponse.parser());
    }

    public Projects.CreateWsResponse importGitLabProject(ImportGitLabProjectRequest request) {
        return this.call(((RequestWithPayload)((RequestWithPayload)new PostRequest(this.path("import_gitlab_project")).setParam("almSetting", request.getAlmSetting())).setParam("gitlabProjectId", request.getGitlabProjectId())).setMediaType("application/json"), Projects.CreateWsResponse.parser());
    }

    public Projects.CreateWsResponse importGithubProject(ImportGithubProjectRequest request) {
        return this.call(((RequestWithPayload)((RequestWithPayload)new PostRequest(this.path("import_github_project")).setParam("almSetting", request.getAlmSetting())).setParam("repositoryKey", request.getRepositoryKey())).setMediaType("application/json"), Projects.CreateWsResponse.parser());
    }

    public void listGithubOrganizations(ListGithubOrganizationsRequest request) {
        this.call(((RequestWithoutPayload)((RequestWithoutPayload)new GetRequest(this.path("list_github_organizations")).setParam("almSetting", request.getAlmSetting())).setParam("token", request.getToken())).setMediaType("application/json"), Projects.CreateWsResponse.parser());
    }

    public Projects.CreateWsResponse importAzureProject(ImportAzureProjectRequest request) {
        return this.call(((RequestWithPayload)((RequestWithPayload)((RequestWithPayload)new PostRequest(this.path("import_azure_project")).setParam("almSetting", request.getAlmSetting())).setParam("projectName", request.getProjectName())).setParam("repositoryName", request.getRepositoryName())).setMediaType("application/json"), Projects.CreateWsResponse.parser());
    }

    public AlmIntegrations.SearchGitlabReposWsResponse searchGitlabRepos(SearchGitlabReposRequest request) {
        return this.call(((RequestWithoutPayload)((RequestWithoutPayload)new GetRequest(this.path("search_gitlab_repos")).setParam("almSetting", request.getAlmSetting())).setParam("projectName", request.getProjectName())).setMediaType("application/json"), AlmIntegrations.SearchGitlabReposWsResponse.parser());
    }

    public AlmIntegrations.ListAzureProjectsWsResponse listAzureProjects(ListAzureProjectsRequest request) {
        return this.call(((RequestWithoutPayload)new GetRequest(this.path("list_azure_projects")).setParam("almSetting", request.getAlmSetting())).setMediaType("application/json"), AlmIntegrations.ListAzureProjectsWsResponse.parser());
    }

    public AlmIntegrations.ListBitbucketserverProjectsWsResponse listBitbucketserverProjects(ListBitbucketserverProjectsRequest request) {
        return this.call(((RequestWithoutPayload)new GetRequest(this.path("list_bitbucketserver_projects")).setParam("almSetting", request.getAlmSetting())).setMediaType("application/json"), AlmIntegrations.ListBitbucketserverProjectsWsResponse.parser());
    }

    public AlmIntegrations.SearchBitbucketserverReposWsResponse searchBitbucketserverRepos(SearchBitbucketserverReposRequest request) {
        return this.call(((RequestWithoutPayload)((RequestWithoutPayload)((RequestWithoutPayload)new GetRequest(this.path("search_bitbucketserver_repos")).setParam("almSetting", request.getAlmSetting())).setParam("projectName", request.getProjectName())).setParam("repositoryName", request.getRepositoryName())).setMediaType("application/json"), AlmIntegrations.SearchBitbucketserverReposWsResponse.parser());
    }

    public AlmIntegrations.SearchBitbucketcloudReposWsResponse searchBitbucketcloudRepos(SearchBitbucketcloudReposRequest request) {
        return this.call(((RequestWithoutPayload)new GetRequest(this.path("search_bitbucketcloud_repos")).setParam("almSetting", request.getAlmSetting())).setMediaType("application/json"), AlmIntegrations.SearchBitbucketcloudReposWsResponse.parser());
    }

    public void sendGitubCodeScanningAlertWebhookPayload(SendGithubCodeScanningAlertWebhookPayloadRequest request) {
        this.call(((PostRequest)((RequestWithPayload)((RequestWithPayload)((RequestWithPayload)((RequestWithPayload)new PostRequest(this.path("webhook_github")).setHeader("X-GitHub-Event", request.getGithubEventHeader())).setHeader("X-Hub-Signature", request.getGithubSignatureHeader())).setHeader("X-Hub-Signature-256", request.getGithubSignature256Header())).setHeader("x-github-hook-installation-target-id", request.getGithubAppId())).setBody(request.getPayload())).setMediaType("application/json")).content();
    }

    public void setPat(SetPatRequest request) {
        this.call(((RequestWithPayload)((RequestWithPayload)((RequestWithPayload)new PostRequest(this.path("set_pat")).setParam("almSetting", request.getAlmSetting())).setParam("pat", request.getPat())).setParam("username", request.getUsername())).setMediaType("application/json")).content();
    }
}

