/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.gitlab.configuration;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import org.sonarqube.ws.client.BaseService;
import org.sonarqube.ws.client.PatchRequest;
import org.sonarqube.ws.client.PostRequest;
import org.sonarqube.ws.client.WsConnector;
import org.sonarqube.ws.client.WsRequest;
import org.sonarqube.ws.client.WsResponse;
import org.sonarqube.ws.client.gitlab.configuration.GitlabConfiguration;

public class GitlabConfigurationService
extends BaseService {
    public GitlabConfigurationService(WsConnector wsConnector) {
        super(wsConnector, "api/v2/dop-translation/gitlab-configurations");
    }

    public String saveGitlabConfiguration(GitlabConfiguration gitlabConfiguration) {
        String body = String.format("{\n  \"enabled\": \"%s\",\n  \"applicationId\": \"%s\",\n  \"url\": \"%s\",\n  \"secret\": \"%s\",\n  \"synchronizeGroups\": \"%s\",\n  \"provisioningType\": \"%s\",\n  \"allowUsersToSignUp\": \"%s\",\n  \"provisioningToken\": \"%s\",\n  \"allowedGroups\": [\"%s\"]\n}\n", gitlabConfiguration.enabled(), gitlabConfiguration.applicationId(), gitlabConfiguration.url(), gitlabConfiguration.secret(), gitlabConfiguration.synchronizeGroups(), gitlabConfiguration.provisioningType(), gitlabConfiguration.allowUsersToSignUp(), gitlabConfiguration.provisioningToken(), gitlabConfiguration.singleAllowedGroup());
        WsResponse response = this.call((WsRequest)new PostRequest(this.path()).setBody(body));
        return ((JsonObject)new Gson().fromJson(response.content(), JsonObject.class)).get("id").getAsString();
    }

    public void enableAutoProvisioning(String configId) {
        this.setProvisioningMode(configId, "AUTO_PROVISIONING");
    }

    public void disableAutoProvisioning(String configId) {
        this.setProvisioningMode(configId, "JIT");
    }

    private void setProvisioningMode(String configId, String provisioningMode) {
        String body = String.format("{\n  \"provisioningType\": \"%s\"\n}\n", provisioningMode);
        this.call((WsRequest)((PatchRequest)new PatchRequest(this.path(configId)).setBody(body)).setContentType("application/merge-patch+json"));
    }
}

