/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client;

import org.sonar.api.server.ws.LocalConnector;
import org.sonarqube.ws.client.DefaultWsClient;
import org.sonarqube.ws.client.LocalWsClientFactory;
import org.sonarqube.ws.client.LocalWsConnector;
import org.sonarqube.ws.client.WsClient;
import org.sonarqube.ws.client.WsClientFactory;
import org.sonarqube.ws.client.WsConnector;

public class WsClientFactories {
    private WsClientFactories() {
    }

    public static WsClientFactory getDefault() {
        return DefaultWsClientFactory.INSTANCE;
    }

    public static LocalWsClientFactory getLocal() {
        return DefaultLocalWsClientFactory.INSTANCE;
    }

    private static enum DefaultWsClientFactory implements WsClientFactory
    {
        INSTANCE;


        @Override
        public WsClient newClient(WsConnector connector) {
            return new DefaultWsClient(connector);
        }
    }

    private static enum DefaultLocalWsClientFactory implements LocalWsClientFactory
    {
        INSTANCE;


        @Override
        public WsClient newClient(WsConnector connector) {
            return DefaultWsClientFactory.INSTANCE.newClient(connector);
        }

        @Override
        public WsClient newClient(LocalConnector localConnector) {
            return new DefaultWsClient(new LocalWsConnector(localConnector));
        }
    }
}

