/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.setting;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class ResetRequest {
    private final List<String> keys;
    private final String component;
    private final String branch;

    private ResetRequest(Builder builder) {
        this.keys = builder.keys;
        this.component = builder.component;
        this.branch = builder.branch;
    }

    public List<String> getKeys() {
        return this.keys;
    }

    @CheckForNull
    public String getComponent() {
        return this.component;
    }

    @CheckForNull
    public String getBranch() {
        return this.branch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<String> keys;
        private String component;
        private String branch;

        private Builder() {
        }

        public Builder setKeys(List<String> keys) {
            this.keys = keys;
            return this;
        }

        public Builder setKeys(String ... keys) {
            this.setKeys(Arrays.asList(keys));
            return this;
        }

        public Builder setComponent(@Nullable String component) {
            this.component = component;
            return this;
        }

        public Builder setBranch(@Nullable String branch) {
            this.branch = branch;
            return this;
        }

        public ResetRequest build() {
            Preconditions.checkArgument((this.keys != null && !this.keys.isEmpty() ? 1 : 0) != 0, (Object)"Setting keys is mandatory and must not be empty.");
            return new ResetRequest(this);
        }
    }
}

