/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.setting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class ValuesRequest {
    private final List<String> keys;
    private final String component;
    private final String branch;

    private ValuesRequest(Builder builder) {
        this.keys = builder.keys;
        this.component = builder.component;
        this.branch = builder.branch;
    }

    public List<String> getKeys() {
        return this.keys;
    }

    @CheckForNull
    public String getComponent() {
        return this.component;
    }

    @CheckForNull
    public String getBranch() {
        return this.branch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<String> keys = new ArrayList<String>();
        private String component;
        private String branch;

        private Builder() {
        }

        public Builder setKeys(List<String> keys) {
            this.keys = Objects.requireNonNull(keys);
            return this;
        }

        public Builder setKeys(String ... keys) {
            return this.setKeys(Arrays.asList(keys));
        }

        public Builder setComponent(@Nullable String component) {
            this.component = component;
            return this;
        }

        public Builder setBranch(@Nullable String branch) {
            this.branch = branch;
            return this;
        }

        public ValuesRequest build() {
            return new ValuesRequest(this);
        }
    }
}

