/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.user;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class CreateRequest {
    private final String login;
    private final String password;
    private final String name;
    private final String email;
    private final List<String> scmAccounts;
    private final boolean local;

    private CreateRequest(Builder builder) {
        this.login = builder.login;
        this.password = builder.password;
        this.name = builder.name;
        this.email = builder.email;
        this.scmAccounts = builder.scmAccounts;
        this.local = builder.local;
    }

    public String getLogin() {
        return this.login;
    }

    @CheckForNull
    public String getPassword() {
        return this.password;
    }

    public String getName() {
        return this.name;
    }

    @CheckForNull
    public String getEmail() {
        return this.email;
    }

    public List<String> getScmAccounts() {
        return this.scmAccounts;
    }

    public boolean isLocal() {
        return this.local;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String login;
        private String password;
        private String name;
        private String email;
        private List<String> scmAccounts = Collections.emptyList();
        private boolean local = true;

        private Builder() {
        }

        public Builder setLogin(String login) {
            this.login = login;
            return this;
        }

        public Builder setPassword(@Nullable String password) {
            this.password = password;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setEmail(@Nullable String email) {
            this.email = email;
            return this;
        }

        public Builder setScmAccounts(List<String> scmAccounts) {
            this.scmAccounts = scmAccounts;
            return this;
        }

        public Builder setLocal(boolean local) {
            this.local = local;
            return this;
        }

        public CreateRequest build() {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.login) ? 1 : 0) != 0, (Object)"Login is mandatory and must not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.name) ? 1 : 0) != 0, (Object)"Name is mandatory and must not be empty");
            Preconditions.checkArgument((!this.local || !Strings.isNullOrEmpty((String)this.password) ? 1 : 0) != 0, (Object)"Password is mandatory and must not be empty");
            Preconditions.checkArgument((this.local || Strings.isNullOrEmpty((String)this.password) ? 1 : 0) != 0, (Object)"Password should only be set on local user");
            return new CreateRequest(this);
        }
    }
}

