/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.user;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class GroupsRequest {
    private final String login;
    private final String organization;
    private final String query;
    private final String selected;
    private final Integer page;
    private final Integer pageSize;

    private GroupsRequest(Builder builder) {
        this.login = builder.login;
        this.organization = builder.organization;
        this.query = builder.query;
        this.selected = builder.selected;
        this.page = builder.page;
        this.pageSize = builder.pageSize;
    }

    public String getLogin() {
        return this.login;
    }

    @CheckForNull
    public String getOrganization() {
        return this.organization;
    }

    @CheckForNull
    public String getQuery() {
        return this.query;
    }

    @CheckForNull
    public String getSelected() {
        return this.selected;
    }

    @CheckForNull
    public Integer getPage() {
        return this.page;
    }

    @CheckForNull
    public Integer getPageSize() {
        return this.pageSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String login;
        private String organization;
        private String query;
        private String selected;
        private Integer page;
        private Integer pageSize;

        private Builder() {
        }

        public Builder setLogin(String login) {
            this.login = login;
            return this;
        }

        public Builder setOrganization(@Nullable String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setQuery(@Nullable String query) {
            this.query = query;
            return this;
        }

        public Builder setSelected(@Nullable String selected) {
            this.selected = selected;
            return this;
        }

        public Builder setPage(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public Builder setPageSize(@Nullable Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GroupsRequest build() {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.login) ? 1 : 0) != 0, (Object)"Login is mandatory and must not be empty");
            return new GroupsRequest(this);
        }
    }
}

