/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.user;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SearchRequest {
    private final Integer page;
    private final Integer pageSize;
    private final String query;
    private final List<String> possibleFields;

    private SearchRequest(Builder builder) {
        this.page = builder.page;
        this.pageSize = builder.pageSize;
        this.query = builder.query;
        this.possibleFields = builder.additionalFields;
    }

    @CheckForNull
    public Integer getPage() {
        return this.page;
    }

    @CheckForNull
    public Integer getPageSize() {
        return this.pageSize;
    }

    @CheckForNull
    public String getQuery() {
        return this.query;
    }

    public List<String> getPossibleFields() {
        return this.possibleFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Integer page;
        private Integer pageSize;
        private String query;
        private List<String> additionalFields = new ArrayList<String>();

        private Builder() {
        }

        public Builder setPage(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public Builder setPageSize(@Nullable Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder setQuery(@Nullable String query) {
            this.query = query;
            return this;
        }

        public Builder setPossibleFields(List<String> possibleFields) {
            this.additionalFields = possibleFields;
            return this;
        }

        public SearchRequest build() {
            return new SearchRequest(this);
        }
    }
}

