/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.usergroup;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class CreateWsRequest {
    private final String name;
    private final String description;
    private final String organization;

    private CreateWsRequest(Builder builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.organization = builder.organization;
    }

    public String getName() {
        return this.name;
    }

    @CheckForNull
    public String getDescription() {
        return this.description;
    }

    public String getOrganization() {
        return this.organization;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String description;
        private String organization;

        private Builder() {
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(@Nullable String description) {
            this.description = description;
            return this;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public CreateWsRequest build() {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.name) ? 1 : 0) != 0, (Object)"Name is mandatory and must not be empty");
            return new CreateWsRequest(this);
        }
    }
}

