/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client;

import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import java.io.InputStream;
import java.util.Collection;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonarqube.ws.WsUtils;
import org.sonarqube.ws.client.BaseRequest;
import org.sonarqube.ws.client.WsConnector;
import org.sonarqube.ws.client.WsRequest;
import org.sonarqube.ws.client.WsResponse;

public abstract class BaseService {
    private final WsConnector wsConnector;
    protected final String controller;

    public BaseService(WsConnector wsConnector, String controllerPath) {
        WsUtils.checkArgument(!WsUtils.isNullOrEmpty(controllerPath), "Controller path cannot be empty", new Object[0]);
        this.wsConnector = wsConnector;
        this.controller = controllerPath;
    }

    protected <T extends Message> T call(BaseRequest request, Parser<T> parser) {
        request.setMediaType("application/x-protobuf");
        WsResponse response = this.call(request);
        return BaseService.convert(response, parser);
    }

    protected WsResponse call(WsRequest request) {
        return this.wsConnector.call(request).failIfNotSuccessful();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Message> T convert(WsResponse response, Parser<T> parser) {
        try (InputStream byteStream = response.contentStream();){
            Message message = (Message)parser.parseFrom(byteStream);
            return (T)message;
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to parse protobuf response of " + response.requestUrl(), e);
        }
    }

    protected String path(String action) {
        return String.format("%s/%s", this.controller, action);
    }

    @CheckForNull
    protected static String inlineMultipleParamValue(@Nullable Collection<String> values) {
        return values == null ? null : String.join((CharSequence)",", values);
    }
}

