/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.organizations;

import java.util.stream.Collectors;
import org.sonarqube.ws.Organizations;
import org.sonarqube.ws.client.BaseService;
import org.sonarqube.ws.client.GetRequest;
import org.sonarqube.ws.client.PostRequest;
import org.sonarqube.ws.client.WsConnector;
import org.sonarqube.ws.client.organizations.AddMemberRequest;
import org.sonarqube.ws.client.organizations.CreateRequest;
import org.sonarqube.ws.client.organizations.DeleteRequest;
import org.sonarqube.ws.client.organizations.RemoveMemberRequest;
import org.sonarqube.ws.client.organizations.SearchMembersRequest;
import org.sonarqube.ws.client.organizations.SearchRequest;
import org.sonarqube.ws.client.organizations.UpdateRequest;

public class OrganizationsService
extends BaseService {
    public OrganizationsService(WsConnector wsConnector) {
        super(wsConnector, "api/organizations");
    }

    public Organizations.AddMemberWsResponse addMember(AddMemberRequest request) {
        return this.call(((PostRequest)new PostRequest(this.path("add_member")).setParam("login", request.getLogin())).setParam("organization", request.getOrganization()), Organizations.AddMemberWsResponse.parser());
    }

    public Organizations.CreateWsResponse create(CreateRequest request) {
        return this.call(((PostRequest)((PostRequest)((PostRequest)((PostRequest)new PostRequest(this.path("create")).setParam("avatar", request.getAvatar())).setParam("description", request.getDescription())).setParam("key", request.getKey())).setParam("name", request.getName())).setParam("url", request.getUrl()), Organizations.CreateWsResponse.parser());
    }

    public void delete(DeleteRequest request) {
        this.call(((PostRequest)new PostRequest(this.path("delete")).setParam("organization", request.getOrganization())).setMediaType("application/json")).content();
    }

    public void enableSupport() {
        this.call(new PostRequest(this.path("enable_support")).setMediaType("application/json")).content();
    }

    public void removeMember(RemoveMemberRequest request) {
        this.call(((PostRequest)((PostRequest)new PostRequest(this.path("remove_member")).setParam("login", request.getLogin())).setParam("organization", request.getOrganization())).setMediaType("application/json")).content();
    }

    public Organizations.SearchWsResponse search(SearchRequest request) {
        return this.call(((GetRequest)((GetRequest)((GetRequest)new GetRequest(this.path("search")).setParam("member", request.getMember())).setParam("organizations", request.getOrganizations() == null ? null : request.getOrganizations().stream().collect(Collectors.joining(",")))).setParam("p", request.getP())).setParam("ps", request.getPs()), Organizations.SearchWsResponse.parser());
    }

    public Organizations.SearchMembersWsResponse searchMembers(SearchMembersRequest request) {
        return this.call(((GetRequest)((GetRequest)((GetRequest)((GetRequest)new GetRequest(this.path("search_members")).setParam("organization", request.getOrganization())).setParam("p", request.getP())).setParam("ps", request.getPs())).setParam("q", request.getQ())).setParam("selected", request.getSelected()), Organizations.SearchMembersWsResponse.parser());
    }

    public void update(UpdateRequest request) {
        this.call(((PostRequest)((PostRequest)((PostRequest)((PostRequest)new PostRequest(this.path("update")).setParam("avatar", request.getAvatar())).setParam("description", request.getDescription())).setParam("key", request.getKey())).setParam("name", request.getName())).setParam("url", request.getUrl()), Organizations.UpdateWsResponse.parser());
    }
}

