/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.updatecenter.common.Artifact;
import org.sonar.updatecenter.common.PluginManifest;
import org.sonar.updatecenter.common.Release;
import org.sonar.updatecenter.common.Version;

public class Plugin
extends Artifact {
    private String name;
    private String description;
    private String homepageUrl;
    private String license;
    private String organization;
    private String organizationUrl;
    private String termsConditionsUrl;
    private String category;
    private String issueTrackerUrl;
    private String sourcesUrl;
    private boolean supportedBySonarSource = false;
    private List<String> developers;

    private Plugin(String key) {
        super(key);
    }

    public static Plugin factory(String key) {
        if (StringUtils.isAlphanumeric((String)key)) {
            return new Plugin(key);
        }
        throw new IllegalArgumentException("plugin key must be alphanumeric, strictly");
    }

    public String getName() {
        return this.name;
    }

    public Plugin setName(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Plugin setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getHomepageUrl() {
        return this.homepageUrl;
    }

    public Plugin setHomepageUrl(String s) {
        this.homepageUrl = s;
        return this;
    }

    public String getLicense() {
        return this.license;
    }

    public Plugin setLicense(String license) {
        this.license = license;
        return this;
    }

    public String getOrganization() {
        return this.organization;
    }

    public Plugin setOrganization(String organization) {
        this.organization = organization;
        return this;
    }

    public String getOrganizationUrl() {
        return this.organizationUrl;
    }

    public Plugin setOrganizationUrl(String url) {
        this.organizationUrl = url;
        return this;
    }

    public String getCategory() {
        return this.category;
    }

    public Plugin setCategory(String category) {
        this.category = category;
        return this;
    }

    public String getTermsConditionsUrl() {
        return this.termsConditionsUrl;
    }

    public Plugin setTermsConditionsUrl(String url) {
        this.termsConditionsUrl = url;
        return this;
    }

    public String getIssueTrackerUrl() {
        return this.issueTrackerUrl;
    }

    public Plugin setIssueTrackerUrl(String url) {
        this.issueTrackerUrl = url;
        return this;
    }

    public String getSourcesUrl() {
        return this.sourcesUrl;
    }

    public Plugin setSourcesUrl(String sourcesUrl) {
        this.sourcesUrl = sourcesUrl;
        return this;
    }

    public List<String> getDevelopers() {
        return this.developers;
    }

    public Plugin setDevelopers(List<String> developers) {
        this.developers = developers;
        return this;
    }

    public boolean isSupportedBySonarSource() {
        return this.supportedBySonarSource;
    }

    public Plugin setSupportedBySonarSource(boolean supportedBySonarSource) {
        this.supportedBySonarSource = supportedBySonarSource;
        return this;
    }

    public Plugin merge(PluginManifest manifest) {
        if (StringUtils.equals((String)this.key, (String)manifest.getKey())) {
            this.name = manifest.getName();
            this.organization = StringUtils.defaultIfEmpty((String)manifest.getOrganization(), (String)this.organization);
            this.organizationUrl = StringUtils.defaultIfEmpty((String)manifest.getOrganizationUrl(), (String)this.organizationUrl);
            this.license = StringUtils.defaultIfEmpty((String)manifest.getLicense(), (String)this.license);
            this.termsConditionsUrl = StringUtils.defaultIfEmpty((String)manifest.getTermsConditionsUrl(), (String)this.termsConditionsUrl);
            this.developers = Arrays.asList(manifest.getDevelopers());
            this.description = StringUtils.defaultIfEmpty((String)this.description, (String)manifest.getDescription());
            this.issueTrackerUrl = StringUtils.defaultIfEmpty((String)this.issueTrackerUrl, (String)manifest.getIssueTrackerUrl());
            this.homepageUrl = StringUtils.defaultIfEmpty((String)this.homepageUrl, (String)manifest.getHomepage());
            this.sourcesUrl = StringUtils.defaultIfEmpty((String)this.sourcesUrl, (String)manifest.getSourcesUrl());
        }
        return this;
    }

    public Release getReleaseForSonarVersion(String alias, Version sonarVersion) {
        if ("OLDEST_COMPATIBLE".equals(alias)) {
            return this.getFirstCompatible(sonarVersion);
        }
        throw new UnsupportedOperationException(alias + " is not a supported alias for plugin");
    }

    public String toString() {
        return this.key;
    }
}

