/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.sonar.updatecenter.common.Artifact;
import org.sonar.updatecenter.common.Version;

public class Release
implements Comparable<Release> {
    private Artifact artifact;
    private Version version;
    private String displayVersion;
    private String description;
    private URL downloadUrl;
    private URL changelogUrl;
    private boolean isPublic;
    private boolean isArchived;
    private String groupId;
    private String artifactId;
    private Set<Release> outgoingDependencies;
    private Set<Release> incomingDependencies;
    private SortedSet<Version> compatibleSqVersions;
    private Date date;

    public Release(Artifact artifact, Version version) {
        this.artifact = artifact;
        this.version = version;
        this.isPublic = true;
        this.isArchived = false;
        this.compatibleSqVersions = new TreeSet<Version>();
        this.outgoingDependencies = new HashSet<Release>();
        this.incomingDependencies = new HashSet<Release>();
    }

    public Release(Artifact artifact, String version) {
        this(artifact, Version.create(version));
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public Version getVersion() {
        return this.version;
    }

    public Release setVersion(Version version) {
        this.version = version;
        return this;
    }

    public String getDisplayVersion() {
        return this.displayVersion;
    }

    public Release setDisplayVersion(String displayVersion) {
        this.displayVersion = displayVersion;
        return this;
    }

    public String getDownloadUrl() {
        return this.downloadUrl == null ? null : this.downloadUrl.toString();
    }

    public Release setDownloadUrl(@Nullable String downloadUrlString) {
        if (downloadUrlString == null) {
            this.downloadUrl = null;
        } else {
            try {
                this.downloadUrl = new URI(downloadUrlString).toURL();
            }
            catch (MalformedURLException | URISyntaxException ex) {
                throw new IllegalArgumentException("downloadUrl invalid", ex);
            }
        }
        return this;
    }

    @CheckForNull
    public String getFilename() {
        return this.downloadUrl == null ? null : StringUtils.substringAfterLast((String)this.downloadUrl.getPath(), (String)"/");
    }

    public SortedSet<Version> getRequiredSonarVersions() {
        return this.compatibleSqVersions;
    }

    public boolean supportSonarVersion(Version providedSqVersion) {
        for (Version sqVersion : this.compatibleSqVersions) {
            if (!sqVersion.isCompatibleWith(providedSqVersion)) continue;
            return true;
        }
        return false;
    }

    public Release addRequiredSonarVersions(Version ... versions) {
        if (versions != null) {
            this.compatibleSqVersions.addAll(Arrays.asList(versions));
        }
        return this;
    }

    public Release addRequiredSonarVersions(String ... versions) {
        if (versions != null) {
            for (String v : versions) {
                this.compatibleSqVersions.add(Version.create(v));
            }
        }
        return this;
    }

    public Version getLastRequiredSonarVersion() {
        if (!this.compatibleSqVersions.isEmpty()) {
            return this.compatibleSqVersions.last();
        }
        return null;
    }

    public Version getMinimumRequiredSonarVersion() {
        if (!this.compatibleSqVersions.isEmpty()) {
            return this.compatibleSqVersions.first();
        }
        return null;
    }

    public Version[] getSonarVersionFromString(String fromString) {
        Collection versionsWGivenFromString = this.compatibleSqVersions.stream().filter(Objects::nonNull).filter(sqVersion -> fromString.equals(sqVersion.getFromString())).collect(Collectors.toSet());
        return versionsWGivenFromString.toArray(new Version[versionsWGivenFromString.size()]);
    }

    @CheckForNull
    public Date getDate() {
        return this.date != null ? new Date(this.date.getTime()) : null;
    }

    public Release setDate(@Nullable Date date) {
        this.date = date != null ? new Date(date.getTime()) : null;
        return this;
    }

    @CheckForNull
    public String getDescription() {
        return this.description;
    }

    public Release setDescription(@Nullable String description) {
        this.description = description;
        return this;
    }

    @CheckForNull
    public String getChangelogUrl() {
        return this.changelogUrl == null ? null : this.changelogUrl.toString();
    }

    public Release setChangelogUrl(@Nullable String changelogUrlString) {
        if (changelogUrlString == null) {
            this.changelogUrl = null;
        } else {
            try {
                this.changelogUrl = new URI(changelogUrlString).toURL();
            }
            catch (MalformedURLException | URISyntaxException ex) {
                throw new IllegalArgumentException("changelogUrl invalid", ex);
            }
        }
        return this;
    }

    public Set<Release> getOutgoingDependencies() {
        return Collections.unmodifiableSet(new HashSet<Release>(this.outgoingDependencies));
    }

    public Release addOutgoingDependency(Release required) {
        this.outgoingDependencies.add(required);
        return this;
    }

    public Set<Release> getIncomingDependencies() {
        return Collections.unmodifiableSet(new HashSet<Release>(this.incomingDependencies));
    }

    public Release addIncomingDependency(Release required) {
        this.incomingDependencies.add(required);
        return this;
    }

    public String getKey() {
        return this.getArtifact().getKey();
    }

    public Version getAdjustedVersion() {
        return this.version.removeQualifier();
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public boolean isArchived() {
        return this.isArchived;
    }

    public void setArchived(boolean isArchived) {
        this.isArchived = isArchived;
    }

    @CheckForNull
    public String groupId() {
        return this.groupId;
    }

    public void setGroupId(@Nullable String groupId) {
        this.groupId = groupId;
    }

    @CheckForNull
    public String artifactId() {
        return this.artifactId;
    }

    public void setArtifactId(@Nullable String artifactId) {
        this.artifactId = artifactId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Release release = (Release)o;
        return this.artifact.equals(release.artifact) && this.version.equals(release.version);
    }

    public int hashCode() {
        int result = this.artifact.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("version", (Object)this.version).append("downloadUrl", (Object)this.downloadUrl).append("changelogUrl", (Object)this.changelogUrl).append("description", (Object)this.description).toString();
    }

    @Override
    public int compareTo(Release o) {
        return this.getVersion().compareTo(o.getVersion());
    }
}

