/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public final class PluginKeyUtils {
    private static final String SONAR_PLUGIN_SUFFIX = "-sonar-plugin";
    private static final String SONAR_PREFIX = "sonar-";
    private static final String PLUGIN_SUFFIX = "-plugin";

    private PluginKeyUtils() {
    }

    @CheckForNull
    public static String sanitize(@Nullable String mavenArtifactId) {
        if (mavenArtifactId == null) {
            return null;
        }
        String key = mavenArtifactId;
        if (StringUtils.startsWith((String)mavenArtifactId, (String)SONAR_PREFIX) && StringUtils.endsWith((String)mavenArtifactId, (String)PLUGIN_SUFFIX)) {
            key = StringUtils.removeEnd((String)StringUtils.removeStart((String)mavenArtifactId, (String)SONAR_PREFIX), (String)PLUGIN_SUFFIX);
        } else if (StringUtils.endsWith((String)mavenArtifactId, (String)SONAR_PLUGIN_SUFFIX)) {
            key = StringUtils.removeEnd((String)mavenArtifactId, (String)SONAR_PLUGIN_SUFFIX);
        }
        return PluginKeyUtils.keepLettersAndDigits(key);
    }

    private static String keepLettersAndDigits(String key) {
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < key.length(); ++index) {
            char character = key.charAt(index);
            if (!Character.isLetter(character) && !Character.isDigit(character)) continue;
            sb.append(character);
        }
        return sb.toString();
    }

    public static boolean isValid(String pluginKey) {
        return StringUtils.isNotBlank((String)pluginKey) && StringUtils.isAlphanumeric((String)pluginKey);
    }
}

