/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.updatecenter.common.Component;
import org.sonar.updatecenter.common.PluginManifest;
import org.sonar.updatecenter.common.Release;
import org.sonar.updatecenter.common.Version;

public class Plugin
extends Component {
    private Plugin(String key) {
        super(key);
    }

    public static Plugin factory(String key) {
        if (StringUtils.isAlphanumeric((String)key)) {
            return new Plugin(key);
        }
        throw new IllegalArgumentException("plugin key must be alphanumeric, strictly");
    }

    @Override
    public Plugin setName(String name) {
        return (Plugin)super.setName(name);
    }

    @Override
    public Plugin setDescription(String description) {
        return (Plugin)super.setDescription(description);
    }

    @Override
    public Plugin setHomepageUrl(String url) {
        return (Plugin)super.setHomepageUrl(url);
    }

    @Override
    public Plugin setLicense(String license) {
        return (Plugin)super.setLicense(license);
    }

    @Override
    public Plugin setOrganization(String organization) {
        return (Plugin)super.setOrganization(organization);
    }

    @Override
    public Plugin setOrganizationUrl(String url) {
        return (Plugin)super.setOrganizationUrl(url);
    }

    @Override
    public Plugin setCategory(String category) {
        return (Plugin)super.setCategory(category);
    }

    @Override
    public Plugin setTermsConditionsUrl(String url) {
        return (Plugin)super.setTermsConditionsUrl(url);
    }

    @Override
    public Plugin setIssueTrackerUrl(String url) {
        return (Plugin)super.setIssueTrackerUrl(url);
    }

    @Override
    public Plugin setSourcesUrl(String sourcesUrl) {
        return (Plugin)super.setSourcesUrl(sourcesUrl);
    }

    public Plugin setDevelopers(List developers) {
        return (Plugin)super.setDevelopers(developers);
    }

    @Override
    boolean needArtifact() {
        return true;
    }

    @Override
    boolean needSqVersion() {
        return true;
    }

    public Plugin merge(PluginManifest manifest) {
        if (StringUtils.equals((String)this.key, (String)manifest.getKey())) {
            this.name = manifest.getName();
            this.organization = StringUtils.defaultIfEmpty((String)manifest.getOrganization(), (String)this.organization);
            this.organizationUrl = StringUtils.defaultIfEmpty((String)manifest.getOrganizationUrl(), (String)this.organizationUrl);
            this.license = StringUtils.defaultIfEmpty((String)manifest.getLicense(), (String)this.license);
            this.termsConditionsUrl = StringUtils.defaultIfEmpty((String)manifest.getTermsConditionsUrl(), (String)this.termsConditionsUrl);
            this.developers = Arrays.asList(manifest.getDevelopers());
            this.description = StringUtils.defaultIfEmpty((String)this.description, (String)manifest.getDescription());
            this.issueTrackerUrl = StringUtils.defaultIfEmpty((String)this.issueTrackerUrl, (String)manifest.getIssueTrackerUrl());
            this.homepageUrl = StringUtils.defaultIfEmpty((String)this.homepageUrl, (String)manifest.getHomepage());
            this.sourcesUrl = StringUtils.defaultIfEmpty((String)this.sourcesUrl, (String)manifest.getSourcesUrl());
        }
        return this;
    }

    public Release getReleaseForSonarVersion(String alias, Version sonarVersion) {
        if ("OLDEST_COMPATIBLE".equals(alias)) {
            return this.getFirstCompatible(sonarVersion);
        }
        throw new UnsupportedOperationException(alias + " is not a supported alias for plugin");
    }
}

