/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import java.util.LinkedHashMap;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.updatecenter.common.Product;
import org.sonar.updatecenter.common.Release;
import org.sonar.updatecenter.common.Version;

public abstract class Artifact
implements Comparable<Artifact> {
    protected String key;
    protected SortedSet<Release> releases = new TreeSet<Release>();
    private Release devRelease;

    protected Artifact(String key) {
        this.key = key;
    }

    public final String getKey() {
        return this.key;
    }

    public final Artifact setKey(String key) {
        this.key = key;
        return this;
    }

    public final Release setDevRelease(Release release) {
        this.devRelease = release;
        return release;
    }

    public Release getDevRelease() {
        return this.devRelease;
    }

    public final Release addRelease(Release release) {
        this.releases.add(release);
        return release;
    }

    public final Release getRelease(Version version) {
        return this.getRelease(version, null);
    }

    public final Release getRelease(Version version, @Nullable Product product) {
        for (Release release : this.getAllReleases(product)) {
            if (!release.getVersion().equals(version)) continue;
            return release;
        }
        throw new NoSuchElementException("Unable to find a release of plugin " + this.key + " with version " + version);
    }

    public boolean doesContainVersion(Version version) {
        for (Release release : this.getAllReleases()) {
            if (!release.getVersion().equals(version)) continue;
            return true;
        }
        return false;
    }

    public Release getRelease(String versionOrAliases) {
        return this.getRelease(versionOrAliases, null);
    }

    public Release getRelease(String versionOrAliases, @Nullable Product product) {
        if ("DEV".equals(versionOrAliases)) {
            return this.getDevRelease();
        }
        if ("LATEST_RELEASE".equals(versionOrAliases)) {
            return this.getLastRelease();
        }
        return this.getRelease(Version.create(versionOrAliases), product);
    }

    public final SortedSet<Release> getReleases() {
        return this.releases;
    }

    public final SortedSet<Release> getReleases(@Nullable Product product) {
        return this.releases.stream().filter(r -> r.getProduct() == product).collect(TreeSet::new, TreeSet::add, TreeSet::addAll);
    }

    public final SortedSet<Release> getReleasesGreaterThan(String version, @Nullable Product product) {
        return this.getReleasesGreaterThan(Version.create(version), product);
    }

    public final SortedSet<Release> getReleasesGreaterThan(Version version, @Nullable Product product) {
        TreeSet<Release> result = new TreeSet<Release>();
        for (Release release : this.getAllReleases(product)) {
            if (release.getVersion().compareToIgnoreQualifier(version) <= 0) continue;
            result.add(release);
        }
        return result;
    }

    public final SortedSet<Version> getVersions() {
        TreeSet<Version> versions = new TreeSet<Version>();
        for (Release release : this.releases) {
            if (release.isArchived()) continue;
            versions.add(release.getVersion());
        }
        return versions;
    }

    public final SortedSet<Version> getPublicVersions() {
        return this.getPublicVersions(null);
    }

    public final SortedSet<Version> getPublicVersions(@Nullable Product product) {
        TreeSet<Version> versions = new TreeSet<Version>();
        for (Release release : this.releases) {
            if (release.getProduct() != product || !release.isPublic()) continue;
            versions.add(release.getVersion());
        }
        return versions;
    }

    public final SortedSet<Release> getPublicReleases() {
        TreeSet<Release> publicReleases = new TreeSet<Release>();
        for (Release release : this.releases) {
            if (!release.isPublic()) continue;
            publicReleases.add(release);
        }
        return publicReleases;
    }

    public final SortedSet<Release> getArchivedReleases() {
        TreeSet<Release> archivedReleases = new TreeSet<Release>();
        for (Release release : this.releases) {
            if (!release.isArchived()) continue;
            archivedReleases.add(release);
        }
        return archivedReleases;
    }

    public final SortedSet<Version> getPrivateVersions() {
        TreeSet<Version> versions = new TreeSet<Version>();
        for (Release release : this.releases) {
            if (release.isPublic() || release.isArchived()) continue;
            versions.add(release.getVersion());
        }
        return versions;
    }

    public final SortedSet<Version> getArchivedVersions() {
        TreeSet<Version> versions = new TreeSet<Version>();
        for (Release release : this.releases) {
            if (!release.isArchived()) continue;
            versions.add(release.getVersion());
        }
        return versions;
    }

    @CheckForNull
    public final Release getLastRelease() {
        return this.getLastRelease(null);
    }

    @CheckForNull
    public final Release getLastRelease(@Nullable Product product) {
        return this.getReleases(product).isEmpty() ? null : this.getReleases(product).last();
    }

    @CheckForNull
    public final Release getLastCompatible(Release release) {
        return this.getLastCompatible(release.getVersion(), release.getProduct());
    }

    @CheckForNull
    public final Release getLastCompatible(Version version, Product product) {
        Release result = null;
        for (Release r : this.getReleases()) {
            if (!r.supportSonarVersion(version, product)) continue;
            result = r;
        }
        return result;
    }

    @CheckForNull
    public final Release getLastCompatibleIncludingDev(Version sonarVersion, Product product) {
        Release result = null;
        for (Release r : this.getAllReleases()) {
            if (!r.supportSonarVersion(sonarVersion, product)) continue;
            result = r;
        }
        return result;
    }

    @CheckForNull
    public final Release getFirstCompatible(Version sonarVersion, Product product) {
        for (Release r : this.getAllReleases()) {
            if (!r.supportSonarVersion(sonarVersion, product)) continue;
            return r;
        }
        return null;
    }

    @CheckForNull
    public final Release getMinimalRelease(Version minimalVersion) {
        for (Release r : this.getAllReleases()) {
            if (r.getVersion().compareToIgnoreQualifier(minimalVersion) < 0) continue;
            return r;
        }
        return null;
    }

    @CheckForNull
    public final Release getLastCompatibleReleaseIfUpgrade(Version sonarVersion, Product product) {
        Release result = null;
        for (Release r : this.getAllReleases()) {
            if (r.getLastRequiredSonarVersion(product) == null || r.getLastRequiredSonarVersion(product).compareToIgnoreQualifier(sonarVersion) < 0) continue;
            result = r;
        }
        return result;
    }

    public SortedSet<Release> getAllReleases() {
        return this.getAllReleases(null);
    }

    public SortedSet<Release> getAllReleases(@Nullable Product product) {
        TreeSet<Release> all = new TreeSet<Release>();
        all.addAll(this.getReleases(product));
        if (this.getDevRelease() != null) {
            all.add(this.getDevRelease());
        }
        return all;
    }

    public SortedSet<Release> getMajorReleases() {
        return this.getMajorReleases(null);
    }

    public SortedSet<Release> getMajorReleases(@Nullable Product product) {
        LinkedHashMap<String, Release> majorVersions = new LinkedHashMap<String, Release>();
        for (Release sq : this.getAllReleases(product)) {
            String displayVersion = sq.getVersion().getMajor() + "." + sq.getVersion().getMinor();
            majorVersions.put(displayVersion, sq);
        }
        return new TreeSet<Release>(majorVersions.values());
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Artifact)) {
            return false;
        }
        Artifact artifact = (Artifact)o;
        return this.key.equals(artifact.key);
    }

    public final int hashCode() {
        return this.key.hashCode();
    }

    @Override
    public final int compareTo(Artifact other) {
        if (this.key == null) {
            return -1;
        }
        return this.key.compareTo(other.key);
    }
}

