/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.updatecenter.common.FormatUtils;
import org.sonar.updatecenter.common.Plugin;
import org.sonar.updatecenter.common.Product;
import org.sonar.updatecenter.common.Release;
import org.sonar.updatecenter.common.UpdateCenter;
import org.sonar.updatecenter.common.UpdateCenterDeserializer;
import org.sonar.updatecenter.common.Version;

public final class UpdateCenterSerializer {
    private UpdateCenterSerializer() {
    }

    private static void set(Properties props, String key, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            props.setProperty(key, value);
        }
    }

    private static void set(Properties props, String key, @Nullable Collection values) {
        if (values != null && !values.isEmpty()) {
            props.setProperty(key, StringUtils.join((Collection)values, (String)","));
        }
    }

    private static void set(Properties props, Plugin plugin, String key, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            props.setProperty(plugin.getKey() + "." + key, value);
        }
    }

    private static void set(Properties props, Plugin plugin, String key, @Nullable Collection values) {
        if (values != null && !values.isEmpty()) {
            props.setProperty(plugin.getKey() + "." + key, StringUtils.join((Collection)values, (String)","));
        }
    }

    public static Properties toProperties(UpdateCenter center) {
        Properties p = new Properties();
        UpdateCenterSerializer.set(p, "date", FormatUtils.toString(center.getDate(), true));
        SortedSet<Version> publicVersions = UpdateCenterSerializer.determinePublicVersionsField(center);
        UpdateCenterSerializer.set(p, "publicVersions", publicVersions);
        UpdateCenterSerializer.set(p, Product.SONARQUBE_COMMUNITY_BUILD.getSuffix(), center.getSonar().getPublicVersions(Product.SONARQUBE_COMMUNITY_BUILD));
        UpdateCenterSerializer.set(p, Product.SONARQUBE_SERVER.getSuffix(), center.getSonar().getPublicVersions(Product.SONARQUBE_SERVER));
        if (!center.getSonar().getPrivateVersions().isEmpty()) {
            UpdateCenterSerializer.set(p, "privateVersions", center.getSonar().getPrivateVersions());
        }
        if (center.getSonar().getDevRelease() != null) {
            UpdateCenterSerializer.set(p, "devVersion", center.getSonar().getDevRelease().getVersion().toString());
        }
        UpdateCenterSerializer.set(p, "sonar.versions", center.getSonar().getVersions());
        if (center.getSonar().getLtsRelease() != null) {
            UpdateCenterSerializer.set(p, "ltsVersion", center.getSonar().getLtsRelease().getVersion().toString());
        }
        if (center.getSonar().getLtaVersion() != null) {
            UpdateCenterSerializer.set(p, "ltaVersion", center.getSonar().getLtaVersion().getVersion().toString());
        }
        if (center.getSonar().getPastLtaVersion() != null) {
            UpdateCenterSerializer.set(p, "pastLtaVersion", center.getSonar().getPastLtaVersion().getVersion().toString());
        }
        for (Product product : Product.values()) {
            UpdateCenterSerializer.setProductProperties(center, p, product);
        }
        ArrayList<String> pluginKeys = new ArrayList<String>();
        for (Plugin plugin : center.getUpdateCenterPluginReferential().getPlugins()) {
            UpdateCenterSerializer.addPlugin(plugin, pluginKeys, p);
        }
        UpdateCenterSerializer.set(p, "plugins", pluginKeys);
        return p;
    }

    private static SortedSet<Version> determinePublicVersionsField(UpdateCenter center) {
        SortedSet<Version> publicVersions = center.getSonar().getPublicVersions(Product.OLD_SONARQUBE);
        Set newSonarQubes = center.getSonar().getPublicVersions(Product.SONARQUBE_SERVER).stream().filter(version -> version.equals(Version.create("10.8")) || version.equals(Version.create("2025.1"))).collect(Collectors.toSet());
        publicVersions.addAll(newSonarQubes);
        return publicVersions;
    }

    private static void setProductProperties(UpdateCenter center, Properties p, Product product) {
        for (Release sonarRelease : center.getSonar().getAllReleases(product)) {
            UpdateCenterSerializer.set(p, sonarRelease.getVersion() + ".changelogUrl", sonarRelease.getChangelogUrl());
            UpdateCenterSerializer.set(p, sonarRelease.getVersion() + ".displayVersion", sonarRelease.getDisplayVersion());
            UpdateCenterSerializer.set(p, sonarRelease.getVersion() + ".description", sonarRelease.getDescription());
            UpdateCenterSerializer.set(p, sonarRelease.getVersion() + ".date", FormatUtils.toString(sonarRelease.getDate(), false));
            for (Release.Edition edition : Release.Edition.values()) {
                String downloadUrl = sonarRelease.getDownloadUrl(edition);
                if (downloadUrl == null) continue;
                UpdateCenterSerializer.set(p, sonarRelease.getVersion() + UpdateCenterDeserializer.getDownloadUrlSuffix(edition), downloadUrl);
            }
            if (product != Product.OLD_SONARQUBE) continue;
            UpdateCenterSerializer.set(p, "sonar." + sonarRelease.getVersion() + ".downloadUrl", sonarRelease.getDownloadUrl());
            UpdateCenterSerializer.set(p, "sonar." + sonarRelease.getVersion() + ".changelogUrl", sonarRelease.getChangelogUrl());
            UpdateCenterSerializer.set(p, "sonar." + sonarRelease.getVersion() + ".description", sonarRelease.getDescription());
            UpdateCenterSerializer.set(p, "sonar." + sonarRelease.getVersion() + ".date", FormatUtils.toString(sonarRelease.getDate(), false));
        }
    }

    private static void addPlugin(Plugin plugin, List<String> pluginKeys, Properties p) {
        pluginKeys.add(plugin.getKey());
        UpdateCenterSerializer.set(p, plugin, "name", plugin.getName());
        UpdateCenterSerializer.set(p, plugin, "description", plugin.getDescription());
        UpdateCenterSerializer.set(p, plugin, "category", plugin.getCategory());
        UpdateCenterSerializer.set(p, plugin, "homepageUrl", plugin.getHomepageUrl());
        UpdateCenterSerializer.set(p, plugin, "license", plugin.getLicense());
        UpdateCenterSerializer.set(p, plugin, "organization", plugin.getOrganization());
        UpdateCenterSerializer.set(p, plugin, "organizationUrl", plugin.getOrganizationUrl());
        UpdateCenterSerializer.set(p, plugin, "termsConditionsUrl", plugin.getTermsConditionsUrl());
        UpdateCenterSerializer.set(p, plugin, "issueTrackerUrl", plugin.getIssueTrackerUrl());
        UpdateCenterSerializer.set(p, plugin, "scm", plugin.getSourcesUrl());
        UpdateCenterSerializer.set(p, plugin, "developers", StringUtils.join(plugin.getDevelopers(), (String)","));
        for (Release release : plugin.getAllReleases()) {
            UpdateCenterSerializer.set(p, plugin, release.getVersion() + "." + Product.OLD_SONARQUBE.getSuffix(), StringUtils.join(release.getRequiredSonarVersions(), (String)","));
            UpdateCenterSerializer.set(p, plugin, release.getVersion() + "." + Product.SONARQUBE_COMMUNITY_BUILD.getSuffix(), StringUtils.join(release.getRequiredCommunitySonarVersions(), (String)","));
            UpdateCenterSerializer.set(p, plugin, release.getVersion() + "." + Product.SONARQUBE_SERVER.getSuffix(), StringUtils.join(release.getRequiredPaidSonarVersions(), (String)","));
            UpdateCenterSerializer.set(p, plugin, release.getVersion() + ".requiredSonarVersions", StringUtils.join(release.getRequiredSonarVersions(), (String)","));
            UpdateCenterSerializer.set(p, plugin, release.getVersion() + ".downloadUrl", release.getDownloadUrl());
            UpdateCenterSerializer.set(p, plugin, release.getVersion() + ".changelogUrl", release.getChangelogUrl());
            UpdateCenterSerializer.set(p, plugin, release.getVersion() + ".displayVersion", release.getDisplayVersion());
            UpdateCenterSerializer.set(p, plugin, release.getVersion() + ".description", release.getDescription());
            UpdateCenterSerializer.set(p, plugin, release.getVersion() + ".mavenGroupId", release.groupId());
            UpdateCenterSerializer.set(p, plugin, release.getVersion() + ".mavenArtifactId", release.artifactId());
            UpdateCenterSerializer.set(p, plugin, release.getVersion() + ".date", FormatUtils.toString(release.getDate(), false));
            UpdateCenterSerializer.set(p, plugin, release.getVersion() + ".requirePlugins", StringUtils.join((Object[])UpdateCenterSerializer.getRequiredList(release), (String)","));
        }
        UpdateCenterSerializer.set(p, plugin, "publicVersions", plugin.getPublicVersions());
        if (!plugin.getPrivateVersions().isEmpty()) {
            UpdateCenterSerializer.set(p, plugin, "privateVersions", plugin.getPrivateVersions());
        }
        if (!plugin.getArchivedVersions().isEmpty()) {
            UpdateCenterSerializer.set(p, plugin, "archivedVersions", plugin.getArchivedVersions());
        }
        if (plugin.getDevRelease() != null) {
            UpdateCenterSerializer.set(p, plugin, "devVersion", plugin.getDevRelease().getVersion().toString());
        }
        UpdateCenterSerializer.set(p, plugin, "versions", plugin.getVersions());
    }

    public static void toProperties(UpdateCenter sonar, File toFile) {
        try (OutputStream output = Files.newOutputStream(toFile.toPath(), new OpenOption[0]);){
            UpdateCenterSerializer.toProperties(sonar).store(output, "Generated file");
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to store update center properties to: " + toFile.getAbsolutePath(), e);
        }
    }

    private static String[] getRequiredList(Release release) {
        ArrayList<String> requiredStringList = new ArrayList<String>();
        for (Release requiredRelease : release.getOutgoingDependencies()) {
            requiredStringList.add(requiredRelease.getArtifact().getKey() + ":" + requiredRelease.getVersion().getName());
        }
        return requiredStringList.toArray(new String[0]);
    }
}

