/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import org.apache.commons.lang.StringUtils;

public class Version
implements Comparable<Version> {
    private String normalizedMajor = Version.normalizePart("0");
    private String normalizedMinor = Version.normalizePart("0");
    private String normalizedPatch = Version.normalizePart("0");
    private String normalizedPatch2 = Version.normalizePart("0");
    private String major = "0";
    private String minor = "0";
    private String patch = "0";
    private String patch2 = "0";
    private String qualifier;
    private String name;
    private String fromString;

    protected Version(String version, String fromString) {
        this.name = StringUtils.trimToEmpty((String)version);
        this.qualifier = StringUtils.substringAfter((String)this.name, (String)"-");
        String numbers = StringUtils.substringBefore((String)this.name, (String)"-");
        String[] split = StringUtils.split((String)numbers, (char)'.');
        if (split.length >= 1) {
            this.major = split[0];
            this.normalizedMajor = Version.normalizePart(this.major);
        }
        if (split.length >= 2) {
            this.minor = split[1];
            this.normalizedMinor = Version.normalizePart(this.minor);
        }
        if (split.length >= 3) {
            this.patch = split[2];
            this.normalizedPatch = Version.normalizePart(this.patch);
        }
        if (split.length >= 4) {
            this.patch2 = split[3];
            this.normalizedPatch2 = Version.normalizePart(this.patch2);
        }
        this.fromString = fromString;
    }

    private static String normalizePart(String part) {
        return StringUtils.leftPad((String)part, (int)4, (char)'0');
    }

    public String getMajor() {
        return this.major;
    }

    public String getMinor() {
        return this.minor;
    }

    public String getPatch() {
        return this.patch;
    }

    public String getPatch2() {
        return this.patch2;
    }

    public String getName() {
        return this.name;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getFromString() {
        return this.fromString;
    }

    public boolean isPatchVersion() {
        return !this.patch.equals("0");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version other = (Version)o;
        return this.normalizedMajor.equals(other.normalizedMajor) && this.normalizedMinor.equals(other.normalizedMinor) && this.normalizedPatch.equals(other.normalizedPatch) && this.normalizedPatch2.equals(other.normalizedPatch2) && this.qualifier.equals(other.qualifier);
    }

    public int hashCode() {
        int result = this.normalizedMajor.hashCode();
        result = 31 * result + this.normalizedMinor.hashCode();
        result = 31 * result + this.normalizedPatch.hashCode();
        result = 31 * result + this.normalizedPatch2.hashCode();
        result = 31 * result + this.qualifier.hashCode();
        return result;
    }

    @Override
    public int compareTo(Version other) {
        int c = this.compareToIgnoreQualifier(other);
        if (c == 0) {
            c = "".equals(this.qualifier) ? ("".equals(other.qualifier) ? 0 : 1) : ("".equals(other.qualifier) ? -1 : this.qualifier.compareTo(other.qualifier));
        }
        return c;
    }

    public int compareToIgnoreQualifier(Version other) {
        int c = this.normalizedMajor.compareTo(other.normalizedMajor);
        if (c == 0 && (c = this.normalizedMinor.compareTo(other.normalizedMinor)) == 0 && (c = this.normalizedPatch.compareTo(other.normalizedPatch)) == 0) {
            c = this.normalizedPatch2.compareTo(other.normalizedPatch2);
        }
        return c;
    }

    public String toString() {
        return this.name;
    }

    public static Version create(String versionStr) {
        return new Version(versionStr, versionStr);
    }

    public static Version create(String versionStr, String fromString) {
        return new Version(versionStr, fromString);
    }

    public static Version create(Version version, String fromString) {
        return new Version(version.name, fromString);
    }

    public static boolean isSnapshot(String version) {
        return StringUtils.endsWith((String)version, (String)"SNAPSHOT");
    }

    public Version removeQualifier() {
        String versionStringBeforeQualifier = StringUtils.substringBefore((String)this.toString(), (String)"-");
        return new Version(versionStringBeforeQualifier, versionStringBeforeQualifier);
    }

    public boolean isCompatibleWith(Version version) {
        return this.removeQualifier().equals(version.removeQualifier());
    }
}

