/*
 * Decompiled with CFR 0.152.
 */
package soot;

import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import soot.ClassProvider;
import soot.ClassSource;
import soot.CompilationDeathException;
import soot.FoundFile;
import soot.G;
import soot.JavaClassProvider;
import soot.ModuleScene;
import soot.ModuleUtil;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootModuleInfo;
import soot.SootModuleResolver;
import soot.SourceLocator;
import soot.asm.AsmModuleClassProvider;

public class ModulePathSourceLocator
extends SourceLocator {
    public static final String DUMMY_CLASSPATH_JDK9_FS = "VIRTUAL_FS_FOR_JDK";
    private List<String> sourcePath;
    private Set<String> classesToLoad;
    private List<String> modulePath;
    private int next = 0;
    private final HashMap<String, Path> moduleNameToPath = new HashMap();

    public ModulePathSourceLocator(Singletons.Global g) {
        super(g);
    }

    public static ModulePathSourceLocator v() {
        return G.v().soot_ModulePathSourceLocator();
    }

    @Override
    public ClassSource getClassSource(String className) {
        ModuleUtil.ModuleClassNameWrapper wrapper = ModuleUtil.v().makeWrapper(className);
        return this.getClassSource(wrapper.getClassName(), wrapper.getModuleNameOptional());
    }

    public ClassSource getClassSource(String className, Optional<String> moduleName) {
        String appendToPath = "";
        if (moduleName.isPresent()) {
            appendToPath = (String)moduleName.get() + ":";
        }
        if (this.classesToLoad == null) {
            this.classesToLoad = new HashSet<String>();
            this.classesToLoad.addAll(ModuleScene.v().getBasicClasses());
            for (SootClass c : ModuleScene.v().getApplicationClasses()) {
                this.classesToLoad.add(c.getName());
            }
        }
        if (this.modulePath == null) {
            this.modulePath = ModulePathSourceLocator.explodeModulePath(ModuleScene.v().getSootModulePath());
        }
        if (this.classProviders == null) {
            this.setupClassProviders();
        }
        JavaClassProvider.JarException ex = null;
        for (ClassProvider cp : this.classProviders) {
            try {
                ClassSource ret = cp.find(appendToPath + className);
                if (ret == null) continue;
                return ret;
            }
            catch (JavaClassProvider.JarException e) {
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
        return null;
    }

    public static List<String> explodeModulePath(String classPath) {
        ArrayList<String> ret = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(classPath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String originalDir = tokenizer.nextToken();
            try {
                String canonicalDir = new File(originalDir).getCanonicalPath();
                if (originalDir.equals(DUMMY_CLASSPATH_JDK9_FS)) {
                    canonicalDir = "jrt:/";
                }
                ret.add(canonicalDir);
            }
            catch (IOException e) {
                throw new CompilationDeathException("Couldn't resolve classpath entry " + originalDir + ": " + e);
            }
        }
        return ret;
    }

    @Override
    public void additionalClassLoader(ClassLoader c) {
        this.additionalClassLoaders.add(c);
    }

    private boolean modulePathHasNextEntry() {
        return this.next < this.modulePath.size();
    }

    @Override
    public List<String> classPath() {
        return this.modulePath;
    }

    @Override
    public void invalidateClassPath() {
        this.modulePath = null;
        super.invalidateClassPath();
    }

    @Override
    public List<String> sourcePath() {
        if (this.sourcePath == null) {
            this.sourcePath = new ArrayList<String>();
            for (String dir : this.modulePath) {
                SourceLocator.ClassSourceType cst = this.getClassSourceType(dir);
                if (cst == SourceLocator.ClassSourceType.apk || cst == SourceLocator.ClassSourceType.jar || cst == SourceLocator.ClassSourceType.zip) continue;
                this.sourcePath.add(dir);
            }
        }
        return this.sourcePath;
    }

    @Override
    public List<String> getClassesUnder(String aPath) {
        Map<String, List<String>> moduleClasses = this.getClassUnderModulePath(aPath);
        ArrayList<String> classes = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : moduleClasses.entrySet()) {
            for (String className : entry.getValue()) {
                String moduleClassNameConcatenation = entry.getKey() + ":" + className;
                classes.add(moduleClassNameConcatenation);
            }
        }
        return classes;
    }

    public Map<String, List<String>> getClassUnderModulePath(String aPath) {
        HashMap<String, List<String>> mapModuleClasses = new HashMap<String, List<String>>();
        Path path = null;
        SourceLocator.ClassSourceType type = this.getClassSourceType(aPath);
        switch (type) {
            case jar: {
                path = Paths.get(aPath, new String[0]);
                break;
            }
            case zip: {
                path = Paths.get(aPath, new String[0]);
                break;
            }
            case directory: {
                path = Paths.get(aPath, new String[0]);
                break;
            }
            case jrt: {
                path = ModulePathSourceLocator.getRootModulesPathOfJDK();
                break;
            }
            case unknown: {
                break;
            }
            default: {
                path = Paths.get(aPath, new String[0]);
            }
        }
        if (this.classProviders == null) {
            this.setupClassProviders();
        }
        if (path == null) {
            throw new RuntimeException("[Error] The path " + aPath + "is not a valid path.");
        }
        BasicFileAttributes attrs = null;
        try {
            attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (attrs.isDirectory()) {
            Path mi = path.resolve("module-info.class");
            if (!Files.exists(mi, new LinkOption[0])) {
                mapModuleClasses.putAll(this.discoverModulesIn(path));
            } else {
                mapModuleClasses.putAll(this.buildModuleForExplodedModule(path));
            }
        } else if (attrs.isRegularFile() && path.getFileName().toString().endsWith(".jar")) {
            mapModuleClasses.putAll(this.buildModuleForJar(path));
        }
        return mapModuleClasses;
    }

    public static Path getRootModulesPathOfJDK() {
        Path p = Paths.get(URI.create("jrt:/"));
        if (p.endsWith("modules")) {
            return p;
        }
        return p.resolve("modules");
    }

    private Map<String, List<String>> discoverModulesIn(Path path) {
        HashMap<String, List<String>> mapModuleClasses = new HashMap<String, List<String>>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
            for (Path entry : stream) {
                BasicFileAttributes attrs;
                try {
                    attrs = Files.readAttributes(entry, BasicFileAttributes.class, new LinkOption[0]);
                }
                catch (NoSuchFileException ignore) {
                    continue;
                }
                if (attrs.isDirectory()) {
                    Path mi = entry.resolve("module-info.class");
                    if (!Files.exists(mi, new LinkOption[0])) continue;
                    mapModuleClasses.putAll(this.buildModuleForExplodedModule(entry));
                    continue;
                }
                if (!attrs.isRegularFile() || !entry.getFileName().toString().endsWith(".jar")) continue;
                mapModuleClasses.putAll(this.buildModuleForJar(entry));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return mapModuleClasses;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, List<String>> buildModuleForJar(Path jar) {
        Iterator iterator;
        FoundFile foundFile;
        HashMap<String, List<String>> moduleClassMap;
        block24: {
            moduleClassMap = new HashMap<String, List<String>>();
            try (FileSystem zipFileSystem = FileSystems.newFileSystem(jar, this.getClass().getClassLoader());){
                Path mi = zipFileSystem.getPath("module-info.class", new String[0]);
                if (!Files.exists(mi, new LinkOption[0])) {
                    SootModuleInfo moduleInfo;
                    String filename = jar.getFileName().toString();
                    String moduleName = this.createModuleNameForAutomaticModule(filename);
                    boolean containsClass = ModuleScene.v().containsClass("module-info", (Optional<String>)Optional.of((Object)moduleName));
                    if (!containsClass) {
                        moduleInfo = new SootModuleInfo("module-info", moduleName, true);
                        Scene.v().addClass(moduleInfo);
                        moduleInfo.setApplicationClass();
                    } else {
                        moduleInfo = (SootModuleInfo)ModuleScene.v().getSootClass("module-info", (Optional<String>)Optional.of((Object)moduleName));
                        if (moduleInfo.resolvingLevel() != 0) {
                            HashMap<String, List<String>> moduleInfo2 = moduleClassMap;
                            return moduleInfo2;
                        }
                    }
                    List<String> classesInJar = super.getClassesUnder(jar.toAbsolutePath().toString());
                    for (String foundClass : classesInJar) {
                        int index = foundClass.lastIndexOf(46);
                        if (index <= 0) continue;
                        String packageName = foundClass.substring(0, index);
                        moduleInfo.addModulePackage(packageName);
                    }
                    moduleInfo.setResolvingLevel(3);
                    moduleInfo.setAutomaticModule(true);
                    this.moduleNameToPath.put(moduleName, jar);
                    moduleClassMap.put(moduleName, classesInJar);
                    return moduleClassMap;
                }
                foundFile = new FoundFile(mi);
                iterator = this.classProviders.iterator();
                break block24;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return moduleClassMap;
        }
        while (iterator.hasNext()) {
            ClassProvider cp = (ClassProvider)iterator.next();
            if (!(cp instanceof AsmModuleClassProvider)) continue;
            String moduleName = ((AsmModuleClassProvider)cp).getModuleName(foundFile);
            SootModuleInfo moduleInfo2 = (SootModuleInfo)SootModuleResolver.v().makeClassRef("module-info", (Optional<String>)Optional.of((Object)moduleName));
            this.moduleNameToPath.put(moduleName, jar);
            List<String> classesInJar = super.getClassesUnder(jar.toAbsolutePath().toString());
            for (String foundClass : classesInJar) {
                int index = foundClass.lastIndexOf(46);
                if (index <= 0) continue;
                String packageName = foundClass.substring(0, index);
                moduleInfo2.addModulePackage(packageName);
            }
            moduleClassMap.put(moduleName, classesInJar);
        }
        return moduleClassMap;
    }

    private String createModuleNameForAutomaticModule(String filename) {
        int i = filename.lastIndexOf(File.separator);
        if (i != -1) {
            filename = filename.substring(i + 1);
        }
        String moduleName = filename.substring(0, filename.length() - 4);
        Matcher matcher = Pattern.compile("-(\\d+(\\.|$))").matcher(moduleName);
        if (matcher.find()) {
            int start = matcher.start();
            moduleName = moduleName.substring(0, start);
        }
        moduleName = Pattern.compile("[^A-Za-z0-9]").matcher(moduleName).replaceAll(".");
        moduleName = Pattern.compile("(\\.)(\\1)+").matcher(moduleName).replaceAll(".");
        int len = moduleName.length();
        if (len > 0 && moduleName.charAt(0) == '.') {
            moduleName = Pattern.compile("^\\.").matcher(moduleName).replaceAll("");
        }
        if ((len = moduleName.length()) > 0 && moduleName.charAt(len - 1) == '.') {
            moduleName = Pattern.compile("\\.$").matcher(moduleName).replaceAll("");
        }
        return moduleName;
    }

    private Map<String, List<String>> buildModuleForExplodedModule(Path dir) {
        HashMap<String, List<String>> moduleClassesMap = new HashMap<String, List<String>>();
        Path mi = dir.resolve("module-info.class");
        for (ClassProvider cp : this.classProviders) {
            if (!(cp instanceof AsmModuleClassProvider)) continue;
            FoundFile foundFile = new FoundFile(mi);
            String moduleName = ((AsmModuleClassProvider)cp).getModuleName(foundFile);
            SootModuleInfo moduleInfo = (SootModuleInfo)SootModuleResolver.v().makeClassRef("module-info", (Optional<String>)Optional.of((Object)moduleName));
            this.moduleNameToPath.put(moduleName, dir);
            List<String> classes = this.getClassesUnderDirectory(dir);
            for (String foundClass : classes) {
                int index = foundClass.lastIndexOf(46);
                if (index <= 0) continue;
                String packageName = foundClass.substring(0, index);
                moduleInfo.addModulePackage(packageName);
            }
            moduleClassesMap.put(moduleName, classes);
        }
        return moduleClassesMap;
    }

    @Override
    public Set<String> classesInDynamicPackage(String str) {
        HashSet<String> set = new HashSet<String>(0);
        StringTokenizer strtok = new StringTokenizer(ModuleScene.v().getSootModulePath(), String.valueOf(File.pathSeparatorChar));
        while (strtok.hasMoreTokens()) {
            String path = strtok.nextToken();
            List<String> l = super.getClassesUnder(path);
            for (String filename : l) {
                if (!filename.startsWith(str)) continue;
                set.add(filename);
            }
            path = path + File.pathSeparatorChar;
            StringTokenizer tokenizer = new StringTokenizer(str, ".");
            while (tokenizer.hasMoreTokens()) {
                path = path + tokenizer.nextToken();
                if (!tokenizer.hasMoreTokens()) continue;
                path = path + File.pathSeparatorChar;
            }
            l = super.getClassesUnder(path);
            for (String string : l) {
                set.add(str + "." + string);
            }
        }
        return set;
    }

    @Override
    public FoundFile lookupInClassPath(String fileName) {
        return this.lookUpInModulePath(fileName);
    }

    private SourceLocator.ClassSourceType getClassSourceType(Path path) {
        String stringPath = path.toUri().toString();
        if (stringPath.startsWith("jrt:/")) {
            return SourceLocator.ClassSourceType.jrt;
        }
        return super.getClassSourceType(path.toAbsolutePath().toString());
    }

    @Override
    protected SourceLocator.ClassSourceType getClassSourceType(String path) {
        if (path.startsWith("jrt:/")) {
            return SourceLocator.ClassSourceType.jrt;
        }
        return super.getClassSourceType(path);
    }

    public FoundFile lookUpInModulePath(String fileName) {
        SourceLocator.ClassSourceType cst;
        String[] moduleAndClassName = fileName.split(":");
        String className = moduleAndClassName[moduleAndClassName.length - 1];
        String moduleName = moduleAndClassName[0];
        if (className.isEmpty() || moduleName.isEmpty()) {
            throw new RuntimeException("No module given!");
        }
        Path foundModulePath = this.discoverModule(moduleName);
        FoundFile ret = null;
        if (foundModulePath == null) {
            return null;
        }
        String dir = foundModulePath.toAbsolutePath().toString();
        if (foundModulePath.toUri().toString().startsWith("jrt:/")) {
            dir = foundModulePath.toUri().toString();
        }
        if ((cst = this.getClassSourceType(foundModulePath)) == SourceLocator.ClassSourceType.zip || cst == SourceLocator.ClassSourceType.jar) {
            ret = this.lookupInArchive(dir, className);
        } else if (cst == SourceLocator.ClassSourceType.directory) {
            ret = this.lookupInDir(dir, className);
        } else if (cst == SourceLocator.ClassSourceType.jrt) {
            ret = this.lookUpInVirtualFileSystem(dir, className);
        }
        if (ret != null) {
            return ret;
        }
        return null;
    }

    private Path discoverModule(String moduleName) {
        Path pathToModule = this.moduleNameToPath.get(moduleName);
        if (pathToModule != null) {
            return pathToModule;
        }
        while (this.modulePathHasNextEntry()) {
            String path = this.modulePath.get(this.next);
            this.getClassUnderModulePath(path);
            ++this.next;
            pathToModule = this.moduleNameToPath.get(moduleName);
            if (pathToModule == null) continue;
            return pathToModule;
        }
        return null;
    }

    private FoundFile lookupInDir(String dir, String fileName) {
        Path dirPath = Paths.get(dir, new String[0]);
        Path foundFile = dirPath.resolve(fileName);
        if (foundFile != null && Files.isRegularFile(foundFile, new LinkOption[0])) {
            return new FoundFile(foundFile);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected FoundFile lookupInArchive(String archivePath, String fileName) {
        Path archive = Paths.get(archivePath, new String[0]);
        try (FileSystem zipFileSystem = FileSystems.newFileSystem(archive, this.getClass().getClassLoader());){
            Path entry = zipFileSystem.getPath(fileName, new String[0]);
            if (entry == null || !Files.isRegularFile(entry, new LinkOption[0])) {
                FoundFile foundFile = null;
                return foundFile;
            }
            FoundFile foundFile = new FoundFile(archive.toAbsolutePath().toString(), fileName);
            return foundFile;
        }
        catch (IOException e) {
            throw new RuntimeException("Caught IOException " + e + " looking in archive file " + archivePath + " for file " + fileName);
        }
    }

    public FoundFile lookUpInVirtualFileSystem(String archivePath, String fileName) {
        Path foundFile = Paths.get(URI.create(archivePath)).resolve(fileName);
        if (foundFile != null && Files.isRegularFile(foundFile, new LinkOption[0])) {
            return new FoundFile(foundFile);
        }
        return null;
    }

    @Override
    protected void setupClassProviders() {
        this.classProviders = new LinkedList();
        AsmModuleClassProvider classFileClassProvider = new AsmModuleClassProvider();
        this.classProviders.add(classFileClassProvider);
    }

    private List<String> getClassesUnderDirectory(final Path aPath) {
        final ArrayList<String> classes = new ArrayList<String>();
        SourceLocator.ClassSourceType cst = this.getClassSourceType(aPath);
        if (cst == SourceLocator.ClassSourceType.directory || cst == SourceLocator.ClassSourceType.jrt) {
            FileVisitor<Path> fileVisitor = new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    int index;
                    String fileName = aPath.relativize(file).toString().replace(File.separatorChar, '.');
                    if (fileName.endsWith(".class")) {
                        index = fileName.lastIndexOf(".class");
                        classes.add(fileName.substring(0, index));
                    }
                    if (fileName.endsWith(".jimple")) {
                        index = fileName.lastIndexOf(".jimple");
                        classes.add(fileName.substring(0, index));
                    }
                    if (fileName.endsWith(".java")) {
                        index = fileName.lastIndexOf(".java");
                        classes.add(fileName.substring(0, index));
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            };
            try {
                Files.walkFileTree(aPath, (FileVisitor<? super Path>)fileVisitor);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            throw new RuntimeException("Invalid class source type");
        }
        return classes;
    }
}

