/*
 * Decompiled with CFR 0.152.
 */
package soot;

import com.google.common.base.Optional;
import java.util.LinkedList;
import soot.G;
import soot.ModuleScene;
import soot.ModuleUtil;
import soot.RefType;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootModuleResolver;
import soot.Type;
import soot.UnknownType;
import soot.options.Options;

public class ModuleRefType
extends RefType {
    private String moduleName;

    public ModuleRefType(Singletons.Global g) {
        super(g);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    protected ModuleRefType(String className, String moduleName) {
        super(className);
        this.moduleName = moduleName;
    }

    public static RefType v(String className) {
        ModuleUtil.ModuleClassNameWrapper wrapper = ModuleUtil.v().makeWrapper(className);
        return ModuleRefType.v(wrapper.getClassName(), wrapper.getModuleNameOptional());
    }

    public static RefType v(String className, Optional<String> moduleName) {
        RefType rt;
        String module = null;
        if (moduleName.isPresent()) {
            module = ModuleUtil.v().findModuleThatExports(className, (String)moduleName.get());
        }
        if (!moduleName.isPresent() && Options.v().verbose()) {
            G.v().out.println("[WARN] ModuleRefType called with empty module for: " + className);
        }
        if ((rt = ModuleScene.v().getRefTypeUnsafe(className, (Optional<String>)Optional.fromNullable((Object)module))) == null) {
            rt = !moduleName.isPresent() ? new ModuleRefType(className, null) : new ModuleRefType(className, module);
            ModuleScene.v().addRefType(rt);
        }
        return rt;
    }

    @Override
    public SootClass getSootClass() {
        if (this.sootClass == null) {
            super.setSootClass(SootModuleResolver.v().makeClassRef(this.getClassName(), (Optional<String>)Optional.fromNullable((Object)this.moduleName)));
        }
        return super.getSootClass();
    }

    @Override
    public Type merge(Type other, Scene cm) {
        if (other.equals(UnknownType.v()) || this.equals(other)) {
            return this;
        }
        if (!(other instanceof RefType)) {
            throw new RuntimeException("illegal type merge: " + this + " and " + other);
        }
        SootClass thisClass = ((ModuleScene)cm).getSootClass(this.getClassName(), (Optional<String>)Optional.fromNullable((Object)this.moduleName));
        SootClass otherClass = ((ModuleScene)cm).getSootClass(((RefType)other).getClassName(), (Optional<String>)Optional.fromNullable((Object)this.moduleName));
        SootClass javalangObject = cm.getObjectType().getSootClass();
        LinkedList<SootClass> thisHierarchy = new LinkedList<SootClass>();
        LinkedList<SootClass> otherHierarchy = new LinkedList<SootClass>();
        SootClass SootClass2 = thisClass;
        while (true) {
            thisHierarchy.addFirst(SootClass2);
            if (SootClass2 == javalangObject) break;
            if (SootClass2.hasSuperclass()) {
                SootClass2 = SootClass2.getSuperclass();
                continue;
            }
            SootClass2 = javalangObject;
        }
        SootClass2 = otherClass;
        while (true) {
            otherHierarchy.addFirst(SootClass2);
            if (SootClass2 == javalangObject) break;
            if (SootClass2.hasSuperclass()) {
                SootClass2 = SootClass2.getSuperclass();
                continue;
            }
            SootClass2 = javalangObject;
        }
        SootClass commonClass = null;
        while (!otherHierarchy.isEmpty() && !thisHierarchy.isEmpty() && otherHierarchy.getFirst() == thisHierarchy.getFirst()) {
            commonClass = (SootClass)otherHierarchy.removeFirst();
            thisHierarchy.removeFirst();
        }
        if (commonClass == null) {
            throw new RuntimeException("Could not find a common superclass for " + this + " and " + other);
        }
        return commonClass.getType();
    }

    @Override
    public Type getArrayElementType() {
        if (this.getClassName().equals("java.lang.Object") || this.getClassName().equals("java.io.Serializable") || this.getClassName().equals("java.lang.Cloneable")) {
            return ModuleRefType.v("java.lang.Object", (Optional<String>)Optional.of((Object)"java.base"));
        }
        throw new RuntimeException("Attempt to get array base type of a non-array");
    }
}

