/*
 * Decompiled with CFR 0.152.
 */
package soot;

import com.google.common.base.Optional;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.ArrayType;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.ClassSource;
import soot.DoubleType;
import soot.FloatType;
import soot.G;
import soot.IntType;
import soot.LongType;
import soot.ModulePathSourceLocator;
import soot.ModuleRefType;
import soot.ModuleUtil;
import soot.RefType;
import soot.Scene;
import soot.ShortType;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.SootModuleResolver;
import soot.SourceLocator;
import soot.Type;
import soot.VoidType;
import soot.options.Options;
import soot.util.HashChain;

public class ModuleScene
extends Scene {
    private final Map<String, Map<String, RefType>> nameToClass = new HashMap<String, Map<String, RefType>>();
    private String modulePath = null;
    private List<SootClass> dynamicClasses = null;

    public ModuleScene(Singletons.Global g) {
        super(g);
        String smp = System.getProperty("soot.module.path");
        if (smp != null) {
            this.setSootModulePath(smp);
        }
        this.addBasicClass("java.lang.invoke.StringConcatFactory");
    }

    public static ModuleScene v() {
        return G.v().soot_ModuleScene();
    }

    @Override
    public SootMethod getMainMethod() {
        if (!this.hasMainClass()) {
            throw new RuntimeException("There is no main class set!");
        }
        SootMethod mainMethod = this.mainClass.getMethodUnsafe("main", Collections.singletonList(ArrayType.v(ModuleRefType.v("java.lang.String", (Optional<String>)Optional.of((Object)"java.base")), 1)), VoidType.v());
        if (mainMethod == null) {
            throw new RuntimeException("Main class declares no main method!");
        }
        return mainMethod;
    }

    @Override
    public void extendSootClassPath(String newPathElement) {
        this.extendSootModulePath(newPathElement);
    }

    public void extendSootModulePath(String newPathElement) {
        this.modulePath = this.modulePath + File.pathSeparator + newPathElement;
        ModulePathSourceLocator.v().extendClassPath(newPathElement);
    }

    @Override
    public String getSootClassPath() {
        return this.getSootModulePath();
    }

    @Override
    public void setSootClassPath(String p) {
        this.setSootModulePath(p);
    }

    public String getSootModulePath() {
        if (this.modulePath == null) {
            String optionsmp = Options.v().soot_modulepath();
            if (optionsmp != null && optionsmp.length() > 0) {
                this.modulePath = optionsmp;
            }
            if (this.modulePath == null) {
                this.modulePath = this.defaultJavaModulePath();
            } else if (Options.v().prepend_classpath()) {
                this.modulePath = this.modulePath + File.pathSeparator + this.defaultJavaModulePath();
            }
            List<String> process_dir = Options.v().process_dir();
            StringBuilder pds = new StringBuilder();
            for (String path : process_dir) {
                if (this.modulePath.contains(path)) continue;
                pds.append(path);
                pds.append(File.pathSeparator);
            }
            this.modulePath = pds + this.modulePath;
        }
        return this.modulePath;
    }

    public void setSootModulePath(String p) {
        ModulePathSourceLocator.v().invalidateClassPath();
        this.modulePath = p;
    }

    private String defaultJavaModulePath() {
        StringBuilder sb = new StringBuilder();
        File rtJar = Paths.get(System.getProperty("java.home"), "lib", "jrt-fs.jar").toFile();
        if (!(rtJar.exists() && rtJar.isFile() || !Options.v().soot_modulepath().isEmpty())) {
            throw new RuntimeException("Error: cannot find jrt-fs.jar.");
        }
        sb.append("VIRTUAL_FS_FOR_JDK");
        return sb.toString();
    }

    @Override
    protected void addClassSilent(SootClass c) {
        if (c.isInScene()) {
            throw new RuntimeException("already managed: " + c.getName());
        }
        if (this.containsClass(c.getName(), (Optional<String>)Optional.fromNullable((Object)c.moduleName))) {
            throw new RuntimeException("duplicate class: " + c.getName());
        }
        this.classes.add(c);
        if (!this.nameToClass.containsKey(c.getName())) {
            this.nameToClass.put(c.getName(), new HashMap());
        }
        Map<String, RefType> map = this.nameToClass.get(c.getName());
        map.put(c.moduleName, c.getType());
        c.getType().setSootClass(c);
        c.setInScene(true);
        if (!c.isPhantom) {
            this.modifyHierarchy();
        }
    }

    @Override
    public boolean containsClass(String className) {
        ModuleUtil.ModuleClassNameWrapper wrapper = ModuleUtil.v().makeWrapper(className);
        return this.containsClass(wrapper.getClassName(), wrapper.getModuleNameOptional());
    }

    public boolean containsClass(String className, Optional<String> moduleName) {
        RefType type = null;
        Map<String, RefType> map = this.nameToClass.get(className);
        if (map != null && !map.isEmpty()) {
            if (moduleName.isPresent()) {
                String module = ModuleUtil.v().findModuleThatExports(className, (String)moduleName.get());
                type = map.get(module);
            } else {
                type = map.values().iterator().next();
                if (ModuleUtil.module_mode() && Options.v().verbose()) {
                    G.v().out.println("[WARN] containsClass called with empty module for: " + className);
                }
            }
        }
        if (type == null) {
            return false;
        }
        if (!type.hasSootClass()) {
            return false;
        }
        SootClass c = type.getSootClass();
        return c.isInScene();
    }

    @Override
    public boolean containsType(String className) {
        return this.nameToClass.containsKey(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SootClass tryLoadClass(String className, int desiredLevel, Optional<String> moduleName) {
        this.setPhantomRefs(true);
        try (ClassSource source = ModulePathSourceLocator.v().getClassSource(className, moduleName);){
            if (!this.getPhantomRefs() && source == null) {
                this.setPhantomRefs(false);
                SootClass sootClass = null;
                return sootClass;
            }
        }
        SootModuleResolver resolver = SootModuleResolver.v();
        SootClass toReturn = resolver.resolveClass(className, desiredLevel, moduleName);
        this.setPhantomRefs(false);
        return toReturn;
    }

    @Override
    public SootClass loadClassAndSupport(String className) {
        ModuleUtil.ModuleClassNameWrapper wrapper = ModuleUtil.v().makeWrapper(className);
        return this.loadClassAndSupport(wrapper.getClassName(), wrapper.getModuleNameOptional());
    }

    public SootClass loadClassAndSupport(String className, Optional<String> moduleName) {
        SootClass ret = this.loadClass(className, 2, moduleName);
        if (!ret.isPhantom()) {
            ret = this.loadClass(className, 3, moduleName);
        }
        return ret;
    }

    @Override
    public SootClass loadClass(String className, int desiredLevel) {
        ModuleUtil.ModuleClassNameWrapper wrapper = ModuleUtil.v().makeWrapper(className);
        return this.loadClass(wrapper.getClassName(), desiredLevel, wrapper.getModuleNameOptional());
    }

    public SootClass loadClass(String className, int desiredLevel, Optional<String> moduleName) {
        this.setPhantomRefs(true);
        SootModuleResolver resolver = SootModuleResolver.v();
        SootClass toReturn = resolver.resolveClass(className, desiredLevel, moduleName);
        this.setPhantomRefs(false);
        return toReturn;
    }

    public Type getType(String arg, Optional<String> moduleName) {
        String type = arg.replaceAll("([^\\[\\]]*)(.*)", "$1");
        int arrayCount = arg.contains("[") ? arg.replaceAll("([^\\[\\]]*)(.*)", "$2").length() / 2 : 0;
        Type result = this.getRefTypeUnsafe(type, moduleName);
        if (result == null) {
            if (type.equals("long")) {
                result = LongType.v();
            } else if (type.equals("short")) {
                result = ShortType.v();
            } else if (type.equals("double")) {
                result = DoubleType.v();
            } else if (type.equals("int")) {
                result = IntType.v();
            } else if (type.equals("float")) {
                result = FloatType.v();
            } else if (type.equals("byte")) {
                result = ByteType.v();
            } else if (type.equals("char")) {
                result = CharType.v();
            } else if (type.equals("void")) {
                result = VoidType.v();
            } else if (type.equals("boolean")) {
                result = BooleanType.v();
            } else {
                throw new RuntimeException("unknown type: '" + type + "'");
            }
        }
        if (arrayCount != 0) {
            result = ArrayType.v(result, arrayCount);
        }
        return result;
    }

    public RefType getRefType(String className, Optional<String> moduleName) {
        RefType refType = this.getRefTypeUnsafe(className, moduleName);
        if (refType == null) {
            throw new IllegalStateException("RefType " + className + " not loaded. If you tried to get the RefType of a library class, did you call loadNecessaryClasses()? Otherwise please check Soot's classpath.");
        }
        return refType;
    }

    @Override
    public RefType getRefType(String className) {
        ModuleUtil.ModuleClassNameWrapper wrapper = ModuleUtil.v().makeWrapper(className);
        return this.getRefType(wrapper.getClassName(), wrapper.getModuleNameOptional());
    }

    @Override
    public RefType getObjectType() {
        return this.getRefType("java.lang.Object", (Optional<String>)Optional.of((Object)"java.base"));
    }

    public RefType getRefTypeUnsafe(String className, Optional<String> moduleName) {
        RefType refType = null;
        Map<String, RefType> map = this.nameToClass.get(className);
        if (map != null && !map.isEmpty()) {
            if (moduleName.isPresent()) {
                refType = map.get(moduleName.get());
            } else {
                refType = map.values().iterator().next();
                if (Options.v().verbose() && ModuleUtil.module_mode()) {
                    G.v().out.println("[Warning] getRefTypeUnsafe called with empty module for: " + className);
                }
            }
        }
        return refType;
    }

    @Override
    public RefType getRefTypeUnsafe(String className) {
        ModuleUtil.ModuleClassNameWrapper wrapper = ModuleUtil.v().makeWrapper(className);
        return this.getRefTypeUnsafe(wrapper.getClassName(), wrapper.getModuleNameOptional());
    }

    public void addRefType(RefType type) {
        if (!this.nameToClass.containsKey(type.getClassName())) {
            this.nameToClass.put(type.getClassName(), new HashMap());
        }
        Map<String, RefType> map = this.nameToClass.get(type.getClassName());
        map.put(((ModuleRefType)type).getModuleName(), type);
    }

    @Override
    public SootClass getSootClassUnsafe(String className) {
        ModuleUtil.ModuleClassNameWrapper wrapper = ModuleUtil.v().makeWrapper(className);
        return this.getSootClassUnsafe(wrapper.getClassName(), wrapper.getModuleNameOptional());
    }

    public SootClass getSootClassUnsafe(String className, Optional<String> moduleName) {
        SootClass tsc;
        RefType type = null;
        Map<String, RefType> map = this.nameToClass.get(className);
        if (map != null && !map.isEmpty()) {
            if (moduleName.isPresent()) {
                String module = ModuleUtil.v().findModuleThatExports(className, (String)moduleName.get());
                type = map.get(module);
            } else {
                type = map.values().iterator().next();
                if (Options.v().verbose() && ModuleUtil.module_mode()) {
                    G.v().out.println("[Warning] getSootClassUnsafe called with empty for: " + className);
                }
            }
        }
        if (type != null && (tsc = type.getSootClass()) != null) {
            return tsc;
        }
        if (this.allowsPhantomRefs() || className.equals("soot.dummy.InvokeDynamic")) {
            SootClass c = new SootClass(className);
            this.addClassSilent(c);
            c.setPhantomClass();
            return c;
        }
        return null;
    }

    @Override
    public SootClass getSootClass(String className) {
        ModuleUtil.ModuleClassNameWrapper wrapper = ModuleUtil.v().makeWrapper(className);
        return this.getSootClass(wrapper.getClassName(), wrapper.getModuleNameOptional());
    }

    public SootClass getSootClass(String className, Optional<String> moduleName) {
        SootClass sc = this.getSootClassUnsafe(className, moduleName);
        if (sc != null) {
            return sc;
        }
        throw new RuntimeException(System.getProperty("line.separator") + "Aborting: can't find classfile " + className);
    }

    @Override
    public void loadBasicClasses() {
        this.addReflectionTraceClasses();
        Set<String>[] basicclasses = this.getBasicClassesIncludingResolveLevel();
        int loadedClasses = 0;
        for (int i = 3; i >= 1; --i) {
            for (String name : basicclasses[i]) {
                ModuleUtil.ModuleClassNameWrapper wrapper = ModuleUtil.v().makeWrapper(name);
                SootClass sootClass = this.tryLoadClass(wrapper.getClassName(), i, wrapper.getModuleNameOptional());
                if (sootClass == null || sootClass.isPhantom()) continue;
                ++loadedClasses;
            }
        }
        if (loadedClasses == 0) {
            throw new RuntimeException("None of the basic classes could be loaded! Check your Soot class path!");
        }
    }

    private void loadNecessaryClass(String name) {
        SootClass c = this.loadClassAndSupport(name);
        c.setApplicationClass();
    }

    @Override
    public void loadNecessaryClasses() {
        this.loadBasicClasses();
        for (String name : Options.v().classes()) {
            this.loadNecessaryClass(name);
        }
        this.loadDynamicClasses();
        if (Options.v().oaat()) {
            if (Options.v().process_dir().isEmpty()) {
                throw new IllegalArgumentException("If switch -oaat is used, then also -process-dir must be given.");
            }
        } else {
            for (String path : Options.v().process_dir()) {
                for (Map.Entry<String, List<String>> entry : ModulePathSourceLocator.v().getClassUnderModulePath(path).entrySet()) {
                    for (String cl : entry.getValue()) {
                        SootClass theClass = this.loadClassAndSupport(cl, (Optional<String>)Optional.fromNullable((Object)entry.getKey()));
                        theClass.setApplicationClass();
                    }
                }
            }
        }
        this.prepareClasses();
        this.setDoneResolving();
    }

    @Override
    public void loadDynamicClasses() {
        this.dynamicClasses = new ArrayList<SootClass>();
        HashMap<String, List<String>> dynClasses = new HashMap<String, List<String>>();
        dynClasses.put(null, Options.v().dynamic_class());
        for (String string : Options.v().dynamic_dir()) {
            dynClasses.putAll(ModulePathSourceLocator.v().getClassUnderModulePath(string));
        }
        for (String string : Options.v().dynamic_package()) {
            List classPathClasses = (List)dynClasses.get(null);
            classPathClasses.addAll(SourceLocator.v().classesInDynamicPackage(string));
        }
        for (Map.Entry entry : dynClasses.entrySet()) {
            for (String className : (List)entry.getValue()) {
                this.dynamicClasses.add(this.loadClassAndSupport(className, (Optional<String>)Optional.fromNullable(entry.getKey())));
            }
        }
        Iterator<SootClass> iterator = this.dynamicClasses.iterator();
        while (iterator.hasNext()) {
            SootClass sootClass = iterator.next();
            if (sootClass.isConcrete()) continue;
            if (Options.v().verbose()) {
                G.v().out.println("Warning: dynamic class " + sootClass.getName() + " is abstract or an interface, and it will not be considered.");
            }
            iterator.remove();
        }
    }

    @Override
    public Collection<SootClass> dynamicClasses() {
        if (this.dynamicClasses == null) {
            throw new IllegalStateException("Have to call loadDynamicClasses() first!");
        }
        return this.dynamicClasses;
    }

    private void prepareClasses() {
        HashChain<SootClass> processedClasses = new HashChain<SootClass>();
        block0: while (true) {
            HashChain<SootClass> unprocessedClasses = new HashChain<SootClass>(this.getClasses());
            unprocessedClasses.removeAll(processedClasses);
            if (unprocessedClasses.isEmpty()) break;
            processedClasses.addAll(unprocessedClasses);
            Iterator iterator = unprocessedClasses.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                SootClass s = (SootClass)iterator.next();
                if (s.isPhantom()) continue;
                if (Options.v().app()) {
                    s.setApplicationClass();
                }
                if (Options.v().classes().contains(s.getName())) {
                    s.setApplicationClass();
                    continue;
                }
                if (s.isApplicationClass() && this.isExcluded(s)) {
                    s.setLibraryClass();
                }
                if (this.isIncluded(s)) {
                    s.setApplicationClass();
                }
                if (!s.isApplicationClass()) continue;
                this.loadClassAndSupport(s.getName(), (Optional<String>)Optional.fromNullable((Object)s.moduleName));
            }
            break;
        }
    }

    @Override
    public void setMainClassFromOptions() {
        if (this.mainClass != null) {
            return;
        }
        if (Options.v().main_class() != null && Options.v().main_class().length() > 0) {
            this.setMainClass(this.getSootClass(Options.v().main_class(), null));
        } else {
            for (String s : Options.v().classes()) {
                SootClass c = this.getSootClass(s, null);
                if (!c.declaresMethod("main", Collections.singletonList(ArrayType.v(ModuleRefType.v("java.lang.String", (Optional<String>)Optional.of((Object)"java.base")), 1)), VoidType.v())) continue;
                G.v().out.println("No main class given. Inferred '" + c.getName() + "' as main class.");
                this.setMainClass(c);
                return;
            }
            for (SootClass c : this.getApplicationClasses()) {
                if (!c.declaresMethod("main", Collections.singletonList(ArrayType.v(ModuleRefType.v("java.lang.String", (Optional<String>)Optional.of((Object)"java.base")), 1)), VoidType.v())) continue;
                G.v().out.println("No main class given. Inferred '" + c.getName() + "' as main class.");
                this.setMainClass(c);
                return;
            }
        }
    }

    @Override
    public SootClass forceResolve(String className, int level) {
        ModuleUtil.ModuleClassNameWrapper wrapper = ModuleUtil.v().makeWrapper(className);
        return this.forceResolve(wrapper.getClassName(), level, wrapper.getModuleNameOptional());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SootClass forceResolve(String className, int level, Optional<String> moduleName) {
        SootClass c;
        boolean tmp = super.doneResolving();
        super.setResolving(false);
        try {
            c = SootModuleResolver.v().resolveClass(className, level, moduleName);
        }
        finally {
            super.setResolving(tmp);
        }
        return c;
    }

    @Override
    public SootClass makeSootClass(String className) {
        ModuleUtil.ModuleClassNameWrapper wrapper = ModuleUtil.v().makeWrapper(className);
        return this.makeSootClass(wrapper.getClassName(), wrapper.getModuleName());
    }

    public SootClass makeSootClass(String name, String moduleName) {
        return new SootClass(name, moduleName);
    }

    public RefType getOrAddRefType(RefType tp) {
        RefType existing = this.getRefType(tp.getClassName(), (Optional<String>)Optional.fromNullable((Object)((ModuleRefType)tp).getModuleName()));
        if (existing != null) {
            return existing;
        }
        this.addRefType(tp);
        return tp;
    }

    public RefType getOrAddRefType(String className, Optional<String> moduleName) {
        RefType existing = this.getRefType(className, moduleName);
        if (existing != null) {
            return existing;
        }
        RefType tp = ModuleRefType.v(className, moduleName);
        this.addRefType(tp);
        return tp;
    }
}

