/*
 * Decompiled with CFR 0.152.
 */
package soot;

import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import soot.G;
import soot.ModuleScene;
import soot.Singletons;
import soot.SootModuleInfo;
import soot.SootModuleResolver;
import soot.options.Options;

public final class ModuleUtil {
    private final Cache<String, String> modulePackageCache = CacheBuilder.newBuilder().initialCapacity(60).maximumSize(800L).concurrencyLevel(Runtime.getRuntime().availableProcessors()).build();
    private final LoadingCache<String, ModuleClassNameWrapper> wrapperCache = CacheBuilder.newBuilder().initialCapacity(100).maximumSize(1000L).concurrencyLevel(Runtime.getRuntime().availableProcessors()).build((CacheLoader)new CacheLoader<String, ModuleClassNameWrapper>(){

        public ModuleClassNameWrapper load(String key) throws Exception {
            return new ModuleClassNameWrapper(key);
        }
    });
    private static final List<String> packagesJavaBaseModule = ModuleUtil.parseJavaBasePackage();
    private static final String JAVABASEFILE = "javabase.txt";

    public ModuleUtil(Singletons.Global g) {
    }

    public static ModuleUtil v() {
        return G.v().soot_ModuleUtil();
    }

    public final ModuleClassNameWrapper makeWrapper(String className) {
        try {
            return (ModuleClassNameWrapper)this.wrapperCache.get((Object)className);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean module_mode() {
        return !Options.v().soot_modulepath().isEmpty();
    }

    public final String findModuleThatExports(String className, String toModuleName) {
        SootModuleInfo modInfo;
        if (className.equalsIgnoreCase("module-info")) {
            return toModuleName;
        }
        if (ModuleScene.v().containsClass("module-info", (Optional<String>)Optional.fromNullable((Object)toModuleName))) {
            modInfo = (SootModuleInfo)ModuleScene.v().getSootClass("module-info", (Optional<String>)Optional.fromNullable((Object)toModuleName));
            if (modInfo.resolvingLevel() < 3) {
                modInfo = (SootModuleInfo)SootModuleResolver.v().resolveClass("module-info", 3, (Optional<String>)Optional.fromNullable((Object)toModuleName));
            }
        } else {
            modInfo = (SootModuleInfo)SootModuleResolver.v().resolveClass("module-info", 3, (Optional<String>)Optional.fromNullable((Object)toModuleName));
        }
        String packageName = ModuleUtil.getPackageName(className);
        if (modInfo == null) {
            return null;
        }
        String moduleName = (String)this.modulePackageCache.getIfPresent((Object)(modInfo.getModuleName() + "/" + packageName));
        if (moduleName != null) {
            return moduleName;
        }
        if (modInfo.exportsPackage(packageName, toModuleName)) {
            return modInfo.getModuleName();
        }
        if (modInfo.isAutomaticModule() && ModuleScene.v().containsClass(className)) {
            String foundModuleName = ModuleScene.v().getSootClass(className).getModuleInformation().getModuleName();
            this.modulePackageCache.put((Object)(modInfo.getModuleName() + "/" + packageName), (Object)foundModuleName);
            return foundModuleName;
        }
        for (SootModuleInfo modInf : modInfo.retrieveRequiredModules().keySet()) {
            if (modInf.exportsPackage(packageName, toModuleName)) {
                this.modulePackageCache.put((Object)(modInfo.getModuleName() + "/" + packageName), (Object)modInf.getModuleName());
                return modInf.getModuleName();
            }
            HashSet<String> hasCheckedModule = new HashSet<String>();
            String tModuleName = this.checkTransitiveChain(modInf, packageName, toModuleName, hasCheckedModule);
            if (tModuleName == null) continue;
            this.modulePackageCache.put((Object)(modInfo.getModuleName() + "/" + packageName), (Object)tModuleName);
            return tModuleName;
        }
        return toModuleName;
    }

    private String checkTransitiveChain(SootModuleInfo modInfo, String packageName, String toModuleName, Set<String> hasCheckedModule) {
        for (Map.Entry<SootModuleInfo, Integer> entry : modInfo.retrieveRequiredModules().entrySet()) {
            if ((entry.getValue() & 0x20) == 0 || hasCheckedModule.contains(entry.getKey().getModuleName())) continue;
            hasCheckedModule.add(entry.getKey().getModuleName());
            if (entry.getKey().exportsPackage(packageName, toModuleName)) {
                return entry.getKey().getModuleName();
            }
            return this.checkTransitiveChain(entry.getKey(), packageName, toModuleName, hasCheckedModule);
        }
        return null;
    }

    private static String getPackageName(String className) {
        String packageName = "";
        int index = className.lastIndexOf(46);
        if (index > 0) {
            packageName = className.substring(0, index);
        }
        return packageName;
    }

    private static List<String> parseJavaBasePackage() {
        ArrayList<String> packages = new ArrayList<String>();
        InputStream in = null;
        Path excludeFile = Paths.get(JAVABASEFILE, new String[0]);
        try {
            in = !Files.exists(excludeFile, new LinkOption[0]) ? ModuleUtil.class.getResourceAsStream("/javabase.txt") : Files.newInputStream(excludeFile, new OpenOption[0]);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line;
            while ((line = reader.readLine()) != null) {
                packages.add(line);
            }
        }
        catch (IOException x) {
            G.v().out.println("[WARN] No files specifying the packages of module java.base");
        }
        return packages;
    }

    public static final class ModuleClassNameWrapper {
        private static final String fullQualifiedName = "([a-zA-Z_$][a-zA-Z\\d_$]*\\.)+[a-zA-Z_$][a-zA-Z\\d_$]*";
        private static final Pattern fqnClassNamePattern = Pattern.compile("([a-zA-Z_$][a-zA-Z\\d_$]*\\.)+[a-zA-Z_$][a-zA-Z\\d_$]*");
        private static final String qualifiedModuleName = "([a-zA-Z_$])([a-zA-Z\\d_$\\.]*)+";
        private static final Pattern qualifiedModuleNamePattern = Pattern.compile("([a-zA-Z_$])([a-zA-Z\\d_$\\.]*)+");
        private final String className;
        private String moduleName;

        private ModuleClassNameWrapper(String className) {
            String refinedModuleName;
            String refinedClassName;
            block4: {
                block3: {
                    refinedClassName = className;
                    refinedModuleName = null;
                    if (className.equals("soot.dummy.InvokeDynamic")) {
                        this.className = refinedClassName;
                        return;
                    }
                    if (!className.contains(":")) break block3;
                    String[] split = className.split(":");
                    if (split.length != 2 || !qualifiedModuleNamePattern.matcher(split[0]).matches() || !fqnClassNamePattern.matcher(split[1]).matches()) break block4;
                    refinedModuleName = split[0];
                    refinedClassName = split[1];
                    break block4;
                }
                if (fqnClassNamePattern.matcher(className).matches()) {
                    for (String packageName : packagesJavaBaseModule) {
                        if (!packageName.equals(ModuleUtil.getPackageName(className))) continue;
                        refinedModuleName = "java.base";
                        break;
                    }
                }
            }
            this.className = refinedClassName;
            this.moduleName = refinedModuleName;
            ModuleUtil.v().wrapperCache.put((Object)className, (Object)this);
        }

        public String getClassName() {
            return this.className;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public Optional<String> getModuleNameOptional() {
            return Optional.fromNullable((Object)this.moduleName);
        }
    }
}

