/*
 * Decompiled with CFR 0.152.
 */
package soot;

import com.google.common.base.Optional;
import java.util.ArrayDeque;
import soot.AnySubType;
import soot.G;
import soot.ModuleRefType;
import soot.ModuleUtil;
import soot.RefLikeType;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootResolver;
import soot.Type;
import soot.TypeSwitch;
import soot.UnknownType;
import soot.util.Switch;

public class RefType
extends RefLikeType
implements Comparable<RefType> {
    private String className;
    protected volatile SootClass sootClass;
    private AnySubType anySubType;

    public RefType(Singletons.Global g) {
        this.className = "";
    }

    public static RefType v() {
        if (ModuleUtil.module_mode()) {
            return G.v().soot_ModuleRefType();
        }
        return G.v().soot_RefType();
    }

    public String getClassName() {
        return this.className;
    }

    protected RefType(String className) {
        if (className.startsWith("[")) {
            throw new RuntimeException("Attempt to create RefType whose name starts with [ --> " + className);
        }
        if (className.indexOf("/") >= 0) {
            throw new RuntimeException("Attempt to create RefType containing a / --> " + className);
        }
        if (className.indexOf(";") >= 0) {
            throw new RuntimeException("Attempt to create RefType containing a ; --> " + className);
        }
        this.className = className;
    }

    public static RefType v(String className) {
        if (ModuleUtil.module_mode()) {
            return ModuleRefType.v(className);
        }
        RefType rt = Scene.v().getRefTypeUnsafe(className);
        if (rt == null) {
            return Scene.v().getOrAddRefType(className);
        }
        return rt;
    }

    @Override
    public int compareTo(RefType t) {
        return this.toString().compareTo(t.toString());
    }

    public static RefType v(SootClass c) {
        if (ModuleUtil.module_mode()) {
            return ModuleRefType.v(c.getName(), (Optional<String>)Optional.fromNullable((Object)c.moduleName));
        }
        return RefType.v(c.getName());
    }

    public SootClass getSootClass() {
        if (this.sootClass == null) {
            this.sootClass = SootResolver.v().makeClassRef(this.className);
        }
        return this.sootClass;
    }

    public boolean hasSootClass() {
        return this.sootClass != null;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setSootClass(SootClass sootClass) {
        this.sootClass = sootClass;
    }

    public boolean equals(Object t) {
        return t instanceof RefType && this.className.equals(((RefType)t).className);
    }

    @Override
    public String toString() {
        return this.className;
    }

    @Override
    public String toQuotedString() {
        return Scene.v().quotedNameOf(this.className);
    }

    public int hashCode() {
        return this.className.hashCode();
    }

    @Override
    public void apply(Switch sw) {
        ((TypeSwitch)sw).caseRefType(this);
    }

    @Override
    public Type merge(Type other, Scene cm) {
        if (other.equals(UnknownType.v()) || this.equals(other)) {
            return this;
        }
        if (!(other instanceof RefType)) {
            throw new RuntimeException("illegal type merge: " + this + " and " + other);
        }
        SootClass thisClass = cm.getSootClass(this.className);
        SootClass otherClass = cm.getSootClass(((RefType)other).className);
        SootClass javalangObject = cm.getObjectType().getSootClass();
        ArrayDeque<SootClass> thisHierarchy = new ArrayDeque<SootClass>();
        ArrayDeque<SootClass> otherHierarchy = new ArrayDeque<SootClass>();
        SootClass sootClass = thisClass;
        while (sootClass != null) {
            thisHierarchy.addFirst(sootClass);
            if (sootClass == javalangObject) break;
            if ((sootClass = sootClass.getSuperclassUnsafe()) != null) continue;
            sootClass = javalangObject;
        }
        sootClass = otherClass;
        while (sootClass != null) {
            otherHierarchy.addFirst(sootClass);
            if (sootClass == javalangObject) break;
            if ((sootClass = sootClass.getSuperclassUnsafe()) != null) continue;
            sootClass = javalangObject;
        }
        SootClass commonClass = null;
        while (!otherHierarchy.isEmpty() && !thisHierarchy.isEmpty() && otherHierarchy.getFirst() == thisHierarchy.getFirst()) {
            commonClass = (SootClass)otherHierarchy.removeFirst();
            thisHierarchy.removeFirst();
        }
        if (commonClass == null) {
            throw new RuntimeException("Could not find a common superclass for " + this + " and " + other);
        }
        return commonClass.getType();
    }

    @Override
    public Type getArrayElementType() {
        if (this.className.equals("java.lang.Object") || this.className.equals("java.io.Serializable") || this.className.equals("java.lang.Cloneable")) {
            return RefType.v("java.lang.Object");
        }
        throw new RuntimeException("Attempt to get array base type of a non-array");
    }

    public AnySubType getAnySubType() {
        return this.anySubType;
    }

    public void setAnySubType(AnySubType anySubType) {
        this.anySubType = anySubType;
    }

    @Override
    public boolean isAllowedInFinalCode() {
        return true;
    }
}

