/*
 * Decompiled with CFR 0.152.
 */
package soot.asm;

import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.Trap;
import soot.Unit;
import soot.UnitBox;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.GotoStmt;
import soot.jimple.ReturnStmt;

public class CastAndReturnInliner
extends BodyTransformer {
    @Override
    protected void internalTransform(Body body, String phaseName, Map<String, String> options) {
        Iterator it = body.getUnits().snapshotIterator();
        while (it.hasNext()) {
            ReturnStmt retStmt;
            AssignStmt assign;
            GotoStmt gtStmt;
            Unit u = (Unit)it.next();
            if (!(u instanceof GotoStmt) || !((gtStmt = (GotoStmt)u).getTarget() instanceof AssignStmt) || !((assign = (AssignStmt)gtStmt.getTarget()).getRightOp() instanceof CastExpr)) continue;
            CastExpr ce = (CastExpr)assign.getRightOp();
            AssignStmt nextStmt = body.getUnits().getSuccOf(assign);
            if (!(nextStmt instanceof ReturnStmt) || (retStmt = (ReturnStmt)((Object)nextStmt)).getOp() != assign.getLeftOp()) continue;
            ReturnStmt newStmt = (ReturnStmt)retStmt.clone();
            newStmt.setOp(ce.getOp());
            for (Trap t : body.getTraps()) {
                for (UnitBox ubox : t.getUnitBoxes()) {
                    if (ubox.getUnit() != gtStmt) continue;
                    ubox.setUnit(newStmt);
                }
            }
            while (!gtStmt.getBoxesPointingToThis().isEmpty()) {
                gtStmt.getBoxesPointingToThis().get(0).setUnit(newStmt);
            }
            body.getUnits().swapWith(gtStmt, newStmt);
        }
    }
}

