/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.AST.transformations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import soot.Body;
import soot.SootClass;
import soot.SootMethod;
import soot.UnitPatchingChain;
import soot.dava.DavaBody;
import soot.dava.internal.AST.ASTMethodNode;
import soot.dava.internal.AST.ASTNode;

public class RemoveEmptyBodyDefaultConstructor {
    public static boolean DEBUG = false;

    public static void checkAndRemoveDefault(SootClass s) {
        RemoveEmptyBodyDefaultConstructor.debug("\n\nRemoveEmptyBodyDefaultConstructor----" + s.getName());
        List<SootMethod> methods = s.getMethods();
        Iterator<SootMethod> it = methods.iterator();
        ArrayList<SootMethod> constructors = new ArrayList<SootMethod>();
        while (it.hasNext()) {
            SootMethod method = it.next();
            RemoveEmptyBodyDefaultConstructor.debug("method name is" + method.getName());
            if (method.getName().indexOf("<init>") <= -1) continue;
            constructors.add(method);
        }
        if (constructors.size() != 1) {
            RemoveEmptyBodyDefaultConstructor.debug("class has more than one constructors cant do anything");
            return;
        }
        SootMethod constructor = (SootMethod)constructors.get(0);
        if (constructor.getParameterCount() != 0) {
            RemoveEmptyBodyDefaultConstructor.debug("constructor is not the default constructor");
            return;
        }
        RemoveEmptyBodyDefaultConstructor.debug("Check that the body is empty....and call to super contains no arguments and delete");
        if (!constructor.hasActiveBody()) {
            RemoveEmptyBodyDefaultConstructor.debug("No active body found for the default constructor");
            return;
        }
        if (!constructor.isPublic()) {
            RemoveEmptyBodyDefaultConstructor.debug("Default constructor is not public.");
            return;
        }
        Body body = constructor.getActiveBody();
        UnitPatchingChain units = ((DavaBody)body).getUnits();
        if (units.size() != 1) {
            RemoveEmptyBodyDefaultConstructor.debug(" DavaBody AST does not have single root");
            return;
        }
        ASTNode AST = (ASTNode)units.getFirst();
        if (!(AST instanceof ASTMethodNode)) {
            throw new RuntimeException("Starting node of DavaBody AST is not an ASTMethodNode");
        }
        ASTMethodNode methodNode = (ASTMethodNode)AST;
        RemoveEmptyBodyDefaultConstructor.debug("got methodnode check body is empty and super has nothing in it");
        List<Object> subBodies = methodNode.get_SubBodies();
        if (subBodies.size() != 1) {
            RemoveEmptyBodyDefaultConstructor.debug("Method node does not have one subBody!!!");
            return;
        }
        List methodBody = (List)subBodies.get(0);
        if (methodBody.size() != 0) {
            RemoveEmptyBodyDefaultConstructor.debug("Method body size is greater than 1 so cant do nothing");
            return;
        }
        RemoveEmptyBodyDefaultConstructor.debug("Method body is empty...check super call is empty");
        if (((DavaBody)body).get_ConstructorExpr().getArgCount() != 0) {
            RemoveEmptyBodyDefaultConstructor.debug("call to super not empty");
            return;
        }
        RemoveEmptyBodyDefaultConstructor.debug("REMOVE METHOD");
        s.removeMethod(constructor);
    }

    public static void debug(String debug) {
        if (DEBUG) {
            System.out.println("DEBUG: " + debug);
        }
    }
}

