/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.SootMethodRef;
import soot.Unit;
import soot.Value;
import soot.dexpler.DalvikThrowAnalysis;
import soot.jimple.AssignStmt;
import soot.jimple.DefinitionStmt;
import soot.jimple.IntConstant;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.LengthExpr;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.toolkits.scalar.LocalCreation;
import soot.jimple.toolkits.scalar.UnreachableCodeEliminator;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.scalar.LocalDefs;

public class DexNullArrayRefTransformer
extends BodyTransformer {
    public static DexNullArrayRefTransformer v() {
        return new DexNullArrayRefTransformer();
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map<String, String> options) {
        ExceptionalUnitGraph g = new ExceptionalUnitGraph(body, DalvikThrowAnalysis.v());
        LocalDefs defs = LocalDefs.Factory.newLocalDefs(g);
        LocalCreation lc = new LocalCreation(body.getLocals(), "ex");
        boolean changed = false;
        Iterator unitIt = body.getUnits().snapshotIterator();
        while (unitIt.hasNext()) {
            AssignStmt ass;
            Value rightOp;
            Stmt s = (Stmt)unitIt.next();
            if (s.containsArrayRef()) {
                Value base = s.getArrayRef().getBase();
                if (!this.isAlwaysNullBefore(s, (Local)base, defs)) continue;
                this.createThrowStmt(body, s, lc);
                changed = true;
                continue;
            }
            if (!(s instanceof AssignStmt) || !((rightOp = (ass = (AssignStmt)s).getRightOp()) instanceof LengthExpr)) continue;
            LengthExpr l = (LengthExpr)ass.getRightOp();
            Value base = l.getOp();
            if (base instanceof IntConstant) {
                IntConstant ic = (IntConstant)base;
                if (ic.value != 0) continue;
                this.createThrowStmt(body, s, lc);
                changed = true;
                continue;
            }
            if (base != NullConstant.v() && !this.isAlwaysNullBefore(s, (Local)base, defs)) continue;
            this.createThrowStmt(body, s, lc);
            changed = true;
        }
        if (changed) {
            UnreachableCodeEliminator.v().transform(body);
        }
    }

    private boolean isAlwaysNullBefore(Stmt s, Local base, LocalDefs defs) {
        List<Unit> baseDefs = defs.getDefsOfAt(base, s);
        if (baseDefs.isEmpty()) {
            return true;
        }
        for (Unit u : baseDefs) {
            if (!(u instanceof DefinitionStmt)) {
                return false;
            }
            DefinitionStmt defStmt = (DefinitionStmt)u;
            if (defStmt.getRightOp() == NullConstant.v()) continue;
            return false;
        }
        return true;
    }

    private void createThrowStmt(Body body, Unit oldStmt, LocalCreation lc) {
        RefType tp = RefType.v("java.lang.NullPointerException");
        Local lcEx = lc.newLocal(tp);
        SootMethodRef constructorRef = Scene.v().makeConstructorRef(tp.getSootClass(), Collections.singletonList(RefType.v("java.lang.String")));
        AssignStmt newExStmt = Jimple.v().newAssignStmt(lcEx, Jimple.v().newNewExpr(tp));
        body.getUnits().insertBefore(newExStmt, oldStmt);
        InvokeStmt invConsStmt = Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(lcEx, constructorRef, Collections.singletonList(StringConstant.v("Invalid array reference replaced by Soot"))));
        body.getUnits().insertBefore(invConsStmt, oldStmt);
        body.getUnits().swapWith(oldStmt, Jimple.v().newThrowStmt(lcEx));
    }
}

