/*
 * Decompiled with CFR 0.152.
 */
package soot.javaToJimple;

import java.util.ArrayList;
import java.util.Iterator;
import polyglot.types.MethodInstance;
import soot.Body;
import soot.Local;
import soot.MethodSource;
import soot.RefType;
import soot.Scene;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.VoidType;
import soot.javaToJimple.LocalGenerator;
import soot.javaToJimple.Util;
import soot.jimple.IdentityStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.ParameterRef;
import soot.jimple.Stmt;

public class PrivateMethodAccMethodSource
implements MethodSource {
    private MethodInstance methodInst;

    public PrivateMethodAccMethodSource(MethodInstance methInst) {
        this.methodInst = methInst;
    }

    public void setMethodInst(MethodInstance mi) {
        this.methodInst = mi;
    }

    private boolean isCallParamType(Type sootType) {
        Iterator it = this.methodInst.formalTypes().iterator();
        while (it.hasNext()) {
            Type compareType = Util.getSootType((polyglot.types.Type)it.next());
            if (!compareType.equals(sootType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Body getBody(SootMethod sootMethod, String phaseName) {
        JimpleBody body = Jimple.v().newBody(sootMethod);
        LocalGenerator lg = new LocalGenerator(body);
        Local base = null;
        ArrayList<Local> methParams = new ArrayList<Local>();
        ArrayList<Type> methParamsTypes = new ArrayList<Type>();
        Iterator<Type> paramIt = sootMethod.getParameterTypes().iterator();
        int paramCounter = 0;
        while (paramIt.hasNext()) {
            Type sootType = paramIt.next();
            Local paramLocal = lg.generateLocal(sootType);
            ParameterRef paramRef = Jimple.v().newParameterRef(sootType, paramCounter);
            IdentityStmt stmt = Jimple.v().newIdentityStmt(paramLocal, paramRef);
            body.getUnits().add(stmt);
            if (!this.isCallParamType(sootType)) {
                base = paramLocal;
            } else {
                methParams.add(paramLocal);
                methParamsTypes.add(paramLocal.getType());
            }
            ++paramCounter;
        }
        Type type = Util.getSootType(this.methodInst.returnType());
        Local returnLocal = null;
        if (!(type instanceof VoidType)) {
            returnLocal = lg.generateLocal(type);
        }
        SootMethodRef meth = Scene.v().makeMethodRef(((RefType)Util.getSootType((polyglot.types.Type)this.methodInst.container())).getSootClass(), this.methodInst.name(), methParamsTypes, Util.getSootType(this.methodInst.returnType()), this.methodInst.flags().isStatic());
        InvokeExpr invoke = null;
        invoke = this.methodInst.flags().isStatic() ? Jimple.v().newStaticInvokeExpr(meth, methParams) : Jimple.v().newSpecialInvokeExpr(base, meth, methParams);
        Stmt stmt = null;
        stmt = !(type instanceof VoidType) ? Jimple.v().newAssignStmt(returnLocal, invoke) : Jimple.v().newInvokeStmt(invoke);
        body.getUnits().add(stmt);
        Stmt retStmt = null;
        retStmt = !(type instanceof VoidType) ? Jimple.v().newReturnStmt(returnLocal) : Jimple.v().newReturnVoidStmt();
        body.getUnits().add(retStmt);
        return body;
    }
}

