/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.jimpleTransformations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.Body;
import soot.FastHierarchy;
import soot.G;
import soot.RefType;
import soot.Scene;
import soot.SceneTransformer;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.jbco.IJbcoTransform;
import soot.jbco.Main;
import soot.jbco.name.JunkNameGenerator;
import soot.jbco.name.NameGenerator;
import soot.jbco.util.BodyBuilder;
import soot.jbco.util.HierarchyUtils;
import soot.jbco.util.Rand;
import soot.jimple.InvokeExpr;

public class MethodRenamer
extends SceneTransformer
implements IJbcoTransform {
    private static final Logger logger = LoggerFactory.getLogger(MethodRenamer.class);
    public static final String name = "wjtp.jbco_mr";
    private static final String MAIN_METHOD_SUB_SIGNATURE = SootMethod.getSubSignature("main", Collections.singletonList(ArrayType.v(RefType.v("java.lang.String"), 1)), VoidType.v());
    private static final Function<SootClass, Map<String, String>> RENAMING_MAP_CREATOR = key -> new HashMap();
    private final Map<SootClass, Map<String, String>> classToRenamingMap = new HashMap<SootClass, Map<String, String>>();
    private final NameGenerator nameGenerator;

    public MethodRenamer(Singletons.Global global) {
        if (global == null) {
            throw new NullPointerException("Cannot instantiate MethodRenamer with null Singletons.Global");
        }
        this.nameGenerator = new JunkNameGenerator();
    }

    public static MethodRenamer v() {
        return G.v().soot_jbco_jimpleTransformations_MethodRenamer();
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String[] getDependencies() {
        return new String[]{name};
    }

    @Override
    public void outputSummary() {
        Integer newNames = this.classToRenamingMap.values().stream().map(Map::values).flatMap(Collection::stream).collect(Collectors.collectingAndThen(Collectors.toSet(), Set::size));
        logger.info("{} methods were renamed.", (Object)newNames);
    }

    public Map<String, String> getRenamingMap(String className) {
        return this.classToRenamingMap.entrySet().stream().filter(entry -> ((SootClass)entry.getKey()).getName().equals(className)).flatMap(entry -> ((Map)entry.getValue()).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    protected void internalTransform(String phaseName, Map<String, String> options) {
        ArrayList<SootMethod> methods;
        if (this.isVerbose()) {
            logger.info("Transforming method names...");
        }
        BodyBuilder.retrieveAllBodies();
        BodyBuilder.retrieveAllNames();
        Scene.v().releaseActiveHierarchy();
        for (SootClass applicationClass : Scene.v().getApplicationClasses()) {
            List fieldNames = applicationClass.getFields().stream().map(SootField::getName).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
            ArrayList leftFieldNames = new ArrayList(fieldNames);
            ArrayList<SootMethod> methods2 = new ArrayList<SootMethod>(applicationClass.getMethods());
            for (SootMethod method : methods2) {
                if (!this.isRenamingAllowed(method)) continue;
                Set<SootClass> declaringClasses = this.getDeclaringClasses(applicationClass, method);
                if (declaringClasses.isEmpty()) {
                    throw new IllegalStateException("Cannot find classes that declare " + method.getSignature() + ".");
                }
                Optional<SootClass> libraryClass = declaringClasses.stream().filter(SootClass::isLibraryClass).findAny();
                if (libraryClass.isPresent()) {
                    if (!this.isVerbose()) continue;
                    logger.info("Skipping renaming {} method as it overrides library one from {}.", (Object)method.getSignature(), (Object)libraryClass.get().getName());
                    continue;
                }
                Set<SootClass> union = this.uniteWithApplicationParents(applicationClass, declaringClasses);
                String newName = this.getNewName(union, method.getName());
                if (newName == null) {
                    int randomIndex;
                    String randomFieldName;
                    newName = leftFieldNames.isEmpty() ? this.getNewName() : (this.isNotUnique(randomFieldName = (String)leftFieldNames.remove(randomIndex = Rand.getInt(leftFieldNames.size()))) || fieldNames.contains(randomFieldName) ? this.getNewName() : randomFieldName);
                }
                for (SootClass declaringClass : union) {
                    this.classToRenamingMap.computeIfAbsent(declaringClass, RENAMING_MAP_CREATOR).put(method.getName(), newName);
                }
            }
        }
        for (SootClass applicationClass : Scene.v().getApplicationClasses()) {
            methods = new ArrayList<SootMethod>(applicationClass.getMethods());
            for (SootMethod method : methods) {
                String newName = this.getNewName(Collections.singleton(applicationClass), method.getName());
                if (newName == null) continue;
                if (this.isVerbose()) {
                    logger.info("Method \"{}\" is being renamed to \"{}\".", (Object)method.getSignature(), (Object)newName);
                }
                method.setName(newName);
            }
        }
        for (SootClass applicationClass : Scene.v().getApplicationClasses()) {
            methods = new ArrayList<SootMethod>(applicationClass.getMethods());
            for (SootMethod method : methods) {
                Body body;
                if (!method.isConcrete() || method.getDeclaringClass().isLibraryClass() || (body = MethodRenamer.getActiveBodySafely(method)) == null) continue;
                for (Unit unit : body.getUnits()) {
                    for (ValueBox valueBox : unit.getUseBoxes()) {
                        Value v = valueBox.getValue();
                        if (!(v instanceof InvokeExpr)) continue;
                        InvokeExpr invokeExpr = (InvokeExpr)v;
                        SootMethodRef methodRef = invokeExpr.getMethodRef();
                        Set<SootClass> parents = this.getParents(methodRef.getDeclaringClass());
                        Optional<SootClass> declaringLibraryClass = this.findDeclaringLibraryClass(parents, methodRef);
                        if (declaringLibraryClass.isPresent()) {
                            if (!this.isVerbose()) continue;
                            logger.info("Skipping replacing method call \"{}\" in \"{}\" as it is overrides one  from library {}.", new Object[]{methodRef.getSignature(), method.getSignature(), declaringLibraryClass.get().getName()});
                            continue;
                        }
                        String newName = this.getNewName(parents, methodRef.getName());
                        if (newName == null) continue;
                        SootMethodRef newMethodRef = Scene.v().makeMethodRef(methodRef.getDeclaringClass(), newName, methodRef.getParameterTypes(), methodRef.getReturnType(), methodRef.isStatic());
                        invokeExpr.setMethodRef(newMethodRef);
                        if (!this.isVerbose()) continue;
                        logger.info("Method call \"{}\" is being replaced with \"{}\" in {}.", new Object[]{methodRef.getSignature(), newMethodRef.getSignature(), method.getSignature()});
                    }
                }
            }
        }
        Scene.v().releaseActiveHierarchy();
        Scene.v().setFastHierarchy(new FastHierarchy());
        if (this.isVerbose()) {
            logger.info("Transforming method names is completed.");
        }
    }

    public String getNewName() {
        int size = 5;
        int tries = 0;
        String newName = this.nameGenerator.generateName(size);
        while (this.isNotUnique(newName) || BodyBuilder.nameList.contains(newName)) {
            if (tries++ > size) {
                ++size;
                tries = 0;
            }
            newName = this.nameGenerator.generateName(size);
        }
        BodyBuilder.nameList.add(newName);
        return newName;
    }

    private boolean isRenamingAllowed(SootMethod method) {
        if (Main.getWeight(name, method.getSignature()) == 0) {
            return false;
        }
        String subSignature = method.getSubSignature();
        if (MAIN_METHOD_SUB_SIGNATURE.equals(subSignature) && method.isPublic() && method.isStatic()) {
            if (this.isVerbose()) {
                logger.info("Skipping renaming \"{}\" method as it is main one.", (Object)subSignature);
            }
            return false;
        }
        if (method.getName().equals("<init>") || method.getName().equals("<clinit>")) {
            if (this.isVerbose()) {
                logger.info("Skipping renaming \"{}\" method as it is constructor or static initializer.", (Object)subSignature);
            }
            return false;
        }
        return true;
    }

    private boolean isNotUnique(String methodName) {
        return this.classToRenamingMap.values().stream().map(Map::values).flatMap(Collection::stream).anyMatch(methodName::equals);
    }

    private Set<SootClass> uniteWithApplicationParents(SootClass applicationClass, Collection<SootClass> classes) {
        Set<SootClass> parents = this.getApplicationParents(applicationClass);
        HashSet<SootClass> result = new HashSet<SootClass>(parents.size() + classes.size());
        result.addAll(parents);
        result.addAll(classes);
        return result;
    }

    private Optional<SootClass> findDeclaringLibraryClass(Collection<SootClass> classes, SootMethodRef methodRef) {
        return classes.stream().filter(SootClass::isLibraryClass).filter(sootClass -> this.isDeclared((SootClass)sootClass, methodRef.getName(), methodRef.getParameterTypes())).findAny();
    }

    private Set<SootClass> getDeclaringClasses(SootClass applicationClass, SootMethod method) {
        return this.getTree(applicationClass).stream().filter(sootClass -> this.isDeclared((SootClass)sootClass, method.getName(), method.getParameterTypes())).collect(Collectors.toSet());
    }

    private Set<SootClass> getTree(SootClass applicationClass) {
        Set<SootClass> children = this.getChildrenOfIncluding(this.getParentsOfIncluding(applicationClass));
        int count = 0;
        do {
            count = children.size();
            children.addAll(this.getChildrenOfIncluding(this.getParentsOfIncluding(children)));
        } while (count < children.size());
        return children;
    }

    private Set<SootClass> getParents(SootClass applicationClass) {
        HashSet<SootClass> parents = new HashSet<SootClass>(this.getParentsOfIncluding(applicationClass));
        int count = 0;
        do {
            count = parents.size();
            parents.addAll(this.getParentsOfIncluding(parents));
        } while (count < parents.size());
        return parents;
    }

    private Set<SootClass> getApplicationParents(SootClass applicationClass) {
        return this.getParents(applicationClass).stream().filter(parent -> !parent.isLibraryClass()).collect(Collectors.toSet());
    }

    private List<SootClass> getParentsOfIncluding(SootClass applicationClass) {
        List<SootClass> result = HierarchyUtils.getAllInterfacesOf(applicationClass);
        result.addAll(applicationClass.getInterfaces());
        if (!applicationClass.isInterface() && applicationClass.hasSuperclass()) {
            result.add(applicationClass.getSuperclass());
        }
        result.addAll(applicationClass.isInterface() ? Scene.v().getActiveHierarchy().getSuperinterfacesOfIncluding(applicationClass) : Scene.v().getActiveHierarchy().getSuperclassesOfIncluding(applicationClass));
        return result;
    }

    private Set<SootClass> getChildrenOfIncluding(Collection<SootClass> classes) {
        return Stream.concat(classes.stream().filter(c -> !c.getName().equals("java.lang.Object")).map(c -> c.isInterface() ? Scene.v().getActiveHierarchy().getImplementersOf((SootClass)c) : Scene.v().getActiveHierarchy().getSubclassesOf((SootClass)c)).flatMap(Collection::stream), classes.stream()).collect(Collectors.toSet());
    }

    private Set<SootClass> getParentsOfIncluding(Collection<SootClass> classes) {
        HashSet<SootClass> parents = new HashSet<SootClass>(classes);
        for (SootClass clazz : classes) {
            parents.addAll(clazz.getInterfaces());
            if (!clazz.isInterface() && clazz.hasSuperclass()) {
                parents.add(clazz.getSuperclass());
            }
            parents.addAll(clazz.isInterface() ? Scene.v().getActiveHierarchy().getSuperinterfacesOfIncluding(clazz) : Scene.v().getActiveHierarchy().getSuperclassesOfIncluding(clazz));
        }
        return parents;
    }

    private String getNewName(Collection<SootClass> classes, String name) {
        Set names = this.classToRenamingMap.entrySet().stream().filter(entry -> classes.contains(entry.getKey())).map(Map.Entry::getValue).map(Map::entrySet).flatMap(Collection::stream).filter(entry -> ((String)entry.getKey()).equals(name)).map(Map.Entry::getValue).collect(Collectors.toSet());
        if (names.size() > 1) {
            logger.warn("Found {} names for method \"{}\": {}.", new Object[]{names.size(), name, String.join((CharSequence)", ", names)});
        }
        return names.isEmpty() ? null : (String)names.iterator().next();
    }

    private boolean isDeclared(SootClass sootClass, String methodName, List<Type> parameterTypes) {
        for (SootMethod declared : sootClass.getMethods()) {
            if (!declared.getName().equals(methodName) || declared.getParameterCount() != parameterTypes.size()) continue;
            return true;
        }
        return false;
    }

    private static Body getActiveBodySafely(SootMethod method) {
        try {
            return method.getActiveBody();
        }
        catch (Exception exception) {
            logger.warn("Getting Body from SootMethod {} caused exception that was suppressed.", (Throwable)exception);
            return null;
        }
    }
}

