/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple;

import soot.DoubleType;
import soot.Type;
import soot.jimple.ConstantSwitch;
import soot.jimple.IntConstant;
import soot.jimple.NumericConstant;
import soot.jimple.RealConstant;
import soot.util.Switch;

public class DoubleConstant
extends RealConstant {
    public final double value;

    private DoubleConstant(double value) {
        this.value = value;
    }

    public static DoubleConstant v(double value) {
        return new DoubleConstant(value);
    }

    public boolean equals(Object c) {
        return c instanceof DoubleConstant && Double.compare(((DoubleConstant)c).value, this.value) == 0;
    }

    public int hashCode() {
        long v = Double.doubleToLongBits(this.value);
        return (int)(v ^ v >>> 32);
    }

    @Override
    public NumericConstant add(NumericConstant c) {
        this.assertInstanceOf(c);
        return DoubleConstant.v(this.value + ((DoubleConstant)c).value);
    }

    @Override
    public NumericConstant subtract(NumericConstant c) {
        this.assertInstanceOf(c);
        return DoubleConstant.v(this.value - ((DoubleConstant)c).value);
    }

    @Override
    public NumericConstant multiply(NumericConstant c) {
        this.assertInstanceOf(c);
        return DoubleConstant.v(this.value * ((DoubleConstant)c).value);
    }

    @Override
    public NumericConstant divide(NumericConstant c) {
        this.assertInstanceOf(c);
        return DoubleConstant.v(this.value / ((DoubleConstant)c).value);
    }

    @Override
    public NumericConstant remainder(NumericConstant c) {
        this.assertInstanceOf(c);
        return DoubleConstant.v(this.value % ((DoubleConstant)c).value);
    }

    @Override
    public NumericConstant equalEqual(NumericConstant c) {
        this.assertInstanceOf(c);
        return IntConstant.v(Double.compare(this.value, ((DoubleConstant)c).value) == 0 ? 1 : 0);
    }

    @Override
    public NumericConstant notEqual(NumericConstant c) {
        this.assertInstanceOf(c);
        return IntConstant.v(Double.compare(this.value, ((DoubleConstant)c).value) != 0 ? 1 : 0);
    }

    @Override
    public NumericConstant lessThan(NumericConstant c) {
        this.assertInstanceOf(c);
        return IntConstant.v(Double.compare(this.value, ((DoubleConstant)c).value) < 0 ? 1 : 0);
    }

    @Override
    public NumericConstant lessThanOrEqual(NumericConstant c) {
        this.assertInstanceOf(c);
        return IntConstant.v(Double.compare(this.value, ((DoubleConstant)c).value) <= 0 ? 1 : 0);
    }

    @Override
    public NumericConstant greaterThan(NumericConstant c) {
        this.assertInstanceOf(c);
        return IntConstant.v(Double.compare(this.value, ((DoubleConstant)c).value) > 0 ? 1 : 0);
    }

    @Override
    public NumericConstant greaterThanOrEqual(NumericConstant c) {
        this.assertInstanceOf(c);
        return IntConstant.v(Double.compare(this.value, ((DoubleConstant)c).value) >= 0 ? 1 : 0);
    }

    @Override
    public IntConstant cmpg(RealConstant constant) {
        this.assertInstanceOf(constant);
        double cValue = ((DoubleConstant)constant).value;
        if (this.value < cValue) {
            return IntConstant.v(-1);
        }
        if (this.value == cValue) {
            return IntConstant.v(0);
        }
        return IntConstant.v(1);
    }

    @Override
    public IntConstant cmpl(RealConstant constant) {
        this.assertInstanceOf(constant);
        double cValue = ((DoubleConstant)constant).value;
        if (this.value > cValue) {
            return IntConstant.v(1);
        }
        if (this.value == cValue) {
            return IntConstant.v(0);
        }
        return IntConstant.v(-1);
    }

    @Override
    public NumericConstant negate() {
        return DoubleConstant.v(-this.value);
    }

    public String toString() {
        String doubleString = Double.toString(this.value);
        if (doubleString.equals("NaN") || doubleString.equals("Infinity") || doubleString.equals("-Infinity")) {
            return "#" + doubleString;
        }
        return doubleString;
    }

    @Override
    public Type getType() {
        return DoubleType.v();
    }

    @Override
    public void apply(Switch sw) {
        ((ConstantSwitch)sw).caseDoubleConstant(this);
    }

    private void assertInstanceOf(NumericConstant constant) {
        if (!(constant instanceof DoubleConstant)) {
            throw new IllegalArgumentException("DoubleConstant expected");
        }
    }
}

