/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.List;
import soot.SootMethodRef;
import soot.Unit;
import soot.UnitPrinter;
import soot.ValueBox;
import soot.baf.Baf;
import soot.baf.SpecialInvokeInst;
import soot.jimple.ConvertToBaf;
import soot.jimple.ExprSwitch;
import soot.jimple.JimpleToBafContext;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.internal.AbstractInstanceInvokeExpr;
import soot.util.Switch;

public abstract class AbstractSpecialInvokeExpr
extends AbstractInstanceInvokeExpr
implements SpecialInvokeExpr,
ConvertToBaf {
    protected AbstractSpecialInvokeExpr(ValueBox baseBox, SootMethodRef methodRef, ValueBox[] argBoxes) {
        super(methodRef, baseBox, argBoxes);
        if (methodRef.isStatic()) {
            throw new RuntimeException("wrong static-ness");
        }
    }

    @Override
    public boolean equivTo(Object o) {
        if (o instanceof AbstractSpecialInvokeExpr) {
            AbstractSpecialInvokeExpr ie = (AbstractSpecialInvokeExpr)o;
            if (!this.baseBox.getValue().equivTo(ie.baseBox.getValue()) || !this.getMethod().equals(ie.getMethod()) || (this.argBoxes == null ? 0 : this.argBoxes.length) != (ie.argBoxes == null ? 0 : ie.argBoxes.length)) {
                return false;
            }
            if (this.argBoxes != null) {
                for (int i = 0; i < this.argBoxes.length; ++i) {
                    if (this.argBoxes[i].getValue().equivTo(ie.argBoxes[i].getValue())) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int equivHashCode() {
        return this.baseBox.getValue().equivHashCode() * 101 + this.getMethod().equivHashCode() * 17;
    }

    @Override
    public abstract Object clone();

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("specialinvoke " + this.baseBox.getValue().toString() + "." + this.methodRef.getSignature() + "(");
        if (this.argBoxes != null) {
            for (int i = 0; i < this.argBoxes.length; ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(this.argBoxes[i].getValue().toString());
            }
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("specialinvoke");
        up.literal(" ");
        this.baseBox.toString(up);
        up.literal(".");
        up.methodRef(this.methodRef);
        up.literal("(");
        if (this.argBoxes != null) {
            for (int i = 0; i < this.argBoxes.length; ++i) {
                if (i != 0) {
                    up.literal(", ");
                }
                this.argBoxes[i].toString(up);
            }
        }
        up.literal(")");
    }

    @Override
    public void apply(Switch sw) {
        ((ExprSwitch)sw).caseSpecialInvokeExpr(this);
    }

    @Override
    public void convertToBaf(JimpleToBafContext context, List<Unit> out) {
        ((ConvertToBaf)((Object)this.getBase())).convertToBaf(context, out);
        if (this.argBoxes != null) {
            for (ValueBox element : this.argBoxes) {
                ((ConvertToBaf)((Object)element.getValue())).convertToBaf(context, out);
            }
        }
        SpecialInvokeInst u = Baf.v().newSpecialInvokeInst(this.methodRef);
        out.add(u);
        u.addAllTagsOf(context.getCurrentUnit());
    }
}

