/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.ondemand.genericutil;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.security.Permission;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.jimple.spark.ondemand.genericutil.Mapper;
import soot.jimple.spark.ondemand.genericutil.ObjectVisitor;
import soot.jimple.spark.ondemand.genericutil.Predicate;

public class Util {
    private static final Logger logger = LoggerFactory.getLogger(Util.class);
    public static final BitSet EMPTY_BITSET = new BitSet();
    public static final boolean FULLY_QUALIFIED_NAMES = false;

    public static long fact(long n_) {
        long result = 1L;
        for (long i = 1L; i <= n_; ++i) {
            result *= i;
        }
        return result;
    }

    public static BigInteger fact(BigInteger n_) {
        BigInteger result = BigInteger.ONE;
        BigInteger i = BigInteger.ONE;
        while (i.compareTo(n_) <= 0) {
            result = result.multiply(i);
            i = i.add(BigInteger.ONE);
        }
        return result;
    }

    public static double fact(double n_) {
        n_ += 1.0E-6;
        double result = 1.0;
        for (double i = 1.0; i <= n_; i += 1.0) {
            result *= i;
        }
        return result;
    }

    public static int fact(int n_) {
        int result = 1;
        for (int i = 1; i <= n_; ++i) {
            result *= i;
        }
        return result;
    }

    public static int binaryLogUp(int n_) {
        int k = 0;
        while (1 << k < n_) {
            ++k;
        }
        return k;
    }

    public static int binaryLogUp(long n_) {
        int k = 0;
        while (1L << k < n_) {
            ++k;
        }
        return k;
    }

    public static String str(int[] ints_) {
        StringBuffer s = new StringBuffer();
        s.append("[");
        for (int i = 0; i < ints_.length; ++i) {
            if (i > 0) {
                s.append(", ");
            }
            s.append(ints_[i]);
        }
        s.append("]");
        return s.toString();
    }

    public static String objArrayToString(Object[] o) {
        return Util.objArrayToString(o, "[", "]", ", ");
    }

    public static String objArrayToString(Object[] o, String start, String end, String sep) {
        StringBuffer s = new StringBuffer();
        s.append(start);
        for (int i = 0; i < o.length; ++i) {
            if (o[i] == null) continue;
            if (i > 0) {
                s.append(sep);
            }
            s.append(o[i].toString());
        }
        s.append(end);
        return s.toString();
    }

    public static String str(Throwable thrown_) {
        ByteArrayOutputStream traceDump = new ByteArrayOutputStream();
        PrintWriter w = new PrintWriter(traceDump);
        logger.error(thrown_.getMessage(), thrown_);
        w.close();
        return traceDump.toString();
    }

    public static <T> boolean forSome(Collection<T> c_, Predicate<T> p_) {
        for (T t : c_) {
            if (!p_.test(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> T find(Collection<T> c_, Predicate<T> p_) {
        for (T obj : c_) {
            if (!p_.test(obj)) continue;
            return obj;
        }
        return null;
    }

    public static <T> Collection<T> findAll(Collection<T> c_, Predicate<T> p_) {
        LinkedList<T> result = new LinkedList<T>();
        for (T obj : c_) {
            if (!p_.test(obj)) continue;
            result.add(obj);
        }
        return result;
    }

    public static <T> boolean forAll(Collection<T> c_, Predicate<T> p_) {
        for (T t : c_) {
            if (p_.test(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> void doForAll(Collection<T> c_, ObjectVisitor<T> v_) {
        Iterator<T> iter = c_.iterator();
        while (iter.hasNext()) {
            v_.visit(iter.next());
        }
    }

    public static <T, U> List<U> map(List<T> srcList, Mapper<T, U> mapper_) {
        ArrayList<U> result = new ArrayList<U>();
        Iterator<T> srcIter = srcList.iterator();
        while (srcIter.hasNext()) {
            result.add(mapper_.map(srcIter.next()));
        }
        return result;
    }

    public static <T> List<T> filter(Collection<T> src_, Predicate<T> pred_) {
        ArrayList<T> result = new ArrayList<T>();
        for (T curElem : src_) {
            if (!pred_.test(curElem)) continue;
            result.add(curElem);
        }
        return result;
    }

    public static <T> void filter(Collection<T> src_, Predicate<T> pred_, List<T> result_) {
        for (T t : src_) {
            if (!pred_.test(t)) continue;
            result_.add(t);
        }
    }

    public static <T, U> Set<U> mapToSet(Collection<T> srcSet, Mapper<T, U> mapper_) {
        HashSet<U> result = new HashSet<U>();
        Iterator<T> srcIter = srcSet.iterator();
        while (srcIter.hasNext()) {
            result.add(mapper_.map(srcIter.next()));
        }
        return result;
    }

    public static int[] realloc(int[] data_, int newSize_) {
        if (data_.length < newSize_) {
            int[] newData = new int[newSize_];
            System.arraycopy(data_, 0, newData, 0, data_.length);
            return newData;
        }
        return data_;
    }

    public static void clear(BitSet bitSet_) {
        bitSet_.and(EMPTY_BITSET);
    }

    public static String replaceAll(String str_, String sub_, String newSub_) {
        int idx;
        if (str_.indexOf(sub_) == -1) {
            return str_;
        }
        int subLen = sub_.length();
        StringBuffer result = new StringBuffer(str_);
        while ((idx = result.toString().indexOf(sub_)) >= 0) {
            result.replace(idx, idx + subLen, newSub_);
        }
        return result.toString();
    }

    public static String removeAll(String str_, String sub_) {
        return Util.replaceAll(str_, sub_, "");
    }

    public static String objectFieldsToString(Object obj) {
        Class<?> c;
        SecurityManager oldsecurity = System.getSecurityManager();
        System.setSecurityManager(new SecurityManager(){

            @Override
            public void checkPermission(Permission perm) {
            }
        });
        StringBuffer buf = new StringBuffer(Util.removePackageName(c.getName()));
        for (c = obj.getClass(); c != Object.class; c = c.getSuperclass()) {
            Field[] fields = c.getDeclaredFields();
            if (fields.length > 0) {
                buf = buf.append(" (");
            }
            for (int i = 0; i < fields.length; ++i) {
                fields[i].setAccessible(true);
                try {
                    Class<?> type = fields[i].getType();
                    String name = fields[i].getName();
                    Object value = fields[i].get(obj);
                    buf = buf.append(name);
                    buf = buf.append("=");
                    buf = buf.append(value == null ? "null" : value.toString());
                    buf = buf.append(" : ");
                    buf = buf.append(Util.removePackageName(type.getName()));
                }
                catch (IllegalAccessException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                buf = buf.append(i + 1 >= fields.length ? ")" : ",");
            }
        }
        System.setSecurityManager(oldsecurity);
        return buf.toString();
    }

    public static String removePackageName(String fully_qualified_name_) {
        if (fully_qualified_name_ == null) {
            return null;
        }
        int lastdot = fully_qualified_name_.lastIndexOf(46);
        if (lastdot < 0) {
            return "";
        }
        return fully_qualified_name_.substring(lastdot + 1);
    }

    public static int hashArray(Object[] objs) {
        int ret = 1;
        for (int i = 0; i < objs.length; ++i) {
            ret = 31 * ret + (objs[i] == null ? 0 : objs[i].hashCode());
        }
        return ret;
    }

    public static boolean arrayContains(Object[] arr, Object obj, int size) {
        assert (obj != null);
        for (int i = 0; i < size; ++i) {
            if (arr[i] == null || !arr[i].equals(obj)) continue;
            return true;
        }
        return false;
    }

    public static String toStringNull(Object o) {
        return o == null ? "" : "[" + o.toString() + "]";
    }

    public static <T> boolean intersecting(Set<T> s1, final Set<T> s2) {
        return Util.forSome(s1, new Predicate<T>(){

            @Override
            public boolean test(T obj) {
                return s2.contains(obj);
            }
        });
    }

    public static boolean stringContains(String str, String subStr) {
        return str.indexOf(subStr) != -1;
    }

    public static int getInt(Integer i) {
        return i == null ? 0 : i;
    }

    public static String topLevelTypeString(String typeStr) {
        int dollarIndex = typeStr.indexOf(36);
        String topLevelTypeStr = dollarIndex == -1 ? typeStr : typeStr.substring(0, dollarIndex);
        return topLevelTypeStr;
    }

    public static <T> void addIfNotNull(T val, Collection<T> vals) {
        if (val != null) {
            vals.add(val);
        }
    }

    public static <T> List<T> pickNAtRandom(List<T> vals, int n, long seed) {
        if (vals.size() <= n) {
            return vals;
        }
        HashSet<T> elems = new HashSet<T>();
        Random rand = new Random(seed);
        for (int i = 0; i < n; ++i) {
            int randIndex;
            boolean added = true;
            while (!(added = elems.add(vals.get(randIndex = rand.nextInt(n))))) {
            }
        }
        return new ArrayList(elems);
    }
}

