/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.solver;

import java.util.HashSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.jimple.spark.internal.TypeManager;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.spark.solver.TopoSorter;

public class SCCCollapser {
    private static final Logger logger = LoggerFactory.getLogger(SCCCollapser.class);
    protected int numCollapsed = 0;
    protected PAG pag;
    protected HashSet<VarNode> visited = new HashSet();
    protected boolean ignoreTypes;
    protected TypeManager typeManager;

    public void collapse() {
        boolean verbose = this.pag.getOpts().verbose();
        if (verbose) {
            logger.debug("Total VarNodes: " + this.pag.getVarNodeNumberer().size() + ". Collapsing SCCs...");
        }
        new TopoSorter(this.pag, this.ignoreTypes).sort();
        TreeSet<VarNode> s = new TreeSet<VarNode>();
        for (VarNode v : this.pag.getVarNodeNumberer()) {
            s.add(v);
        }
        for (VarNode v : s) {
            this.dfsVisit(v, v);
        }
        if (verbose) {
            logger.debug("" + this.numCollapsed + " nodes were collapsed.");
        }
        this.visited = null;
    }

    public SCCCollapser(PAG pag, boolean ignoreTypes) {
        this.pag = pag;
        this.ignoreTypes = ignoreTypes;
        this.typeManager = pag.getTypeManager();
    }

    protected final void dfsVisit(VarNode v, VarNode rootOfSCC) {
        Node[] succs;
        if (this.visited.contains(v)) {
            return;
        }
        this.visited.add(v);
        for (Node element : succs = this.pag.simpleInvLookup(v)) {
            if (!this.ignoreTypes && !this.typeManager.castNeverFails(element.getType(), v.getType())) continue;
            this.dfsVisit((VarNode)element, rootOfSCC);
        }
        if (v != rootOfSCC) {
            if (!this.ignoreTypes) {
                if (this.typeManager.castNeverFails(v.getType(), rootOfSCC.getType()) && this.typeManager.castNeverFails(rootOfSCC.getType(), v.getType())) {
                    rootOfSCC.mergeWith(v);
                    ++this.numCollapsed;
                }
            } else {
                if (this.typeManager.castNeverFails(v.getType(), rootOfSCC.getType())) {
                    rootOfSCC.mergeWith(v);
                } else if (this.typeManager.castNeverFails(rootOfSCC.getType(), v.getType())) {
                    v.mergeWith(rootOfSCC);
                } else {
                    rootOfSCC.getReplacement().setType(null);
                    PointsToSetInternal set = rootOfSCC.getP2Set();
                    if (set != null) {
                        set.setType(null);
                    }
                    rootOfSCC.mergeWith(v);
                }
                ++this.numCollapsed;
            }
        }
    }
}

