/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.infoflow;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.EquivalentValue;
import soot.RefLikeType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.Value;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.ParameterRef;
import soot.jimple.Ref;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.ThisRef;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.jimple.toolkits.infoflow.CallLocalityContext;
import soot.jimple.toolkits.infoflow.ClassInfoFlowAnalysis;
import soot.jimple.toolkits.infoflow.InfoFlowAnalysis;
import soot.jimple.toolkits.infoflow.LocalObjectsAnalysis;
import soot.jimple.toolkits.infoflow.SmartMethodInfoFlowAnalysis;
import soot.jimple.toolkits.infoflow.SmartMethodLocalObjectsAnalysis;
import soot.jimple.toolkits.infoflow.UseFinder;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.HashMutableDirectedGraph;
import soot.toolkits.scalar.Pair;

public class ClassLocalObjectsAnalysis {
    private static final Logger logger = LoggerFactory.getLogger(ClassLocalObjectsAnalysis.class);
    boolean printdfgs;
    LocalObjectsAnalysis loa;
    InfoFlowAnalysis dfa;
    InfoFlowAnalysis primitiveDfa;
    UseFinder uf;
    SootClass sootClass;
    Map<SootMethod, SmartMethodLocalObjectsAnalysis> methodToMethodLocalObjectsAnalysis;
    Map<SootMethod, CallLocalityContext> methodToContext;
    List<SootMethod> allMethods;
    List<SootMethod> externalMethods;
    List<SootMethod> internalMethods;
    List<SootMethod> entryMethods;
    List<SootField> allFields;
    List<SootField> externalFields;
    List<SootField> internalFields;
    ArrayList<SootField> localFields;
    ArrayList<SootField> sharedFields;
    ArrayList<SootField> localInnerFields;
    ArrayList<SootField> sharedInnerFields;

    public ClassLocalObjectsAnalysis(LocalObjectsAnalysis loa, InfoFlowAnalysis dfa, UseFinder uf, SootClass sootClass) {
        this(loa, dfa, null, uf, sootClass, null);
    }

    public ClassLocalObjectsAnalysis(LocalObjectsAnalysis loa, InfoFlowAnalysis dfa, InfoFlowAnalysis primitiveDfa, UseFinder uf, SootClass sootClass, List<SootMethod> entryMethods) {
        this.printdfgs = dfa.printDebug();
        this.loa = loa;
        this.dfa = dfa;
        this.primitiveDfa = primitiveDfa;
        this.uf = uf;
        this.sootClass = sootClass;
        this.methodToMethodLocalObjectsAnalysis = new HashMap<SootMethod, SmartMethodLocalObjectsAnalysis>();
        this.methodToContext = null;
        this.allMethods = null;
        this.externalMethods = null;
        this.internalMethods = null;
        this.entryMethods = entryMethods;
        this.allFields = null;
        this.externalFields = null;
        this.internalFields = null;
        this.localFields = null;
        this.sharedFields = null;
        this.localInnerFields = null;
        this.sharedInnerFields = null;
        logger.debug("[local-objects] Analyzing local objects for " + sootClass);
        logger.debug("[local-objects]   preparing class             " + new Date());
        this.prepare();
        logger.debug("[local-objects]   analyzing class             " + new Date());
        this.doAnalysis();
        logger.debug("[local-objects]   propagating over call graph " + new Date());
        this.propagate();
        logger.debug("[local-objects]   finished at                 " + new Date());
        logger.debug("[local-objects]   (#analyzed/#encountered): " + SmartMethodInfoFlowAnalysis.counter + "/" + ClassInfoFlowAnalysis.methodCount);
    }

    private void prepare() {
        this.allMethods = ClassLocalObjectsAnalysis.getAllReachableMethods(this.sootClass);
        this.externalMethods = this.uf.getExtMethods(this.sootClass);
        SootClass superclass = this.sootClass;
        if (superclass.hasSuperclass()) {
            superclass = superclass.getSuperclass();
        }
        while (superclass.hasSuperclass()) {
            if (superclass.isApplicationClass()) {
                this.externalMethods.addAll(this.uf.getExtMethods(superclass));
            }
            superclass = superclass.getSuperclass();
        }
        this.internalMethods = new ArrayList<SootMethod>();
        for (SootMethod method : this.allMethods) {
            if (this.externalMethods.contains(method)) continue;
            this.internalMethods.add(method);
        }
        this.allFields = ClassLocalObjectsAnalysis.getAllFields(this.sootClass);
        this.externalFields = this.uf.getExtFields(this.sootClass);
        superclass = this.sootClass;
        if (superclass.hasSuperclass()) {
            superclass = superclass.getSuperclass();
        }
        while (superclass.hasSuperclass()) {
            if (superclass.isApplicationClass()) {
                this.externalFields.addAll(this.uf.getExtFields(superclass));
            }
            superclass = superclass.getSuperclass();
        }
        this.internalFields = new ArrayList<SootField>();
        for (SootField field : this.allFields) {
            if (this.externalFields.contains(field)) continue;
            this.internalFields.add(field);
        }
    }

    public static List<SootMethod> getAllReachableMethods(SootClass sc) {
        ReachableMethods rm = Scene.v().getReachableMethods();
        ArrayList<SootMethod> allMethods = new ArrayList<SootMethod>();
        Iterator<SootMethod> methodsIt = sc.methodIterator();
        while (methodsIt.hasNext()) {
            SootMethod method = methodsIt.next();
            if (!rm.contains(method)) continue;
            allMethods.add(method);
        }
        SootClass superclass = sc;
        if (superclass.hasSuperclass()) {
            superclass = superclass.getSuperclass();
        }
        while (superclass.hasSuperclass()) {
            Iterator<SootMethod> scMethodsIt = superclass.methodIterator();
            while (scMethodsIt.hasNext()) {
                SootMethod scMethod = scMethodsIt.next();
                if (!rm.contains(scMethod)) continue;
                allMethods.add(scMethod);
            }
            superclass = superclass.getSuperclass();
        }
        return allMethods;
    }

    public static List<SootField> getAllFields(SootClass sc) {
        ArrayList<SootField> allFields = new ArrayList<SootField>();
        for (SootField field : sc.getFields()) {
            allFields.add(field);
        }
        SootClass superclass = sc;
        if (superclass.hasSuperclass()) {
            superclass = superclass.getSuperclass();
        }
        while (superclass.hasSuperclass()) {
            for (SootField scField : superclass.getFields()) {
                allFields.add(scField);
            }
            superclass = superclass.getSuperclass();
        }
        return allFields;
    }

    private void doAnalysis() {
        this.localFields = new ArrayList();
        this.sharedFields = new ArrayList();
        for (SootField field : this.allFields) {
            if (this.fieldIsInitiallyLocal(field)) {
                this.localFields.add(field);
                continue;
            }
            this.sharedFields.add(field);
        }
        this.localInnerFields = new ArrayList();
        this.sharedInnerFields = new ArrayList();
        for (SootMethod method : this.allMethods) {
            HashMutableDirectedGraph<EquivalentValue> dataFlowSummary;
            if (this.primitiveDfa != null) {
                dataFlowSummary = this.primitiveDfa.getMethodInfoFlowSummary(method);
                if (this.printdfgs && method.getDeclaringClass().isApplicationClass()) {
                    logger.debug("Attempting to print graphs (will succeed only if ./dfg/ is a valid path)");
                    HashMutableDirectedGraph<EquivalentValue> primitiveGraph = this.primitiveDfa.getMethodInfoFlowAnalysis(method).getMethodAbbreviatedInfoFlowGraph();
                    InfoFlowAnalysis.printGraphToDotFile("dfg/" + method.getDeclaringClass().getShortName() + "_" + method.getName() + "_primitive", primitiveGraph, method.getName() + "_primitive", false);
                    HashMutableDirectedGraph<EquivalentValue> nonPrimitiveGraph = this.dfa.getMethodInfoFlowAnalysis(method).getMethodAbbreviatedInfoFlowGraph();
                    InfoFlowAnalysis.printGraphToDotFile("dfg/" + method.getDeclaringClass().getShortName() + "_" + method.getName(), nonPrimitiveGraph, method.getName(), false);
                }
            } else {
                dataFlowSummary = this.dfa.getMethodInfoFlowSummary(method);
                if (this.printdfgs && method.getDeclaringClass().isApplicationClass()) {
                    logger.debug("Attempting to print graph (will succeed only if ./dfg/ is a valid path)");
                    HashMutableDirectedGraph<EquivalentValue> nonPrimitiveGraph = this.dfa.getMethodInfoFlowAnalysis(method).getMethodAbbreviatedInfoFlowGraph();
                    InfoFlowAnalysis.printGraphToDotFile("dfg/" + method.getDeclaringClass().getShortName() + "_" + method.getName(), nonPrimitiveGraph, method.getName(), false);
                }
            }
            for (EquivalentValue node : dataFlowSummary.getNodes()) {
                InstanceFieldRef ifr;
                if (!(node.getValue() instanceof InstanceFieldRef) || this.localFields.contains((ifr = (InstanceFieldRef)node.getValue()).getField()) || this.sharedFields.contains(ifr.getField()) || this.localInnerFields.contains(ifr.getField())) continue;
                this.localInnerFields.add(ifr.getField());
            }
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            for (SootMethod method : this.allMethods) {
                if (method.isStatic() || !method.isConcrete()) continue;
                ListIterator localFieldsIt = this.localFields.listIterator();
                block5: while (localFieldsIt.hasNext()) {
                    EquivalentValue node;
                    SootField localField = (SootField)localFieldsIt.next();
                    ArrayList<EquivalentValue> sourcesAndSinks = new ArrayList<EquivalentValue>();
                    HashMutableDirectedGraph<EquivalentValue> dataFlowSummary = this.primitiveDfa != null ? this.primitiveDfa.getMethodInfoFlowSummary(method) : this.dfa.getMethodInfoFlowSummary(method);
                    if (dataFlowSummary.containsNode(node = InfoFlowAnalysis.getNodeForFieldRef(method, localField))) {
                        sourcesAndSinks.addAll(dataFlowSummary.getSuccsOf(node));
                        sourcesAndSinks.addAll(dataFlowSummary.getPredsOf(node));
                    }
                    Iterator sourcesAndSinksIt = sourcesAndSinks.iterator();
                    if (!localField.getDeclaringClass().isApplicationClass() || sourcesAndSinksIt.hasNext()) {
                        // empty if block
                    }
                    while (sourcesAndSinksIt.hasNext()) {
                        EquivalentValue sourceOrSink = (EquivalentValue)sourcesAndSinksIt.next();
                        Ref sourceOrSinkRef = (Ref)sourceOrSink.getValue();
                        boolean fieldBecomesShared = false;
                        if (sourceOrSinkRef instanceof ParameterRef) {
                            fieldBecomesShared = !this.parameterIsLocal(method, sourceOrSink, true);
                        } else if (sourceOrSinkRef instanceof ThisRef) {
                            fieldBecomesShared = !this.thisIsLocal(method, sourceOrSink);
                        } else if (sourceOrSinkRef instanceof InstanceFieldRef) {
                            fieldBecomesShared = this.sharedFields.contains(((FieldRef)sourceOrSinkRef).getField()) || this.sharedInnerFields.contains(((FieldRef)sourceOrSinkRef).getField());
                        } else if (sourceOrSinkRef instanceof StaticFieldRef) {
                            fieldBecomesShared = true;
                        } else {
                            throw new RuntimeException("Unknown type of Ref in Data Flow Graph:");
                        }
                        if (!fieldBecomesShared) continue;
                        localFieldsIt.remove();
                        this.sharedFields.add(localField);
                        changed = true;
                        continue block5;
                    }
                }
                ListIterator localInnerFieldsIt = this.localInnerFields.listIterator();
                block7: while (!changed && localInnerFieldsIt.hasNext()) {
                    EquivalentValue node;
                    SootField localInnerField = (SootField)localInnerFieldsIt.next();
                    ArrayList<EquivalentValue> sourcesAndSinks = new ArrayList<EquivalentValue>();
                    HashMutableDirectedGraph<EquivalentValue> dataFlowSummary = this.primitiveDfa != null ? this.primitiveDfa.getMethodInfoFlowSummary(method) : this.dfa.getMethodInfoFlowSummary(method);
                    if (dataFlowSummary.containsNode(node = InfoFlowAnalysis.getNodeForFieldRef(method, localInnerField))) {
                        sourcesAndSinks.addAll(dataFlowSummary.getSuccsOf(node));
                        sourcesAndSinks.addAll(dataFlowSummary.getPredsOf(node));
                    }
                    Iterator sourcesAndSinksIt = sourcesAndSinks.iterator();
                    if (!localInnerField.getDeclaringClass().isApplicationClass() || sourcesAndSinksIt.hasNext()) {
                        // empty if block
                    }
                    while (sourcesAndSinksIt.hasNext()) {
                        EquivalentValue sourceOrSink = (EquivalentValue)sourcesAndSinksIt.next();
                        Ref sourceOrSinkRef = (Ref)sourceOrSink.getValue();
                        boolean fieldBecomesShared = false;
                        if (sourceOrSinkRef instanceof ParameterRef) {
                            fieldBecomesShared = !this.parameterIsLocal(method, sourceOrSink, true);
                        } else if (sourceOrSinkRef instanceof ThisRef) {
                            fieldBecomesShared = !this.thisIsLocal(method, sourceOrSink);
                        } else if (sourceOrSinkRef instanceof InstanceFieldRef) {
                            fieldBecomesShared = this.sharedFields.contains(((FieldRef)sourceOrSinkRef).getField()) || this.sharedInnerFields.contains(((FieldRef)sourceOrSinkRef).getField());
                        } else if (sourceOrSinkRef instanceof StaticFieldRef) {
                            fieldBecomesShared = true;
                        } else {
                            throw new RuntimeException("Unknown type of Ref in Data Flow Graph:");
                        }
                        if (!fieldBecomesShared) continue;
                        localInnerFieldsIt.remove();
                        this.sharedInnerFields.add(localInnerField);
                        changed = true;
                        continue block7;
                    }
                }
            }
        }
        if (this.dfa.printDebug()) {
            logger.debug("        Found local/shared fields for " + this.sootClass.toString());
            logger.debug("          Local fields: ");
            for (SootField localToPrint : this.localFields) {
                if (!localToPrint.getDeclaringClass().isApplicationClass()) continue;
                logger.debug("                  " + localToPrint);
            }
            logger.debug("          Shared fields: ");
            for (SootField sharedToPrint : this.sharedFields) {
                if (!sharedToPrint.getDeclaringClass().isApplicationClass()) continue;
                logger.debug("                  " + sharedToPrint);
            }
            logger.debug("          Local inner fields: ");
            for (SootField localToPrint : this.localInnerFields) {
                if (!localToPrint.getDeclaringClass().isApplicationClass()) continue;
                logger.debug("                  " + localToPrint);
            }
            logger.debug("          Shared inner fields: ");
            for (SootField sharedToPrint : this.sharedInnerFields) {
                if (!sharedToPrint.getDeclaringClass().isApplicationClass()) continue;
                logger.debug("                  " + sharedToPrint);
            }
        }
    }

    private void propagate() {
        ArrayList<SootMethod> worklist = new ArrayList<SootMethod>();
        worklist.addAll(this.entryMethods);
        this.methodToContext = new HashMap<SootMethod, CallLocalityContext>();
        for (SootMethod method : worklist) {
            this.methodToContext.put(method, this.getContextFor(method));
        }
        Date start = new Date();
        if (this.dfa.printDebug()) {
            logger.debug("CLOA: Starting Propagation at " + start);
        }
        while (worklist.size() > 0) {
            ArrayList<SootMethod> newWorklist = new ArrayList<SootMethod>();
            for (SootMethod containingMethod : worklist) {
                CallLocalityContext containingContext = this.methodToContext.get(containingMethod);
                if (this.dfa.printDebug()) {
                    logger.debug("      " + containingMethod.getName() + " " + containingContext.toShortString());
                }
                HashMap<Stmt, CallLocalityContext> invokeToContext = new HashMap<Stmt, CallLocalityContext>();
                Iterator<Edge> edgesIt = Scene.v().getCallGraph().edgesOutOf(containingMethod);
                while (edgesIt.hasNext()) {
                    CallLocalityContext invokeContext;
                    Edge e = edgesIt.next();
                    if (!e.src().getDeclaringClass().isApplicationClass() || e.srcStmt() == null) continue;
                    if (!invokeToContext.containsKey(e.srcStmt())) {
                        invokeContext = this.getContextFor(e, containingMethod, containingContext);
                        invokeToContext.put(e.srcStmt(), invokeContext);
                    } else {
                        invokeContext = (CallLocalityContext)invokeToContext.get(e.srcStmt());
                    }
                    if (!this.methodToContext.containsKey(e.tgt())) {
                        this.methodToContext.put(e.tgt(), invokeContext);
                        newWorklist.add(e.tgt());
                        continue;
                    }
                    boolean causedChange = this.methodToContext.get(e.tgt()).merge(invokeContext);
                    if (!causedChange) continue;
                    newWorklist.add(e.tgt());
                }
            }
            worklist = newWorklist;
        }
        long longTime = (new Date().getTime() - start.getTime()) / 100L;
        float time = (float)longTime / 10.0f;
        if (this.dfa.printDebug()) {
            logger.debug("CLOA: Ending Propagation after " + time + "s");
        }
    }

    public CallLocalityContext getMergedContext(SootMethod method) {
        if (this.methodToContext.containsKey(method)) {
            return this.methodToContext.get(method);
        }
        return null;
    }

    private CallLocalityContext getContextFor(Edge e, SootMethod containingMethod, CallLocalityContext containingContext) {
        InvokeExpr ie = e.srcStmt().containsInvokeExpr() ? e.srcStmt().getInvokeExpr() : null;
        SootMethod callingMethod = e.tgt();
        CallLocalityContext callingContext = new CallLocalityContext(this.dfa.getMethodInfoFlowSummary(callingMethod).getNodes());
        if (callingMethod.isConcrete()) {
            Body b = containingMethod.retrieveActiveBody();
            if (ie != null && ie instanceof InstanceInvokeExpr) {
                InstanceInvokeExpr iie = (InstanceInvokeExpr)ie;
                if (!containingMethod.isStatic() && iie.getBase().equivTo(b.getThisLocal())) {
                    for (EquivalentValue equivalentValue : containingContext.getLocalRefs()) {
                        Ref r = (Ref)equivalentValue.getValue();
                        if (r instanceof InstanceFieldRef) {
                            EquivalentValue newRefEqVal = InfoFlowAnalysis.getNodeForFieldRef(callingMethod, ((FieldRef)r).getFieldRef().resolve());
                            if (!callingContext.containsField(newRefEqVal)) continue;
                            callingContext.setFieldLocal(newRefEqVal);
                            continue;
                        }
                        if (!(r instanceof ThisRef)) continue;
                        callingContext.setThisLocal();
                    }
                } else if (SmartMethodLocalObjectsAnalysis.isObjectLocal(this.dfa, containingMethod, containingContext, iie.getBase())) {
                    callingContext.setAllFieldsLocal();
                    callingContext.setThisLocal();
                } else {
                    callingContext.setAllFieldsShared();
                    callingContext.setThisShared();
                }
            } else {
                callingContext.setAllFieldsShared();
                callingContext.setThisShared();
            }
            if (ie == null) {
                callingContext.setAllParamsShared();
            } else {
                for (int param = 0; param < ie.getArgCount(); ++param) {
                    if (SmartMethodLocalObjectsAnalysis.isObjectLocal(this.dfa, containingMethod, containingContext, ie.getArg(param))) {
                        callingContext.setParamLocal(param);
                        continue;
                    }
                    callingContext.setParamShared(param);
                }
            }
        } else {
            callingContext.setAllFieldsShared();
            callingContext.setThisShared();
            callingContext.setAllParamsShared();
        }
        return callingContext;
    }

    public CallLocalityContext getContextFor(SootMethod sm) {
        return this.getContextFor(sm, false);
    }

    private CallLocalityContext getContextFor(SootMethod sm, boolean includePrimitiveDataFlowIfAvailable) {
        EquivalentValue fieldRefEqVal;
        CallLocalityContext context = includePrimitiveDataFlowIfAvailable ? new CallLocalityContext(this.primitiveDfa.getMethodInfoFlowSummary(sm).getNodes()) : new CallLocalityContext(this.dfa.getMethodInfoFlowSummary(sm).getNodes());
        for (int i = 0; i < sm.getParameterCount(); ++i) {
            EquivalentValue paramEqVal = InfoFlowAnalysis.getNodeForParameterRef(sm, i);
            if (this.parameterIsLocal(sm, paramEqVal, includePrimitiveDataFlowIfAvailable)) {
                context.setParamLocal(i);
                continue;
            }
            context.setParamShared(i);
        }
        for (SootField sf : this.getLocalFields()) {
            fieldRefEqVal = InfoFlowAnalysis.getNodeForFieldRef(sm, sf);
            context.setFieldLocal(fieldRefEqVal);
        }
        for (SootField sf : this.getSharedFields()) {
            fieldRefEqVal = InfoFlowAnalysis.getNodeForFieldRef(sm, sf);
            context.setFieldShared(fieldRefEqVal);
        }
        return context;
    }

    public boolean isObjectLocal(Value localOrRef, SootMethod sm) {
        return this.isObjectLocal(localOrRef, sm, false);
    }

    private boolean isObjectLocal(Value localOrRef, SootMethod sm, boolean includePrimitiveDataFlowIfAvailable) {
        if (localOrRef instanceof StaticFieldRef) {
            return false;
        }
        if (this.dfa.printDebug()) {
            logger.debug("      CLOA testing if " + localOrRef + " is local in " + sm);
        }
        SmartMethodLocalObjectsAnalysis smloa = this.getMethodLocalObjectsAnalysis(sm, includePrimitiveDataFlowIfAvailable);
        if (localOrRef instanceof InstanceFieldRef) {
            InstanceFieldRef ifr = (InstanceFieldRef)localOrRef;
            if (ifr.getBase().equivTo(smloa.getThisLocal())) {
                return this.isFieldLocal(ifr.getFieldRef().resolve());
            }
            if (this.isObjectLocal(ifr.getBase(), sm, includePrimitiveDataFlowIfAvailable)) {
                boolean retval = this.loa.isFieldLocalToParent(ifr.getFieldRef().resolve());
                if (this.dfa.printDebug()) {
                    logger.debug("      " + (retval ? "local" : "shared"));
                }
                return retval;
            }
            if (this.dfa.printDebug()) {
                logger.debug("      shared");
            }
            return false;
        }
        CallLocalityContext context = this.getContextFor(sm);
        boolean retval = smloa.isObjectLocal(localOrRef, context);
        if (this.dfa.printDebug()) {
            logger.debug("      " + (retval ? "local" : "shared"));
        }
        return retval;
    }

    public SmartMethodLocalObjectsAnalysis getMethodLocalObjectsAnalysis(SootMethod sm) {
        return this.getMethodLocalObjectsAnalysis(sm, false);
    }

    private SmartMethodLocalObjectsAnalysis getMethodLocalObjectsAnalysis(SootMethod sm, boolean includePrimitiveDataFlowIfAvailable) {
        if (includePrimitiveDataFlowIfAvailable && this.primitiveDfa != null) {
            Body b = sm.retrieveActiveBody();
            ExceptionalUnitGraph g = new ExceptionalUnitGraph(b);
            return new SmartMethodLocalObjectsAnalysis(g, this.primitiveDfa);
        }
        if (!this.methodToMethodLocalObjectsAnalysis.containsKey(sm)) {
            Body b = sm.retrieveActiveBody();
            ExceptionalUnitGraph g = new ExceptionalUnitGraph(b);
            SmartMethodLocalObjectsAnalysis smloa = new SmartMethodLocalObjectsAnalysis(g, this.dfa);
            this.methodToMethodLocalObjectsAnalysis.put(sm, smloa);
        }
        return this.methodToMethodLocalObjectsAnalysis.get(sm);
    }

    private boolean fieldIsInitiallyLocal(SootField field) {
        if (field.isStatic()) {
            return false;
        }
        if (field.isPrivate()) {
            return true;
        }
        return !this.externalFields.contains(field);
    }

    protected List<SootField> getSharedFields() {
        return (List)this.sharedFields.clone();
    }

    protected List<SootField> getLocalFields() {
        return (List)this.localFields.clone();
    }

    public List<SootField> getInnerSharedFields() {
        return this.sharedInnerFields;
    }

    protected boolean isFieldLocal(SootField field) {
        return this.localFields.contains(field);
    }

    protected boolean isFieldLocal(EquivalentValue fieldRef) {
        return this.localFields.contains(((SootFieldRef)((Object)fieldRef.getValue())).resolve());
    }

    public boolean parameterIsLocal(SootMethod method, EquivalentValue parameterRef) {
        return this.parameterIsLocal(method, parameterRef, false);
    }

    protected boolean parameterIsLocal(SootMethod method, EquivalentValue parameterRef, boolean includePrimitiveDataFlowIfAvailable) {
        ParameterRef param;
        if (this.dfa.printDebug() && method.getDeclaringClass().isApplicationClass()) {
            logger.debug("        Checking PARAM " + parameterRef + " for " + method);
        }
        if (!((param = (ParameterRef)parameterRef.getValue()).getType() instanceof RefLikeType || this.dfa.includesPrimitiveInfoFlow() && !method.getName().equals("<init>"))) {
            if (this.dfa.printDebug() && method.getDeclaringClass().isApplicationClass()) {
                logger.debug("          PARAM is local (primitive)");
            }
            return true;
        }
        List extClassCalls = this.uf.getExtCalls(this.sootClass);
        for (Pair extCall : extClassCalls) {
            Stmt s = (Stmt)extCall.getO2();
            if (s.getInvokeExpr().getMethodRef().resolve() != method) continue;
            if (this.dfa.printDebug() && method.getDeclaringClass().isApplicationClass()) {
                logger.debug("          PARAM is shared (external access)");
            }
            return false;
        }
        List intClassCalls = this.uf.getIntCalls(this.sootClass);
        for (Pair intCall : intClassCalls) {
            Value obj;
            SootMethod containingMethod = (SootMethod)intCall.getO1();
            Stmt s = (Stmt)intCall.getO2();
            InvokeExpr ie = s.getInvokeExpr();
            if (ie.getMethodRef().resolve() != method) continue;
            if (((ParameterRef)parameterRef.getValue()).getIndex() >= 0) {
                if (this.isObjectLocal(ie.getArg(((ParameterRef)parameterRef.getValue()).getIndex()), containingMethod, includePrimitiveDataFlowIfAvailable)) continue;
                if (this.dfa.printDebug() && method.getDeclaringClass().isApplicationClass()) {
                    logger.debug("          PARAM is shared (internal propagation)");
                }
                return false;
            }
            if (!(s instanceof DefinitionStmt) || this.isObjectLocal(obj = ((DefinitionStmt)s).getLeftOp(), containingMethod, includePrimitiveDataFlowIfAvailable)) continue;
            if (this.dfa.printDebug() && method.getDeclaringClass().isApplicationClass()) {
                logger.debug("          PARAM is shared (internal propagation)");
            }
            return false;
        }
        if (this.dfa.printDebug() && method.getDeclaringClass().isApplicationClass()) {
            logger.debug("          PARAM is local SO FAR (internal propagation)");
        }
        return true;
    }

    protected boolean thisIsLocal(SootMethod method, EquivalentValue thisRef) {
        return true;
    }
}

