/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.pointer;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.G;
import soot.PointsToSet;
import soot.SootField;
import soot.jimple.toolkits.pointer.FullObjectSet;
import soot.jimple.toolkits.pointer.RWSet;
import soot.jimple.toolkits.pointer.StmtRWSet;
import soot.jimple.toolkits.pointer.Union;

public class MethodRWSet
extends RWSet {
    private static final Logger logger = LoggerFactory.getLogger(MethodRWSet.class);
    public Set globals;
    public Map<Object, PointsToSet> fields;
    protected boolean callsNative = false;
    protected boolean isFull = false;
    public static final int MAX_SIZE = Integer.MAX_VALUE;

    public String toString() {
        boolean empty = true;
        StringBuffer ret = new StringBuffer();
        if (this.fields != null) {
            Iterator<Object> iterator = this.fields.keySet().iterator();
            while (iterator.hasNext()) {
                Object element;
                Object field = element = iterator.next();
                ret.append("[Field: " + field + " " + this.fields.get(field) + "]\n");
                empty = false;
            }
        }
        if (this.globals != null) {
            for (Object global : this.globals) {
                ret.append("[Global: " + global + "]\n");
                empty = false;
            }
        }
        if (empty) {
            ret.append("empty");
        }
        return ret.toString();
    }

    @Override
    public int size() {
        if (this.globals == null) {
            if (this.fields == null) {
                return 0;
            }
            return this.fields.size();
        }
        if (this.fields == null) {
            return this.globals.size();
        }
        return this.globals.size() + this.fields.size();
    }

    @Override
    public boolean getCallsNative() {
        return this.callsNative;
    }

    @Override
    public boolean setCallsNative() {
        boolean ret = !this.callsNative;
        this.callsNative = true;
        return ret;
    }

    public Set getGlobals() {
        if (this.isFull) {
            return G.v().MethodRWSet_allGlobals;
        }
        if (this.globals == null) {
            return Collections.EMPTY_SET;
        }
        return this.globals;
    }

    public Set getFields() {
        if (this.isFull) {
            return G.v().MethodRWSet_allFields;
        }
        if (this.fields == null) {
            return Collections.EMPTY_SET;
        }
        return this.fields.keySet();
    }

    @Override
    public PointsToSet getBaseForField(Object f) {
        if (this.isFull) {
            return FullObjectSet.v();
        }
        if (this.fields == null) {
            return null;
        }
        return this.fields.get(f);
    }

    @Override
    public boolean hasNonEmptyIntersection(RWSet oth) {
        if (this.isFull) {
            return oth != null;
        }
        if (!(oth instanceof MethodRWSet)) {
            return oth.hasNonEmptyIntersection(this);
        }
        MethodRWSet other = (MethodRWSet)oth;
        if (this.globals != null && other.globals != null && !this.globals.isEmpty() && !other.globals.isEmpty()) {
            Iterator it = other.globals.iterator();
            while (it.hasNext()) {
                if (!this.globals.contains(it.next())) continue;
                return true;
            }
        }
        if (this.fields != null && other.fields != null && !this.fields.isEmpty() && !other.fields.isEmpty()) {
            for (Object element : other.fields.keySet()) {
                Object field = element;
                if (!this.fields.containsKey(field) || !Union.hasNonEmptyIntersection(this.getBaseForField(field), other.getBaseForField(field))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean union(RWSet other) {
        if (other == null) {
            return false;
        }
        if (this.isFull) {
            return false;
        }
        boolean ret = false;
        if (other instanceof MethodRWSet) {
            MethodRWSet o = (MethodRWSet)other;
            if (o.getCallsNative()) {
                ret = !this.getCallsNative() | ret;
                this.setCallsNative();
            }
            if (o.isFull) {
                ret = !this.isFull | ret;
                this.isFull = true;
                throw new RuntimeException("attempt to add full set " + o + " into " + this);
            }
            if (o.globals != null) {
                if (this.globals == null) {
                    this.globals = new HashSet();
                }
                ret = this.globals.addAll(o.globals) | ret;
                if (this.globals.size() > Integer.MAX_VALUE) {
                    this.globals = null;
                    this.isFull = true;
                    throw new RuntimeException("attempt to add full set " + o + " into " + this);
                }
            }
            if (o.fields != null) {
                Iterator<Object> iterator = o.fields.keySet().iterator();
                while (iterator.hasNext()) {
                    Object element;
                    Object field = element = iterator.next();
                    PointsToSet os = o.getBaseForField(field);
                    ret = this.addFieldRef(os, field) | ret;
                }
            }
        } else {
            StmtRWSet oth = (StmtRWSet)other;
            if (oth.base != null) {
                ret = this.addFieldRef(oth.base, oth.field) | ret;
            } else if (oth.field != null) {
                ret = this.addGlobal((SootField)oth.field) | ret;
            }
        }
        if (!this.getCallsNative() && other.getCallsNative()) {
            this.setCallsNative();
            return true;
        }
        return ret;
    }

    @Override
    public boolean addGlobal(SootField global) {
        if (this.globals == null) {
            this.globals = new HashSet();
        }
        boolean ret = this.globals.add(global);
        if (this.globals.size() > Integer.MAX_VALUE) {
            this.globals = null;
            this.isFull = true;
            throw new RuntimeException("attempt to add more than 2147483647 globals into " + this);
        }
        return ret;
    }

    @Override
    public boolean addFieldRef(PointsToSet otherBase, Object field) {
        Union u;
        PointsToSet base;
        boolean ret = false;
        if (this.fields == null) {
            this.fields = new HashMap<Object, PointsToSet>();
        }
        if ((base = this.getBaseForField(field)) instanceof FullObjectSet) {
            return false;
        }
        if (otherBase instanceof FullObjectSet) {
            this.fields.put(field, otherBase);
            return true;
        }
        if (otherBase.equals(base)) {
            return false;
        }
        if (base == null || !(base instanceof Union)) {
            u = G.v().Union_factory.newUnion();
            if (base != null) {
                u.addAll(base);
            }
            this.fields.put(field, u);
            if (base == null) {
                MethodRWSet.addedField(this.fields.size());
            }
            ret = true;
            if (this.fields.keySet().size() > Integer.MAX_VALUE) {
                this.fields = null;
                this.isFull = true;
                throw new RuntimeException("attempt to add more than 2147483647 fields into " + this);
            }
        } else {
            u = (Union)base;
        }
        ret = u.addAll(otherBase) | ret;
        return ret;
    }

    static void addedField(int size) {
    }

    @Override
    public boolean isEquivTo(RWSet other) {
        return other == this;
    }
}

