/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Singletons;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.jimple.GotoStmt;
import soot.jimple.IfStmt;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.StmtBody;
import soot.jimple.toolkits.scalar.Evaluator;
import soot.options.Options;

public class ConditionalBranchFolder
extends BodyTransformer {
    private static final Logger logger = LoggerFactory.getLogger(ConditionalBranchFolder.class);

    public ConditionalBranchFolder(Singletons.Global g) {
    }

    public static ConditionalBranchFolder v() {
        return G.v().soot_jimple_toolkits_scalar_ConditionalBranchFolder();
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map<String, String> options) {
        StmtBody stmtBody = (StmtBody)body;
        int numTrue = 0;
        int numFalse = 0;
        if (Options.v().verbose()) {
            logger.debug("[" + stmtBody.getMethod().getName() + "] Folding conditional branches...");
        }
        UnitPatchingChain units = stmtBody.getUnits();
        for (Unit stmt : units.toArray(new Unit[units.size()])) {
            IfStmt ifs;
            Value cond;
            if (!(stmt instanceof IfStmt) || !Evaluator.isValueConstantValued(cond = (ifs = (IfStmt)stmt).getCondition())) continue;
            cond = Evaluator.getConstantValueOf(cond);
            if (((IntConstant)cond).value == 1) {
                GotoStmt newStmt = Jimple.v().newGotoStmt(ifs.getTarget());
                units.insertAfter(newStmt, stmt);
                ++numTrue;
            } else {
                ++numFalse;
            }
            units.remove(stmt);
        }
        if (Options.v().verbose()) {
            logger.debug("[" + stmtBody.getMethod().getName() + "]     Folded " + numTrue + " true, " + numFalse + " conditional branches");
        }
    }
}

