/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Local;
import soot.RefType;
import soot.Singletons;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.CastExpr;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.NullConstant;
import soot.jimple.NumericConstant;
import soot.jimple.StringConstant;
import soot.jimple.toolkits.scalar.Evaluator;
import soot.options.Options;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.PseudoTopologicalOrderer;
import soot.toolkits.scalar.LocalDefs;

public class ConstantPropagatorAndFolder
extends BodyTransformer {
    private static final Logger logger = LoggerFactory.getLogger(ConstantPropagatorAndFolder.class);

    public ConstantPropagatorAndFolder(Singletons.Global g) {
    }

    public static ConstantPropagatorAndFolder v() {
        return G.v().soot_jimple_toolkits_scalar_ConstantPropagatorAndFolder();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        int numFolded = 0;
        int numPropagated = 0;
        if (Options.v().verbose()) {
            logger.debug("[" + b.getMethod().getName() + "] Propagating and folding constants...");
        }
        ExceptionalUnitGraph g = new ExceptionalUnitGraph(b);
        LocalDefs localDefs = LocalDefs.Factory.newLocalDefs(g);
        PseudoTopologicalOrderer<Unit> orderer = new PseudoTopologicalOrderer<Unit>();
        for (Unit u : orderer.newList(g, false)) {
            Value value;
            for (ValueBox useBox : u.getUseBoxes()) {
                CastExpr ce;
                Local local;
                List<Unit> defsOfUse;
                value = useBox.getValue();
                if (!(value instanceof Local) || (defsOfUse = localDefs.getDefsOfAt(local = (Local)value, u)).size() != 1) continue;
                DefinitionStmt defStmt = (DefinitionStmt)defsOfUse.get(0);
                Value rhs = defStmt.getRightOp();
                if (rhs instanceof NumericConstant || rhs instanceof StringConstant || rhs instanceof NullConstant) {
                    if (!useBox.canContainValue(rhs)) continue;
                    useBox.setValue(rhs);
                    ++numPropagated;
                    continue;
                }
                if (!(rhs instanceof CastExpr) || !((ce = (CastExpr)rhs).getCastType() instanceof RefType) || !(ce.getOp() instanceof NullConstant)) continue;
                defStmt.getRightOpBox().setValue(NullConstant.v());
                ++numPropagated;
            }
            for (ValueBox useBox : u.getUseBoxes()) {
                Value constValue;
                value = useBox.getValue();
                if (value instanceof Constant || !Evaluator.isValueConstantValued(value) || !useBox.canContainValue(constValue = Evaluator.getConstantValueOf(value))) continue;
                useBox.setValue(constValue);
                ++numFolded;
            }
        }
        if (Options.v().verbose()) {
            logger.debug("[" + b.getMethod().getName() + "]     Propagated: " + numPropagated + ", Folded:  " + numFolded);
        }
    }
}

