/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar.pre;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.EquivalentValue;
import soot.SideEffectTester;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.FieldRef;
import soot.jimple.toolkits.scalar.pre.DownSafetyAnalysis;
import soot.jimple.toolkits.scalar.pre.UpSafetyAnalysis;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.FlowSet;

public class EarliestnessComputation {
    private Map<Unit, FlowSet<EquivalentValue>> unitToEarliest;

    public EarliestnessComputation(UnitGraph unitGraph, UpSafetyAnalysis upSafe, DownSafetyAnalysis downSafe, SideEffectTester sideEffect) {
        this(unitGraph, upSafe, downSafe, sideEffect, new ArraySparseSet<EquivalentValue>());
    }

    public EarliestnessComputation(UnitGraph unitGraph, UpSafetyAnalysis upSafe, DownSafetyAnalysis downSafe, SideEffectTester sideEffect, FlowSet<EquivalentValue> set) {
        this.unitToEarliest = new HashMap<Unit, FlowSet<EquivalentValue>>(unitGraph.size() + 1, 0.7f);
        for (Unit currentUnit : unitGraph) {
            FlowSet<EquivalentValue> earliest = set.emptySet();
            this.unitToEarliest.put(currentUnit, earliest);
            FlowSet downSafeSet = ((FlowSet)downSafe.getFlowBefore(currentUnit)).clone();
            List<Unit> predList = unitGraph.getPredsOf(currentUnit);
            if (predList.isEmpty()) {
                earliest.union(downSafeSet);
                continue;
            }
            for (Unit predecessor : predList) {
                EquivalentValue equiVal;
                Iterator downSafeIt = downSafeSet.iterator();
                block2: while (downSafeIt.hasNext()) {
                    equiVal = (EquivalentValue)downSafeIt.next();
                    Value avail = equiVal.getValue();
                    if (avail instanceof FieldRef) {
                        if (!sideEffect.unitCanWriteTo(predecessor, avail)) continue;
                        earliest.add(equiVal);
                        downSafeIt.remove();
                        continue;
                    }
                    for (ValueBox useBox : avail.getUseBoxes()) {
                        Value use = useBox.getValue();
                        if (!sideEffect.unitCanWriteTo(predecessor, use)) continue;
                        earliest.add(equiVal);
                        downSafeIt.remove();
                        continue block2;
                    }
                }
                downSafeIt = downSafeSet.iterator();
                while (downSafeIt.hasNext()) {
                    equiVal = (EquivalentValue)downSafeIt.next();
                    FlowSet preDown = (FlowSet)downSafe.getFlowBefore(predecessor);
                    FlowSet preUp = (FlowSet)upSafe.getFlowBefore(predecessor);
                    if (preDown.contains(equiVal) || preUp.contains(equiVal)) continue;
                    earliest.add(equiVal);
                    downSafeIt.remove();
                }
            }
        }
    }

    public FlowSet<EquivalentValue> getFlowBefore(Object node) {
        return this.unitToEarliest.get(node);
    }
}

