/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.synchronization;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.G;
import soot.Scene;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.AssignStmt;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.GotoStmt;
import soot.jimple.JimpleBody;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;
import soot.jimple.internal.JNopStmt;
import soot.jimple.toolkits.pointer.FullObjectSet;
import soot.jimple.toolkits.pointer.RWSet;
import soot.jimple.toolkits.pointer.Union;
import soot.jimple.toolkits.pointer.UnionFactory;
import soot.jimple.toolkits.thread.ThreadLocalObjectsAnalysis;
import soot.jimple.toolkits.thread.synchronization.CriticalSection;
import soot.jimple.toolkits.thread.synchronization.CriticalSectionAwareSideEffectAnalysis;
import soot.jimple.toolkits.thread.synchronization.SynchronizedRegionFlowPair;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardFlowAnalysis;
import soot.toolkits.scalar.LocalUses;
import soot.toolkits.scalar.Pair;
import soot.toolkits.scalar.UnitValueBoxPair;
import soot.util.Chain;

public class SynchronizedRegionFinder
extends ForwardFlowAnalysis<Unit, FlowSet<SynchronizedRegionFlowPair>> {
    private static final Logger logger = LoggerFactory.getLogger(SynchronizedRegionFinder.class);
    FlowSet<SynchronizedRegionFlowPair> emptySet = new ArraySparseSet<SynchronizedRegionFlowPair>();
    Map unitToGenerateSet;
    Body body;
    Chain<Unit> units;
    SootMethod method;
    ExceptionalUnitGraph egraph;
    LocalUses slu;
    CriticalSectionAwareSideEffectAnalysis tasea;
    List<Object> prepUnits;
    CriticalSection methodTn;
    public boolean optionPrintDebug = false;
    public boolean optionOpenNesting = true;

    SynchronizedRegionFinder(UnitGraph graph, Body b, boolean optionPrintDebug, boolean optionOpenNesting, ThreadLocalObjectsAnalysis tlo) {
        super(graph);
        this.optionPrintDebug = optionPrintDebug;
        this.optionOpenNesting = optionOpenNesting;
        this.body = b;
        this.units = b.getUnits();
        this.method = this.body.getMethod();
        this.egraph = graph instanceof ExceptionalUnitGraph ? (ExceptionalUnitGraph)graph : new ExceptionalUnitGraph(b);
        this.slu = LocalUses.Factory.newLocalUses(this.egraph);
        if (G.v().Union_factory == null) {
            G.v().Union_factory = new UnionFactory(){

                @Override
                public Union newUnion() {
                    return FullObjectSet.v();
                }
            };
        }
        this.tasea = new CriticalSectionAwareSideEffectAnalysis(Scene.v().getPointsToAnalysis(), Scene.v().getCallGraph(), null, tlo);
        this.prepUnits = new ArrayList<Object>();
        this.methodTn = null;
        if (this.method.isSynchronized()) {
            this.methodTn = new CriticalSection(true, this.method, 1);
            this.methodTn.beginning = ((JimpleBody)this.body).getFirstNonIdentityStmt();
        }
        this.doAnalysis();
        if (this.method.isSynchronized() && this.methodTn != null) {
            for (Stmt stmt : graph.getTails()) {
                this.methodTn.earlyEnds.add(new Pair<Stmt, Object>(stmt, null));
            }
        }
    }

    @Override
    protected FlowSet<SynchronizedRegionFlowPair> newInitialFlow() {
        FlowSet<SynchronizedRegionFlowPair> ret = this.emptySet.clone();
        if (this.method.isSynchronized() && this.methodTn != null) {
            ret.add(new SynchronizedRegionFlowPair(this.methodTn, true));
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void flowThrough(FlowSet<SynchronizedRegionFlowPair> in, Unit unit, FlowSet<SynchronizedRegionFlowPair> out) {
        Stmt stmt = (Stmt)unit;
        this.copy(in, out);
        if (unit instanceof AssignStmt) {
            boolean isPrep = true;
            Iterator<UnitValueBoxPair> uses = this.slu.getUsesOf(unit).iterator();
            if (!uses.hasNext()) {
                isPrep = false;
            }
            while (uses.hasNext()) {
                UnitValueBoxPair use = uses.next();
                Unit useStmt = use.getUnit();
                if (useStmt instanceof EnterMonitorStmt || useStmt instanceof ExitMonitorStmt) continue;
                isPrep = false;
                break;
            }
            if (isPrep) {
                this.prepUnits.add(unit);
                if (this.optionPrintDebug) {
                    logger.debug("prep: " + unit.toString());
                }
                return;
            }
        }
        boolean addSelf = unit instanceof EnterMonitorStmt;
        int nestLevel = 0;
        for (SynchronizedRegionFlowPair srfp : out) {
            if (srfp.tn.nestLevel <= nestLevel || !srfp.inside) continue;
            nestLevel = srfp.tn.nestLevel;
        }
        RWSet stmtRead = null;
        RWSet stmtWrite = null;
        Iterator<SynchronizedRegionFlowPair> outIt = out.iterator();
        boolean printed = false;
        while (outIt.hasNext()) {
            SynchronizedRegionFlowPair srfp = outIt.next();
            CriticalSection tn = srfp.tn;
            if (tn.entermonitor == stmt) {
                srfp.inside = true;
                addSelf = false;
            }
            if (!srfp.inside || tn.nestLevel != nestLevel && this.optionOpenNesting) continue;
            printed = true;
            if (!tn.units.contains(unit)) {
                tn.units.add(unit);
            }
            if (stmt.containsInvokeExpr()) {
                String string = stmt.getInvokeExpr().getMethod().getSubSignature();
                if ((string.equals("void notify()") || string.equals("void notifyAll()")) && tn.nestLevel == nestLevel) {
                    if (!tn.notifys.contains(unit)) {
                        tn.notifys.add(unit);
                    }
                    if (this.optionPrintDebug) {
                        logger.debug("{x,x} ");
                    }
                } else if ((string.equals("void wait()") || string.equals("void wait(long)") || string.equals("void wait(long,int)")) && tn.nestLevel == nestLevel) {
                    if (!tn.waits.contains(unit)) {
                        tn.waits.add(unit);
                    }
                    if (this.optionPrintDebug) {
                        logger.debug("{x,x} ");
                    }
                }
                if (tn.invokes.contains(unit)) continue;
                tn.invokes.add(unit);
                if (!this.optionPrintDebug) continue;
                stmtRead = this.tasea.readSet(tn.method, stmt, tn, new HashSet());
                stmtWrite = this.tasea.writeSet(tn.method, stmt, tn, new HashSet());
                logger.debug("{");
                if (stmtRead != null) {
                    logger.debug("" + ((stmtRead.getGlobals() != null ? stmtRead.getGlobals().size() : 0) + (stmtRead.getFields() != null ? stmtRead.getFields().size() : 0)));
                } else {
                    logger.debug("0");
                }
                logger.debug(",");
                if (stmtWrite != null) {
                    logger.debug("" + ((stmtWrite.getGlobals() != null ? stmtWrite.getGlobals().size() : 0) + (stmtWrite.getFields() != null ? stmtWrite.getFields().size() : 0)));
                } else {
                    logger.debug("0");
                }
                logger.debug("} ");
                continue;
            }
            if (unit instanceof ExitMonitorStmt && tn.nestLevel == nestLevel) {
                void var14_18;
                Stmt stmt2;
                srfp.inside = false;
                Stmt stmt3 = stmt;
                while ((stmt2 = (Stmt)this.units.getSuccOf((Unit)var14_18)) instanceof JNopStmt) {
                }
                if (stmt2 instanceof ReturnStmt || stmt2 instanceof ReturnVoidStmt || stmt2 instanceof ExitMonitorStmt) {
                    tn.earlyEnds.add(new Pair<Stmt, Stmt>(stmt2, stmt));
                } else if (stmt2 instanceof GotoStmt) {
                    tn.end = new Pair<Stmt, Stmt>(stmt2, stmt);
                    tn.after = (Stmt)((GotoStmt)stmt2).getTarget();
                } else if (stmt2 instanceof ThrowStmt) {
                    tn.exceptionalEnd = new Pair<Stmt, Stmt>(stmt2, stmt);
                } else {
                    throw new RuntimeException("Unknown bytecode pattern: exitmonitor not followed by return, exitmonitor, goto, or throw");
                }
                if (!this.optionPrintDebug) continue;
                logger.debug("[0,0] ");
                continue;
            }
            HashSet hashSet = new HashSet();
            stmtRead = this.tasea.readSet(this.method, stmt, tn, hashSet);
            stmtWrite = this.tasea.writeSet(this.method, stmt, tn, hashSet);
            tn.read.union(stmtRead);
            tn.write.union(stmtWrite);
            if (!this.optionPrintDebug) continue;
            logger.debug("[");
            if (stmtRead != null) {
                logger.debug("" + ((stmtRead.getGlobals() != null ? stmtRead.getGlobals().size() : 0) + (stmtRead.getFields() != null ? stmtRead.getFields().size() : 0)));
            } else {
                logger.debug("0");
            }
            logger.debug(",");
            if (stmtWrite != null) {
                logger.debug("" + ((stmtWrite.getGlobals() != null ? stmtWrite.getGlobals().size() : 0) + (stmtWrite.getFields() != null ? stmtWrite.getFields().size() : 0)));
            } else {
                logger.debug("0");
            }
            logger.debug("] ");
        }
        if (this.optionPrintDebug) {
            if (!printed) {
                logger.debug("[0,0] ");
            }
            logger.debug("" + unit.toString());
            if (stmt.containsInvokeExpr() && stmt.getInvokeExpr().getMethod().getDeclaringClass().toString().startsWith("java.") && stmtRead != null && stmtWrite != null && stmtRead.size() < 25 && stmtWrite.size() < 25) {
                logger.debug("        Read/Write Set for LibInvoke:");
                logger.debug("Read Set:(" + stmtRead.size() + ")" + stmtRead.toString().replaceAll("\n", "\n        "));
                logger.debug("Write Set:(" + stmtWrite.size() + ")" + stmtWrite.toString().replaceAll("\n", "\n        "));
            }
        }
        if (addSelf) {
            CriticalSection newTn = new CriticalSection(false, this.method, nestLevel + 1);
            newTn.entermonitor = stmt;
            newTn.beginning = (Stmt)this.units.getSuccOf(stmt);
            if (stmt instanceof EnterMonitorStmt) {
                newTn.origLock = ((EnterMonitorStmt)stmt).getOp();
            }
            if (this.optionPrintDebug) {
                logger.debug("Transaction found in method: " + newTn.method.toString());
            }
            out.add(new SynchronizedRegionFlowPair(newTn, true));
            for (Unit unit2 : this.prepUnits) {
                for (UnitValueBoxPair use : this.slu.getUsesOf(unit2)) {
                    if (use.getUnit() != unit) continue;
                    newTn.prepStmt = (Stmt)unit2;
                }
            }
        }
    }

    @Override
    protected void merge(FlowSet<SynchronizedRegionFlowPair> inSet1, FlowSet<SynchronizedRegionFlowPair> inSet2, FlowSet<SynchronizedRegionFlowPair> outSet) {
        inSet1.union(inSet2, outSet);
    }

    @Override
    protected void copy(FlowSet<SynchronizedRegionFlowPair> sourceSet, FlowSet<SynchronizedRegionFlowPair> destSet) {
        destSet.clear();
        for (SynchronizedRegionFlowPair tfp : sourceSet) {
            destSet.add(tfp.clone());
        }
    }
}

