/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing.fast;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.Type;
import soot.jimple.toolkits.typing.fast.IHierarchy;
import soot.jimple.toolkits.typing.fast.ITypingStrategy;
import soot.jimple.toolkits.typing.fast.TypeResolver;
import soot.jimple.toolkits.typing.fast.Typing;
import soot.util.Chain;
import soot.util.HashMultiMap;
import soot.util.MultiMap;

public class DefaultTypingStrategy
implements ITypingStrategy {
    public static final ITypingStrategy INSTANCE = new DefaultTypingStrategy();

    @Override
    public Typing createTyping(Chain<Local> locals) {
        return new Typing(locals);
    }

    @Override
    public Typing createTyping(Typing tg) {
        return new Typing(tg);
    }

    public static MultiMap<Local, Type> getFlatTyping(List<Typing> tgs) {
        HashMultiMap<Local, Type> map = new HashMultiMap<Local, Type>();
        for (Typing tg : tgs) {
            map.putMap(tg.map);
        }
        return map;
    }

    public static Set<Local> getObjectLikeTypings(List<Typing> tgs) {
        RefType objectType = Scene.v().getObjectType();
        HashSet<RefType> objectLikeTypeSet = new HashSet<RefType>();
        objectLikeTypeSet.add(objectType);
        objectLikeTypeSet.add(RefType.v("java.io.Serializable"));
        objectLikeTypeSet.add(RefType.v("java.lang.Cloneable"));
        HashSet<Local> objectLikeVars = new HashSet<Local>();
        MultiMap<Local, Type> ft = DefaultTypingStrategy.getFlatTyping(tgs);
        for (Local l : ft.keySet()) {
            Set<Type> ts = ft.get(l);
            if (!ts.equals(objectLikeTypeSet)) continue;
            objectLikeVars.add(l);
        }
        return objectLikeVars;
    }

    @Override
    public void minimize(List<Typing> tgs, IHierarchy h) {
        Set<Local> objectVars = DefaultTypingStrategy.getObjectLikeTypings(tgs);
        ListIterator<Typing> i = tgs.listIterator();
        block0: while (i.hasNext()) {
            Typing tgi = i.next();
            for (Typing tgj : tgs) {
                if (tgi == tgj || this.compare(tgi, tgj, h, objectVars) != 1) continue;
                i.remove();
                continue block0;
            }
        }
    }

    public int compare(Typing a, Typing b, IHierarchy h, Collection<Local> localsToIgnore) {
        int r = 0;
        for (Local v : a.map.keySet()) {
            int cmp;
            Type tb;
            if (localsToIgnore.contains(v)) continue;
            Type ta = a.get(v);
            if (TypeResolver.typesEqual(ta, tb = b.get(v))) {
                cmp = 0;
            } else if (h.ancestor(ta, tb)) {
                cmp = 1;
            } else if (h.ancestor(tb, ta)) {
                cmp = -1;
            } else {
                return -2;
            }
            if (cmp == 1 && r == -1 || cmp == -1 && r == 1) {
                return 2;
            }
            if (r != 0) continue;
            r = cmp;
        }
        return r;
    }
}

