/*
 * Decompiled with CFR 0.152.
 */
package soot.rtlib.tamiflex;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SootSig {
    private static final Logger logger = LoggerFactory.getLogger(SootSig.class);
    private static Map<Constructor<?>, String> constrCache = new ConcurrentHashMap();
    private static Map<Method, String> methodCache = new ConcurrentHashMap<Method, String>();

    public static String sootSignature(Constructor<?> c) {
        String res = constrCache.get(c);
        if (res == null) {
            String[] paramTypes = SootSig.classesToTypeNames(c.getParameterTypes());
            res = SootSig.sootSignature(c.getDeclaringClass().getName(), "void", "<init>", paramTypes);
            constrCache.put(c, res);
        }
        return res;
    }

    public static String sootSignature(Object receiver, Method m) {
        Class<?> receiverClass = Modifier.isStatic(m.getModifiers()) ? m.getDeclaringClass() : receiver.getClass();
        try {
            String res;
            Method resolved = null;
            Class<?> c = receiverClass;
            do {
                try {
                    resolved = c.getDeclaredMethod(m.getName(), m.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    c = c.getSuperclass();
                }
            } while (resolved == null && c != null);
            if (resolved == null) {
                Error error = new Error("Method not found : " + m + " in class " + receiverClass + " and super classes.");
                logger.error(error.getMessage(), (Throwable)error);
            }
            if ((res = methodCache.get(resolved)) == null) {
                String[] paramTypes = SootSig.classesToTypeNames(resolved.getParameterTypes());
                res = SootSig.sootSignature(resolved.getDeclaringClass().getName(), SootSig.getTypeName(resolved.getReturnType()), resolved.getName(), paramTypes);
                methodCache.put(resolved, res);
            }
            return res;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String[] classesToTypeNames(Class<?>[] params) {
        String[] paramTypes = new String[params.length];
        int i = 0;
        for (Class<?> type : params) {
            paramTypes[i] = SootSig.getTypeName(type);
            ++i;
        }
        return paramTypes;
    }

    private static String getTypeName(Class<?> type) {
        if (type.isArray()) {
            try {
                Class<?> cl = type;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuffer sb = new StringBuffer();
                sb.append(cl.getName());
                for (int i = 0; i < dimensions; ++i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return type.getName();
    }

    private static String sootSignature(String declaringClass, String returnType, String name, String ... paramTypes) {
        StringBuilder b = new StringBuilder();
        b.append("<");
        b.append(declaringClass);
        b.append(": ");
        b.append(returnType);
        b.append(" ");
        b.append(name);
        b.append("(");
        int i = 0;
        for (String type : paramTypes) {
            b.append(type);
            if (++i >= paramTypes.length) continue;
            b.append(",");
        }
        b.append(")>");
        return b.toString();
    }

    public static String sootSignature(Field f) {
        StringBuilder b = new StringBuilder();
        b.append("<");
        b.append(SootSig.getTypeName(f.getDeclaringClass()));
        b.append(": ");
        b.append(SootSig.getTypeName(f.getType()));
        b.append(" ");
        b.append(f.getName());
        b.append(">");
        return b.toString();
    }
}

