/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Local;
import soot.Type;
import soot.Unit;
import soot.UnitBox;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.shimple.PhiExpr;
import soot.shimple.ShimpleExprSwitch;
import soot.shimple.internal.SValueUnitPair;
import soot.toolkits.graph.Block;
import soot.toolkits.scalar.ValueUnitPair;
import soot.util.Switch;

public class SPhiExpr
implements PhiExpr {
    private static final Logger logger = LoggerFactory.getLogger(SPhiExpr.class);
    protected List<ValueUnitPair> argPairs = new ArrayList<ValueUnitPair>();
    protected Map<Unit, ValueUnitPair> predToPair = new HashMap<Unit, ValueUnitPair>();
    protected Type type;
    int blockId = -1;

    public SPhiExpr(Local leftLocal, List<Block> preds) {
        this.type = leftLocal.getType();
        for (Block pred : preds) {
            this.addArg((Value)leftLocal, pred);
        }
    }

    public SPhiExpr(List<Value> args, List<Unit> preds) {
        if (args.size() == 0) {
            throw new RuntimeException("Arg list may not be empty");
        }
        if (args.size() != preds.size()) {
            throw new RuntimeException("Arg list does not match Pred list");
        }
        this.type = args.get(0).getType();
        Iterator<Value> argsIt = args.iterator();
        Iterator<Unit> predsIt = preds.iterator();
        while (argsIt.hasNext()) {
            Value arg = argsIt.next();
            Unit pred = predsIt.next();
            if (pred instanceof Block) {
                this.addArg(arg, (Block)((Object)pred));
                continue;
            }
            if (pred instanceof Unit) {
                this.addArg(arg, pred);
                continue;
            }
            throw new RuntimeException("Must be a CFG block or tail unit.");
        }
    }

    @Override
    public List<ValueUnitPair> getArgs() {
        return Collections.unmodifiableList(this.argPairs);
    }

    @Override
    public List<Value> getValues() {
        ArrayList<Value> args = new ArrayList<Value>();
        for (ValueUnitPair vup : this.argPairs) {
            Value arg = vup.getValue();
            args.add(arg);
        }
        return args;
    }

    @Override
    public List<Unit> getPreds() {
        ArrayList<Unit> preds = new ArrayList<Unit>();
        for (ValueUnitPair up : this.argPairs) {
            Unit arg = up.getUnit();
            preds.add(arg);
        }
        return preds;
    }

    @Override
    public int getArgCount() {
        return this.argPairs.size();
    }

    @Override
    public ValueUnitPair getArgBox(int index) {
        if (index < 0 || index >= this.argPairs.size()) {
            return null;
        }
        return this.argPairs.get(index);
    }

    @Override
    public Value getValue(int index) {
        ValueUnitPair arg = this.getArgBox(index);
        if (arg == null) {
            return null;
        }
        return arg.getValue();
    }

    @Override
    public Unit getPred(int index) {
        ValueUnitPair arg = this.getArgBox(index);
        if (arg == null) {
            return null;
        }
        return arg.getUnit();
    }

    @Override
    public int getArgIndex(Unit predTailUnit) {
        ValueUnitPair pair = this.getArgBox(predTailUnit);
        return this.argPairs.indexOf(pair);
    }

    @Override
    public ValueUnitPair getArgBox(Unit predTailUnit) {
        ValueUnitPair vup = this.predToPair.get(predTailUnit);
        if (vup == null || vup.getUnit() != predTailUnit) {
            this.updateCache();
            vup = this.predToPair.get(predTailUnit);
            if (vup != null && vup.getUnit() != predTailUnit) {
                throw new RuntimeException("Assertion failed.");
            }
        }
        return vup;
    }

    @Override
    public Value getValue(Unit predTailUnit) {
        ValueUnitPair vb = this.getArgBox(predTailUnit);
        if (vb == null) {
            return null;
        }
        return vb.getValue();
    }

    @Override
    public int getArgIndex(Block pred) {
        ValueUnitPair box = this.getArgBox(pred);
        return this.argPairs.indexOf(box);
    }

    @Override
    public ValueUnitPair getArgBox(Block pred) {
        Unit predTailUnit = pred.getTail();
        ValueUnitPair box = this.getArgBox(predTailUnit);
        while (box == null && (predTailUnit = pred.getPredOf(predTailUnit)) != null) {
            box = this.getArgBox(predTailUnit);
        }
        return box;
    }

    @Override
    public Value getValue(Block pred) {
        ValueUnitPair vb = this.getArgBox(pred);
        if (vb == null) {
            return null;
        }
        return vb.getValue();
    }

    @Override
    public boolean setArg(int index, Value arg, Unit predTailUnit) {
        boolean ret2;
        boolean ret1 = this.setValue(index, arg);
        if (ret1 != (ret2 = this.setPred(index, predTailUnit))) {
            throw new RuntimeException("Assertion failed.");
        }
        return ret1;
    }

    @Override
    public boolean setArg(int index, Value arg, Block pred) {
        return this.setArg(index, arg, pred.getTail());
    }

    @Override
    public boolean setValue(int index, Value arg) {
        ValueUnitPair argPair = this.getArgBox(index);
        if (argPair == null) {
            return false;
        }
        argPair.setValue(arg);
        return true;
    }

    @Override
    public boolean setValue(Unit predTailUnit, Value arg) {
        int index = this.getArgIndex(predTailUnit);
        return this.setValue(index, arg);
    }

    @Override
    public boolean setValue(Block pred, Value arg) {
        int index = this.getArgIndex(pred);
        return this.setValue(index, arg);
    }

    @Override
    public boolean setPred(int index, Unit predTailUnit) {
        ValueUnitPair argPair = this.getArgBox(index);
        if (argPair == null) {
            return false;
        }
        int other = this.getArgIndex(predTailUnit);
        if (other != -1) {
            logger.warn("An argument with control flow predecessor " + predTailUnit + " already exists in " + this + "!");
            logger.warn("setPred resulted in deletion of " + argPair + " from " + this + ".");
            this.removeArg(argPair);
            return false;
        }
        argPair.setUnit(predTailUnit);
        return true;
    }

    @Override
    public boolean setPred(int index, Block pred) {
        return this.setPred(index, pred.getTail());
    }

    @Override
    public boolean removeArg(int index) {
        ValueUnitPair arg = this.getArgBox(index);
        return this.removeArg(arg);
    }

    @Override
    public boolean removeArg(Unit predTailUnit) {
        ValueUnitPair arg = this.getArgBox(predTailUnit);
        return this.removeArg(arg);
    }

    @Override
    public boolean removeArg(Block pred) {
        ValueUnitPair arg = this.getArgBox(pred);
        return this.removeArg(arg);
    }

    @Override
    public boolean removeArg(ValueUnitPair arg) {
        if (this.argPairs.remove(arg)) {
            this.predToPair.remove(arg.getUnit());
            arg.getUnit().removeBoxPointingToThis(arg);
            return true;
        }
        return false;
    }

    @Override
    public boolean addArg(Value arg, Block pred) {
        return this.addArg(arg, pred.getTail());
    }

    @Override
    public boolean addArg(Value arg, Unit predTailUnit) {
        if (predTailUnit == null) {
            return false;
        }
        if (this.predToPair.keySet().contains(predTailUnit)) {
            return false;
        }
        SValueUnitPair vup = new SValueUnitPair(arg, predTailUnit);
        this.argPairs.add(vup);
        this.predToPair.put(predTailUnit, vup);
        return true;
    }

    @Override
    public void setBlockId(int blockId) {
        this.blockId = blockId;
    }

    @Override
    public int getBlockId() {
        if (this.blockId == -1) {
            throw new RuntimeException("Assertion failed:  Block Id unknown.");
        }
        return this.blockId;
    }

    protected void updateCache() {
        int needed = this.argPairs.size();
        this.predToPair = new HashMap<Unit, ValueUnitPair>(needed << 1, 1.0f);
        for (ValueUnitPair vup : this.argPairs) {
            this.predToPair.put(vup.getUnit(), vup);
        }
    }

    @Override
    public boolean equivTo(Object o) {
        if (o instanceof SPhiExpr) {
            SPhiExpr pe = (SPhiExpr)o;
            if (this.getArgCount() != pe.getArgCount()) {
                return false;
            }
            for (int i = 0; i < this.getArgCount(); ++i) {
                if (this.getArgBox(i).equivTo(pe.getArgBox(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int equivHashCode() {
        int hashcode = 1;
        for (int i = 0; i < this.getArgCount(); ++i) {
            hashcode = hashcode * 17 + this.getArgBox(i).equivHashCode();
        }
        return hashcode;
    }

    @Override
    public List<UnitBox> getUnitBoxes() {
        HashSet<ValueUnitPair> boxes = new HashSet<ValueUnitPair>(this.argPairs.size());
        for (ValueUnitPair up : this.argPairs) {
            boxes.add(up);
        }
        return new ArrayList<UnitBox>(boxes);
    }

    @Override
    public void clearUnitBoxes() {
        for (UnitBox box : this.getUnitBoxes()) {
            box.setUnit(null);
        }
    }

    @Override
    public List<ValueBox> getUseBoxes() {
        HashSet<ValueBox> set = new HashSet<ValueBox>();
        for (ValueUnitPair argPair : this.argPairs) {
            set.addAll(argPair.getValue().getUseBoxes());
            set.add(argPair);
        }
        return new ArrayList<ValueBox>(set);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public String toString() {
        StringBuffer expr = new StringBuffer("Phi(");
        boolean isFirst = true;
        for (ValueUnitPair vuPair : this.argPairs) {
            if (!isFirst) {
                expr.append(", ");
            }
            Value arg = vuPair.getValue();
            expr.append(arg.toString());
            isFirst = false;
        }
        expr.append(")");
        return expr.toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("Phi");
        up.literal("(");
        boolean isFirst = true;
        for (ValueUnitPair vuPair : this.argPairs) {
            if (!isFirst) {
                up.literal(", ");
            }
            vuPair.toString(up);
            isFirst = false;
        }
        up.literal(")");
    }

    @Override
    public void apply(Switch sw) {
        ((ShimpleExprSwitch)sw).casePhiExpr(this);
    }

    @Override
    public Object clone() {
        return new SPhiExpr(this.getValues(), this.getPreds());
    }
}

