/*
 * Decompiled with CFR 0.152.
 */
package soot.toDex;

import java.util.Iterator;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Singletons;
import soot.Unit;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.Jimple;
import soot.toolkits.graph.ExceptionalUnitGraph;

public class SynchronizedMethodTransformer
extends BodyTransformer {
    public SynchronizedMethodTransformer(Singletons.Global g) {
    }

    public static SynchronizedMethodTransformer v() {
        return G.v().soot_toDex_SynchronizedMethodTransformer();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        if (!b.getMethod().isSynchronized() || b.getMethod().isStatic()) {
            return;
        }
        Iterator it = b.getUnits().snapshotIterator();
        while (it.hasNext()) {
            Unit u = (Unit)it.next();
            if (u instanceof IdentityStmt) continue;
            if (u instanceof EnterMonitorStmt) break;
            b.getUnits().insertBeforeNoRedirect(Jimple.v().newEnterMonitorStmt(b.getThisLocal()), u);
            ExceptionalUnitGraph graph = new ExceptionalUnitGraph(b);
            for (Unit tail : graph.getTails()) {
                b.getUnits().insertBefore(Jimple.v().newExitMonitorStmt(b.getThisLocal()), tail);
            }
        }
    }
}

