/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.DominatorNode;
import soot.toolkits.graph.DominatorTree;

public class DominatorTreeAdapter<N>
implements DirectedGraph<DominatorNode<N>> {
    DominatorTree<N> dt;

    public DominatorTreeAdapter(DominatorTree<N> dt) {
        this.dt = dt;
    }

    @Override
    public List<DominatorNode<N>> getHeads() {
        return this.dt.getHeads();
    }

    @Override
    public List<DominatorNode<N>> getTails() {
        return this.dt.getTails();
    }

    @Override
    public List<DominatorNode<N>> getPredsOf(DominatorNode<N> node) {
        return Collections.singletonList(this.dt.getParentOf(node));
    }

    @Override
    public List<DominatorNode<N>> getSuccsOf(DominatorNode<N> node) {
        return this.dt.getChildrenOf(node);
    }

    @Override
    public Iterator<DominatorNode<N>> iterator() {
        return this.dt.iterator();
    }

    @Override
    public int size() {
        return this.dt.size();
    }
}

