/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.Unit;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.scalar.AbstractFlowAnalysis;

public abstract class BranchedFlowAnalysis<N extends Unit, A>
extends AbstractFlowAnalysis<N, A> {
    protected Map<Unit, List<A>> unitToAfterFallFlow;
    protected Map<Unit, List<A>> unitToAfterBranchFlow;

    public BranchedFlowAnalysis(DirectedGraph<N> graph) {
        super(graph);
        this.unitToAfterFallFlow = new HashMap<Unit, List<A>>(graph.size() * 2 + 1, 0.7f);
        this.unitToAfterBranchFlow = new HashMap<Unit, List<A>>(graph.size() * 2 + 1, 0.7f);
    }

    protected abstract void flowThrough(A var1, Unit var2, List<A> var3, List<A> var4);

    public A getFallFlowAfter(Unit s) {
        List<A> fl = this.unitToAfterFallFlow.get(s);
        if (fl.isEmpty()) {
            return this.newInitialFlow();
        }
        return fl.get(0);
    }

    public List<A> getBranchFlowAfter(Unit s) {
        return this.unitToAfterBranchFlow.get(s);
    }
}

