/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ConflictingFieldRefException;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.AssignStmt;
import soot.jimple.Constant;
import soot.jimple.DoubleConstant;
import soot.jimple.FieldRef;
import soot.jimple.FloatConstant;
import soot.jimple.IntConstant;
import soot.jimple.LongConstant;
import soot.jimple.StaticFieldRef;
import soot.jimple.StringConstant;
import soot.tagkit.ConstantValueTag;
import soot.tagkit.DoubleConstantValueTag;
import soot.tagkit.FloatConstantValueTag;
import soot.tagkit.IntegerConstantValueTag;
import soot.tagkit.LongConstantValueTag;
import soot.tagkit.StringConstantValueTag;
import soot.tagkit.Tag;

public class ConstantInitializerToTagTransformer
extends SceneTransformer {
    private static final Logger logger = LoggerFactory.getLogger(ConstantInitializerToTagTransformer.class);
    private static final ConstantInitializerToTagTransformer INSTANCE = new ConstantInitializerToTagTransformer();

    public static ConstantInitializerToTagTransformer v() {
        return INSTANCE;
    }

    @Override
    protected void internalTransform(String phaseName, Map<String, String> options) {
        for (SootClass sc : Scene.v().getClasses()) {
            this.transformClass(sc, false);
        }
    }

    public void transformClass(SootClass sc, boolean removeAssignments) {
        AssignStmt assign;
        SootMethod smInit = sc.getMethodByNameUnsafe("<clinit>");
        if (smInit == null || !smInit.isConcrete()) {
            return;
        }
        HashSet<SootField> nonConstantFields = new HashSet<SootField>();
        HashMap<SootField, ConstantValueTag> newTags = new HashMap<SootField, ConstantValueTag>();
        HashSet<SootField> removeTagList = new HashSet<SootField>();
        Iterator<Object> itU = smInit.getActiveBody().getUnits().snapshotIterator();
        while (itU.hasNext()) {
            Unit unit = (Unit)itU.next();
            if (!(unit instanceof AssignStmt)) continue;
            assign = (AssignStmt)unit;
            if (assign.getLeftOp() instanceof StaticFieldRef && assign.getRightOp() instanceof Constant) {
                SootField field = null;
                try {
                    field = ((StaticFieldRef)assign.getLeftOp()).getField();
                    if (field == null) continue;
                    if (nonConstantFields.contains(field)) {
                    }
                }
                catch (ConflictingFieldRefException ex) {}
                continue;
                if (!field.getDeclaringClass().equals(sc) || !field.isStatic() || !field.isFinal()) continue;
                boolean found = false;
                for (Tag t : field.getTags()) {
                    if (!(t instanceof ConstantValueTag)) continue;
                    if (this.checkConstantValue((ConstantValueTag)t, (Constant)assign.getRightOp())) {
                        if (removeAssignments) {
                            itU.remove();
                        }
                    } else {
                        logger.debug("WARNING: Constant value for field '" + field + "' mismatch between code (" + assign.getRightOp() + ") and constant table (" + t + ")");
                        removeTagList.add(field);
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                if (!this.checkConstantValue((ConstantValueTag)newTags.get(field), (Constant)assign.getRightOp())) {
                    nonConstantFields.add(field);
                    newTags.remove(field);
                    removeTagList.add(field);
                    continue;
                }
                ConstantValueTag newTag = this.createConstantTagFromValue((Constant)assign.getRightOp());
                if (newTag == null) continue;
                newTags.put(field, newTag);
                continue;
            }
            if (!(assign.getLeftOp() instanceof StaticFieldRef)) continue;
            try {
                SootField sf = ((StaticFieldRef)assign.getLeftOp()).getField();
                if (sf == null) continue;
                removeTagList.add(sf);
            }
            catch (ConflictingFieldRefException sf) {}
        }
        for (Map.Entry entry : newTags.entrySet()) {
            SootField field = (SootField)entry.getKey();
            if (removeTagList.contains(field)) continue;
            field.addTag((Tag)entry.getValue());
        }
        if (removeAssignments && !newTags.isEmpty()) {
            itU = smInit.getActiveBody().getUnits().snapshotIterator();
            while (itU.hasNext()) {
                Unit unit = (Unit)itU.next();
                if (!(unit instanceof AssignStmt) || !((assign = (AssignStmt)unit).getLeftOp() instanceof FieldRef)) continue;
                try {
                    SootField fld = ((FieldRef)assign.getLeftOp()).getField();
                    if (fld == null || !newTags.containsKey(fld)) continue;
                    itU.remove();
                }
                catch (ConflictingFieldRefException conflictingFieldRefException) {}
            }
        }
        for (SootField sootField : removeTagList) {
            if (!removeTagList.contains(sootField)) continue;
            ArrayList<Tag> toRemoveTagList = new ArrayList<Tag>();
            for (Tag t : sootField.getTags()) {
                if (!(t instanceof ConstantValueTag)) continue;
                toRemoveTagList.add(t);
            }
            for (Tag t : toRemoveTagList) {
                sootField.getTags().remove(t);
            }
        }
    }

    private ConstantValueTag createConstantTagFromValue(Constant rightOp) {
        if (rightOp instanceof DoubleConstant) {
            return new DoubleConstantValueTag(((DoubleConstant)rightOp).value);
        }
        if (rightOp instanceof FloatConstant) {
            return new FloatConstantValueTag(((FloatConstant)rightOp).value);
        }
        if (rightOp instanceof IntConstant) {
            return new IntegerConstantValueTag(((IntConstant)rightOp).value);
        }
        if (rightOp instanceof LongConstant) {
            return new LongConstantValueTag(((LongConstant)rightOp).value);
        }
        if (rightOp instanceof StringConstant) {
            return new StringConstantValueTag(((StringConstant)rightOp).value);
        }
        return null;
    }

    private boolean checkConstantValue(ConstantValueTag t, Constant rightOp) {
        if (t == null || rightOp == null) {
            return true;
        }
        if (t instanceof DoubleConstantValueTag) {
            if (!(rightOp instanceof DoubleConstant)) {
                return false;
            }
            return ((DoubleConstantValueTag)t).getDoubleValue() == ((DoubleConstant)rightOp).value;
        }
        if (t instanceof FloatConstantValueTag) {
            if (!(rightOp instanceof FloatConstant)) {
                return false;
            }
            return ((FloatConstantValueTag)t).getFloatValue() == ((FloatConstant)rightOp).value;
        }
        if (t instanceof IntegerConstantValueTag) {
            if (!(rightOp instanceof IntConstant)) {
                return false;
            }
            return ((IntegerConstantValueTag)t).getIntValue() == ((IntConstant)rightOp).value;
        }
        if (t instanceof LongConstantValueTag) {
            if (!(rightOp instanceof LongConstant)) {
                return false;
            }
            return ((LongConstantValueTag)t).getLongValue() == ((LongConstant)rightOp).value;
        }
        if (t instanceof StringConstantValueTag) {
            if (!(rightOp instanceof StringConstant)) {
                return false;
            }
            return ((StringConstantValueTag)t).getStringValue().equals(((StringConstant)rightOp).value);
        }
        return true;
    }
}

