/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import beaver.Symbol;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.BooleanLiteral;
import soot.JastAddJ.Constant;
import soot.JastAddJ.DoubleLiteral;
import soot.JastAddJ.FloatingPointLiteral;
import soot.JastAddJ.IntegerLiteral;
import soot.JastAddJ.LongLiteral;
import soot.JastAddJ.PrimaryExpr;
import soot.JastAddJ.StringLiteral;

public abstract class Literal
extends PrimaryExpr
implements Cloneable {
    protected String tokenString_LITERAL;
    public int LITERALstart;
    public int LITERALend;
    protected boolean constant_computed = false;
    protected Constant constant_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.constant_computed = false;
        this.constant_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public Literal clone() throws CloneNotSupportedException {
        Literal node = (Literal)super.clone();
        node.constant_computed = false;
        node.constant_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public static Literal buildBooleanLiteral(boolean value) {
        return new BooleanLiteral(value ? "true" : "false");
    }

    public static Literal buildStringLiteral(String value) {
        return new StringLiteral(value);
    }

    @Override
    public void toString(StringBuffer s) {
        s.append(this.getLITERAL());
    }

    protected static String escape(String s) {
        StringBuffer result = new StringBuffer();
        block10: for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case '\b': {
                    result.append("\\b");
                    continue block10;
                }
                case '\t': {
                    result.append("\\t");
                    continue block10;
                }
                case '\n': {
                    result.append("\\n");
                    continue block10;
                }
                case '\f': {
                    result.append("\\f");
                    continue block10;
                }
                case '\r': {
                    result.append("\\r");
                    continue block10;
                }
                case '\"': {
                    result.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    result.append("\\'");
                    continue block10;
                }
                case '\\': {
                    result.append("\\\\");
                    continue block10;
                }
                default: {
                    char value = s.charAt(i);
                    if (value < ' ' || value > '~') {
                        result.append(Literal.asEscape(value));
                        continue block10;
                    }
                    result.append(s.charAt(i));
                }
            }
        }
        return result.toString();
    }

    protected static String asEscape(int value) {
        StringBuffer s = new StringBuffer("\\u");
        String hex = Integer.toHexString(value);
        for (int i = 0; i < 4 - hex.length(); ++i) {
            s.append("0");
        }
        s.append(hex);
        return s.toString();
    }

    public Literal() {
    }

    @Override
    public void init$Children() {
    }

    public Literal(String p0) {
        this.setLITERAL(p0);
    }

    public Literal(Symbol p0) {
        this.setLITERAL(p0);
    }

    @Override
    protected int numChildren() {
        return 0;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setLITERAL(String value) {
        this.tokenString_LITERAL = value;
    }

    public void setLITERAL(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setLITERAL is only valid for String lexemes");
        }
        this.tokenString_LITERAL = (String)symbol.value;
        this.LITERALstart = symbol.getStart();
        this.LITERALend = symbol.getEnd();
    }

    public String getLITERAL() {
        return this.tokenString_LITERAL != null ? this.tokenString_LITERAL : "";
    }

    public static Literal buildDoubleLiteral(double value) {
        String digits = Double.toString(value);
        DoubleLiteral lit = new DoubleLiteral(digits);
        lit.setDigits(digits);
        lit.setKind(0);
        return lit;
    }

    public static Literal buildFloatLiteral(float value) {
        String digits = Float.toString(value);
        FloatingPointLiteral lit = new FloatingPointLiteral(digits);
        lit.setDigits(digits);
        lit.setKind(0);
        return lit;
    }

    public static Literal buildIntegerLiteral(int value) {
        String digits = Integer.toHexString(value);
        IntegerLiteral lit = new IntegerLiteral("0x" + digits);
        lit.setDigits(digits.toLowerCase());
        lit.setKind(1);
        return lit;
    }

    public static Literal buildLongLiteral(long value) {
        String digits = Long.toHexString(value);
        LongLiteral lit = new LongLiteral("0x" + digits);
        lit.setDigits(digits.toLowerCase());
        lit.setKind(1);
        return lit;
    }

    @Override
    public Constant constant() {
        if (this.constant_computed) {
            return this.constant_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.constant_value = this.constant_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.constant_computed = true;
        }
        return this.constant_value;
    }

    private Constant constant_compute() {
        throw new UnsupportedOperationException("ConstantExpression operation constant not supported for type " + this.getClass().getName());
    }

    @Override
    public boolean isConstant() {
        ASTNode$State state = this.state();
        return true;
    }

    @Override
    public String dumpString() {
        ASTNode$State state = this.state();
        return this.getClass().getName() + " [" + this.getLITERAL() + "]";
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

