/*
 * Decompiled with CFR 0.152.
 */
package soot;

import com.google.common.base.Optional;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Scene;
import soot.SootClass;
import soot.SootModuleResolver;
import soot.dava.toolkits.base.misc.PackageNamer;

public class SootModuleInfo
extends SootClass {
    public static final String MODULE_INFO_FILE = "module-info.class";
    public static final String MODULE_INFO = "module-info";
    private static final String ALL_MODULES = "EVERYONE_MODULE";
    private final HashSet<String> modulePackages = new HashSet();
    private final Map<SootModuleInfo, Integer> requiredModules = new HashMap<SootModuleInfo, Integer>();
    private final Map<String, List<String>> exportedPackages = new HashMap<String, List<String>>();
    private final Map<String, List<String>> openedPackages = new HashMap<String, List<String>>();
    private boolean isAutomaticModule;

    public SootModuleInfo(String name, int modifiers, String moduleName) {
        super(name, modifiers, moduleName);
    }

    public SootModuleInfo(String name, String moduleName) {
        this(name, moduleName, false);
    }

    public SootModuleInfo(String name, String moduleName, boolean isAutomatic) {
        super(name, moduleName);
        this.isAutomaticModule = isAutomatic;
    }

    public boolean isAutomaticModule() {
        return this.isAutomaticModule;
    }

    public void setAutomaticModule(boolean automaticModule) {
        this.isAutomaticModule = automaticModule;
    }

    private Map<String, List<String>> getExportedPackages() {
        return this.exportedPackages;
    }

    private Map<String, List<String>> getOpenedPackages() {
        return this.openedPackages;
    }

    public Set<String> getPublicExportedPackages() {
        HashSet<String> publicExportedPackages = new HashSet<String>();
        for (String packaze : this.modulePackages) {
            if (!this.exportsPackage(packaze, ALL_MODULES)) continue;
            publicExportedPackages.add(packaze);
        }
        return publicExportedPackages;
    }

    public Set<String> getPublicOpenedPackages() {
        HashSet<String> publicOpenedPackages = new HashSet<String>();
        for (String packaze : this.modulePackages) {
            if (!this.opensPackage(packaze, ALL_MODULES)) continue;
            publicOpenedPackages.add(packaze);
        }
        return publicOpenedPackages;
    }

    public Map<SootModuleInfo, Integer> getRequiredModules() {
        return this.requiredModules;
    }

    public Map<SootModuleInfo, Integer> retrieveRequiredModules() {
        Map<SootModuleInfo, Integer> moduleInfos = this.requiredModules;
        if (this.isAutomaticModule) {
            for (SootClass sootClass : Scene.v().getClasses()) {
                if (!(sootClass instanceof SootModuleInfo) || sootClass.moduleName == this.moduleName) continue;
                moduleInfos.put((SootModuleInfo)sootClass, 64);
            }
        }
        for (SootModuleInfo moduleInfo : moduleInfos.keySet()) {
            SootModuleResolver.v().resolveClass(MODULE_INFO, 3, (Optional<String>)Optional.fromNullable((Object)moduleInfo.moduleName));
        }
        return moduleInfos;
    }

    public void addExportedPackage(String packaze, String ... exportedToModules) {
        List<String> qualifiedExports = exportedToModules != null && exportedToModules.length > 0 ? Arrays.asList(exportedToModules) : Collections.singletonList(ALL_MODULES);
        this.exportedPackages.put(PackageNamer.v().get_FixedPackageName(packaze).replace('/', '.'), qualifiedExports);
    }

    public void addOpenedPackage(String packaze, String ... openedToModules) {
        List<String> qualifiedOpens = openedToModules != null && openedToModules.length > 0 ? Arrays.asList(openedToModules) : Collections.singletonList(ALL_MODULES);
        this.openedPackages.put(PackageNamer.v().get_FixedPackageName(packaze).replace('/', '.'), qualifiedOpens);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public boolean isConcrete() {
        return false;
    }

    @Override
    public boolean isExportedByModule() {
        return true;
    }

    @Override
    public boolean isExportedByModule(String toModule) {
        return true;
    }

    @Override
    public boolean isOpenedByModule() {
        return true;
    }

    public boolean exportsPackagePublic(String packaze) {
        return this.exportsPackage(packaze, ALL_MODULES);
    }

    public boolean openPackagePublic(String packaze) {
        return this.opensPackage(packaze, ALL_MODULES);
    }

    public boolean opensPackage(String packaze, String toModule) {
        if (MODULE_INFO.equalsIgnoreCase(packaze)) {
            return true;
        }
        if (this.getModuleName().equals(toModule)) {
            return this.modulePackages.contains(packaze);
        }
        if (this.isAutomaticModule()) {
            return this.modulePackages.contains(packaze);
        }
        List<String> qualifiedOpens = this.openedPackages.get(packaze);
        if (qualifiedOpens == null) {
            return false;
        }
        if (qualifiedOpens.contains(ALL_MODULES)) {
            return true;
        }
        return toModule != ALL_MODULES && qualifiedOpens.contains(toModule);
    }

    public boolean exportsPackage(String packaze, String toModule) {
        if (MODULE_INFO.equalsIgnoreCase(packaze)) {
            return true;
        }
        if (this.getModuleName().equals(toModule)) {
            return this.modulePackages.contains(packaze);
        }
        if (this.isAutomaticModule()) {
            return this.modulePackages.contains(packaze);
        }
        List<String> qualifiedExport = this.exportedPackages.get(packaze);
        if (qualifiedExport == null) {
            return false;
        }
        if (qualifiedExport.contains(ALL_MODULES)) {
            return true;
        }
        return toModule != ALL_MODULES && qualifiedExport.contains(toModule);
    }

    public Set<SootModuleInfo> getRequiredPublicModules() {
        HashSet<SootModuleInfo> requiredPublic = new HashSet<SootModuleInfo>();
        for (Map.Entry<SootModuleInfo, Integer> entry : this.requiredModules.entrySet()) {
            if ((entry.getValue() & 0x20) == 0) continue;
            requiredPublic.add(entry.getKey());
        }
        return requiredPublic;
    }

    public void addModulePackage(String packageName) {
        this.modulePackages.add(packageName);
    }

    public boolean moduleContainsPackage(String packageName) {
        return this.modulePackages.contains(packageName);
    }
}

