/*
 * Decompiled with CFR 0.152.
 */
package soot;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jf.dexlib2.iface.DexFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ClassProvider;
import soot.ClassSource;
import soot.CoffiClassProvider;
import soot.CoffiClassSource;
import soot.CompilationDeathException;
import soot.DexClassProvider;
import soot.FoundFile;
import soot.G;
import soot.JavaClassProvider;
import soot.JimpleClassProvider;
import soot.ModulePathSourceLocator;
import soot.ModuleUtil;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.asm.AsmClassProvider;
import soot.asm.AsmJava9ClassProvider;
import soot.dexpler.DexFileProvider;
import soot.options.Options;

public class SourceLocator {
    private static final Logger logger = LoggerFactory.getLogger(SourceLocator.class);
    protected Set<ClassLoader> additionalClassLoaders = new HashSet<ClassLoader>();
    protected List<ClassProvider> classProviders;
    protected List<String> classPath;
    private List<String> sourcePath;
    protected boolean java9Mode = false;
    protected final LoadingCache<String, ClassSourceType> pathToSourceType = CacheBuilder.newBuilder().initialCapacity(60).maximumSize(500L).softValues().concurrencyLevel(Runtime.getRuntime().availableProcessors()).build((CacheLoader)new CacheLoader<String, ClassSourceType>(){

        public ClassSourceType load(String path) throws Exception {
            File f = new File(path);
            if (!f.exists() && !Options.v().ignore_classpath_errors()) {
                throw new Exception("Error: The path '" + path + "' does not exist.");
            }
            if (!f.canRead() && !Options.v().ignore_classpath_errors()) {
                throw new Exception("Error: The path '" + path + "' exists but is not readable.");
            }
            if (f.isFile()) {
                if (path.endsWith(".zip")) {
                    return ClassSourceType.zip;
                }
                if (path.endsWith(".jar")) {
                    return ClassSourceType.jar;
                }
                if (Scene.isApk(new File(path))) {
                    return ClassSourceType.apk;
                }
                if (path.endsWith(".dex")) {
                    return ClassSourceType.dex;
                }
                return ClassSourceType.unknown;
            }
            return ClassSourceType.directory;
        }
    });
    protected final LoadingCache<String, Set<String>> archivePathsToEntriesCache = CacheBuilder.newBuilder().initialCapacity(60).maximumSize(500L).softValues().concurrencyLevel(Runtime.getRuntime().availableProcessors()).build((CacheLoader)new CacheLoader<String, Set<String>>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<String> load(String archivePath) throws Exception {
            try (ZipFile archive = null;){
                archive = new ZipFile(archivePath);
                HashSet<String> ret = new HashSet<String>();
                Enumeration<? extends ZipEntry> it = archive.entries();
                while (it.hasMoreElements()) {
                    ret.add(it.nextElement().getName());
                }
                HashSet<String> hashSet = ret;
                return hashSet;
            }
        }
    });
    private Set<String> dexClassPathExtensions;
    private Map<String, File> dexClassIndex;

    public SourceLocator(Singletons.Global g) {
    }

    public static SourceLocator v() {
        if (ModuleUtil.module_mode()) {
            return G.v().soot_ModulePathSourceLocator();
        }
        return G.v().soot_SourceLocator();
    }

    public static void ensureDirectoryExists(File dir) {
        if (dir != null && !dir.exists()) {
            try {
                dir.mkdirs();
            }
            catch (SecurityException se) {
                logger.debug("Unable to create " + dir);
                throw new CompilationDeathException(0);
            }
        }
    }

    public static List<String> explodeClassPath(String classPath) {
        ArrayList<String> ret = new ArrayList<String>();
        String regex = "(?<!\\\\)" + Pattern.quote(File.pathSeparator);
        for (String originalDir : classPath.split(regex)) {
            try {
                String canonicalDir = new File(originalDir).getCanonicalPath();
                if (originalDir.equals("VIRTUAL_FS_FOR_JDK")) {
                    SourceLocator.v().java9Mode = true;
                    continue;
                }
                ret.add(canonicalDir);
            }
            catch (IOException e) {
                throw new CompilationDeathException("Couldn't resolve classpath entry " + originalDir + ": " + e);
            }
        }
        return ret;
    }

    public ClassSource getClassSource(String className) {
        ClassSource ret;
        if (this.classPath == null) {
            this.classPath = SourceLocator.explodeClassPath(Scene.v().getSootClassPath());
        }
        if (this.classProviders == null) {
            this.setupClassProviders();
        }
        JavaClassProvider.JarException ex = null;
        for (ClassProvider cp : this.classProviders) {
            try {
                ret = cp.find(className);
                if (ret == null) continue;
                return ret;
            }
            catch (JavaClassProvider.JarException e) {
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
        for (final ClassLoader cl : this.additionalClassLoaders) {
            try {
                ret = new ClassProvider(){

                    @Override
                    public ClassSource find(String className) {
                        String fileName = className.replace('.', '/') + ".class";
                        InputStream stream = cl.getResourceAsStream(fileName);
                        if (stream == null) {
                            return null;
                        }
                        return new CoffiClassSource(className, stream, fileName);
                    }
                }.find(className);
                if (ret == null) continue;
                return ret;
            }
            catch (JavaClassProvider.JarException e) {
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
        if (className.startsWith("soot.rtlib.tamiflex.")) {
            ClassLoader cl;
            String fileName = className.replace('.', '/') + ".class";
            cl = this.getClass().getClassLoader();
            if (cl == null) {
                return null;
            }
            InputStream stream = cl.getResourceAsStream(fileName);
            if (stream != null) {
                return new CoffiClassSource(className, stream, fileName);
            }
        }
        return null;
    }

    public void additionalClassLoader(ClassLoader c) {
        this.additionalClassLoaders.add(c);
    }

    protected void setupClassProviders() {
        ClassProvider classFileClassProvider;
        this.classProviders = new LinkedList<ClassProvider>();
        ClassProvider classProvider = classFileClassProvider = Options.v().coffi() ? new CoffiClassProvider() : new AsmClassProvider();
        if (this.java9Mode) {
            this.classProviders.add(new AsmJava9ClassProvider());
        }
        switch (Options.v().src_prec()) {
            case 1: {
                this.classProviders.add(classFileClassProvider);
                this.classProviders.add(new JimpleClassProvider());
                this.classProviders.add(new JavaClassProvider());
                break;
            }
            case 2: {
                this.classProviders.add(classFileClassProvider);
                break;
            }
            case 4: {
                this.classProviders.add(new JavaClassProvider());
                this.classProviders.add(classFileClassProvider);
                this.classProviders.add(new JimpleClassProvider());
                break;
            }
            case 3: {
                this.classProviders.add(new JimpleClassProvider());
                this.classProviders.add(classFileClassProvider);
                this.classProviders.add(new JavaClassProvider());
                break;
            }
            case 5: {
                this.classProviders.add(new DexClassProvider());
                this.classProviders.add(classFileClassProvider);
                this.classProviders.add(new JavaClassProvider());
                this.classProviders.add(new JimpleClassProvider());
                break;
            }
            case 6: {
                this.classProviders.add(new DexClassProvider());
                this.classProviders.add(classFileClassProvider);
                this.classProviders.add(new JimpleClassProvider());
                break;
            }
            default: {
                throw new RuntimeException("Other source precedences are not currently supported.");
            }
        }
    }

    public void setClassProviders(List<ClassProvider> classProviders) {
        this.classProviders = classProviders;
    }

    public List<String> classPath() {
        return this.classPath;
    }

    public void invalidateClassPath() {
        this.classPath = null;
        this.dexClassIndex = null;
    }

    public List<String> sourcePath() {
        if (this.sourcePath == null) {
            this.sourcePath = new ArrayList<String>();
            for (String dir : this.classPath) {
                ClassSourceType cst = this.getClassSourceType(dir);
                if (cst == ClassSourceType.apk || cst == ClassSourceType.jar || cst == ClassSourceType.zip) continue;
                this.sourcePath.add(dir);
            }
        }
        return this.sourcePath;
    }

    protected ClassSourceType getClassSourceType(String path) {
        try {
            return (ClassSourceType)((Object)this.pathToSourceType.get((Object)path));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getClassesUnder(String aPath) {
        return this.getClassesUnder(aPath, "");
    }

    public List<String> getClassesUnder(String aPath, String prefix) {
        ArrayList<String> classes = new ArrayList<String>();
        if (aPath.equals("VIRTUAL_FS_FOR_JDK")) {
            Collection<List<String>> values = ModulePathSourceLocator.v().getClassUnderModulePath("jrt:/").values();
            ArrayList<String> foundClasses = new ArrayList<String>();
            for (List<String> classesInModule : values) {
                foundClasses.addAll(classesInModule);
            }
            return foundClasses;
        }
        ClassSourceType cst = this.getClassSourceType(aPath);
        if (cst == ClassSourceType.apk || cst == ClassSourceType.dex) {
            try {
                for (DexFileProvider.DexContainer<? extends DexFile> dex : DexFileProvider.v().getDexFromSource(new File(aPath))) {
                    classes.addAll(DexClassProvider.classesOfDex(dex.getBase().getDexFile()));
                }
            }
            catch (IOException e) {
                throw new CompilationDeathException("Error reading dex source", e);
            }
        }
        if (cst == ClassSourceType.jar || cst == ClassSourceType.zip) {
            ZipFile archive = null;
            try {
                archive = new ZipFile(aPath);
                Enumeration<? extends ZipEntry> entries = archive.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (!entryName.endsWith(".class") && !entryName.endsWith(".jimple")) continue;
                    int extensionIndex = entryName.lastIndexOf(46);
                    entryName = entryName.substring(0, extensionIndex);
                    entryName = entryName.replace('/', '.');
                    classes.add(prefix + entryName);
                }
            }
            catch (Throwable e) {
                throw new CompilationDeathException("Error reading archive '" + aPath + "'", e);
            }
            finally {
                try {
                    if (archive != null) {
                        archive.close();
                    }
                }
                catch (Throwable t) {
                    logger.debug("" + t.getMessage());
                }
            }
            try {
                for (DexFileProvider.DexContainer<? extends DexFile> container2 : DexFileProvider.v().getDexFromSource(new File(aPath))) {
                    classes.addAll(DexClassProvider.classesOfDex(container2.getBase().getDexFile()));
                }
            }
            catch (CompilationDeathException e) {
            }
            catch (IOException e) {
                logger.debug("" + e.getMessage());
            }
        } else if (cst == ClassSourceType.directory) {
            File file = new File(aPath);
            File[] files = file.listFiles();
            if (files == null) {
                files = new File[]{file};
            }
            for (File element : files) {
                if (element.isDirectory()) {
                    classes.addAll(this.getClassesUnder(aPath + File.separatorChar + element.getName(), prefix + element.getName() + "."));
                    continue;
                }
                String fileName = element.getName();
                if (fileName.endsWith(".class")) {
                    int index = fileName.lastIndexOf(".class");
                    classes.add(prefix + fileName.substring(0, index));
                    continue;
                }
                if (fileName.endsWith(".jimple")) {
                    int index = fileName.lastIndexOf(".jimple");
                    classes.add(prefix + fileName.substring(0, index));
                    continue;
                }
                if (fileName.endsWith(".java")) {
                    int index = fileName.lastIndexOf(".java");
                    classes.add(prefix + fileName.substring(0, index));
                    continue;
                }
                if (!fileName.endsWith(".dex")) continue;
                try {
                    for (DexFileProvider.DexContainer<? extends DexFile> container3 : DexFileProvider.v().getDexFromSource(element)) {
                        classes.addAll(DexClassProvider.classesOfDex(container3.getBase().getDexFile()));
                    }
                }
                catch (IOException e) {
                    logger.debug("" + e.getMessage());
                }
            }
        } else {
            throw new RuntimeException("Invalid class source type");
        }
        return classes;
    }

    public String getFileNameFor(SootClass c, int rep) {
        if (rep == 12) {
            return null;
        }
        StringBuffer b = new StringBuffer();
        if (!Options.v().output_jar()) {
            b.append(this.getOutputDir());
        }
        if (b.length() > 0 && b.charAt(b.length() - 1) != File.separatorChar) {
            b.append(File.separatorChar);
        }
        if (rep != 15) {
            if (rep == 14) {
                b.append(c.getName().replace('.', File.separatorChar));
            } else if (rep == 16) {
                b.append(c.getName().replace('.', '_'));
                b.append("_Maker");
            } else if (Options.v().hierarchy_dirs() && (rep == 1 || rep == 3)) {
                b.append(c.getName().replace('.', File.separatorChar));
            } else {
                b.append(c.getName());
            }
            b.append(this.getExtensionFor(rep));
            return b.toString();
        }
        return this.getDavaFilenameFor(c, b);
    }

    private String getDavaFilenameFor(SootClass c, StringBuffer b) {
        b.append("dava");
        b.append(File.separatorChar);
        SourceLocator.ensureDirectoryExists(new File(b.toString() + "classes"));
        b.append("src");
        b.append(File.separatorChar);
        String fixedPackageName = c.getJavaPackageName();
        if (!fixedPackageName.equals("")) {
            b.append(fixedPackageName.replace('.', File.separatorChar));
            b.append(File.separatorChar);
        }
        SourceLocator.ensureDirectoryExists(new File(b.toString()));
        b.append(c.getShortJavaStyleName());
        b.append(".java");
        return b.toString();
    }

    public Set<String> classesInDynamicPackage(String str) {
        HashSet<String> set = new HashSet<String>(0);
        StringTokenizer strtok = new StringTokenizer(Scene.v().getSootClassPath(), String.valueOf(File.pathSeparatorChar));
        while (strtok.hasMoreTokens()) {
            String path = strtok.nextToken();
            if (this.getClassSourceType(path) != ClassSourceType.directory) continue;
            List<String> l = this.getClassesUnder(path);
            for (String filename : l) {
                if (!filename.startsWith(str)) continue;
                set.add(filename);
            }
            path = path + File.separatorChar;
            StringTokenizer tokenizer = new StringTokenizer(str, ".");
            while (tokenizer.hasMoreTokens()) {
                path = path + tokenizer.nextToken();
                if (!tokenizer.hasMoreTokens()) continue;
                path = path + File.separatorChar;
            }
            l = this.getClassesUnder(path);
            for (String string : l) {
                set.add(str + "." + string);
            }
        }
        return set;
    }

    public String getExtensionFor(int rep) {
        switch (rep) {
            case 5: {
                return ".baf";
            }
            case 6: {
                return ".b";
            }
            case 1: {
                return ".jimple";
            }
            case 2: {
                return ".jimp";
            }
            case 3: {
                return ".shimple";
            }
            case 4: {
                return ".shimp";
            }
            case 8: {
                return ".grimp";
            }
            case 7: {
                return ".grimple";
            }
            case 14: {
                return ".class";
            }
            case 15: {
                return ".java";
            }
            case 13: {
                return ".jasmin";
            }
            case 9: {
                return ".xml";
            }
            case 16: {
                return ".java";
            }
            case 17: {
                return ".asm";
            }
        }
        throw new RuntimeException();
    }

    public String getOutputDir() {
        File dir;
        if (Options.v().output_dir().length() == 0) {
            dir = new File("sootOutput");
        } else {
            dir = new File(Options.v().output_dir());
            if (dir.getPath().endsWith(".jar") && (dir = dir.getParentFile()) == null) {
                dir = new File("");
            }
        }
        SourceLocator.ensureDirectoryExists(dir);
        return dir.getPath();
    }

    public String getOutputJarName() {
        File dir;
        if (!Options.v().output_jar()) {
            return "";
        }
        if (Options.v().output_dir().length() == 0) {
            dir = new File("sootOutput/out.jar");
        } else {
            dir = new File(Options.v().output_dir());
            if (!dir.getPath().endsWith(".jar")) {
                dir = new File(dir.getPath(), "out.jar");
            }
        }
        SourceLocator.ensureDirectoryExists(dir.getParentFile());
        return dir.getPath();
    }

    public FoundFile lookupInClassPath(String fileName) {
        for (String dir : this.classPath) {
            FoundFile ret = null;
            ClassSourceType cst = this.getClassSourceType(dir);
            if (cst == ClassSourceType.zip || cst == ClassSourceType.jar) {
                ret = this.lookupInArchive(dir, fileName);
            } else if (cst == ClassSourceType.directory) {
                ret = this.lookupInDir(dir, fileName);
            }
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    protected FoundFile lookupInDir(String dir, String fileName) {
        File f = new File(dir, fileName);
        if (f.exists() && f.canRead()) {
            return new FoundFile(f);
        }
        return null;
    }

    protected FoundFile lookupInArchive(String archivePath, String fileName) {
        Set entryNames = null;
        try {
            entryNames = (Set)this.archivePathsToEntriesCache.get((Object)archivePath);
        }
        catch (Exception e) {
            throw new RuntimeException("Error: Failed to retrieve the archive entries list for the archive at path '" + archivePath + "'.", e);
        }
        if (entryNames.contains(fileName)) {
            return new FoundFile(archivePath, fileName);
        }
        return null;
    }

    public String getSourceForClass(String className) {
        String javaClassName = className;
        int i = className.indexOf("$");
        if (i > -1) {
            javaClassName = className.substring(0, i);
        }
        return javaClassName;
    }

    public Map<String, File> dexClassIndex() {
        return this.dexClassIndex;
    }

    public void setDexClassIndex(Map<String, File> index) {
        this.dexClassIndex = index;
    }

    public void extendClassPath(String newPathElement) {
        this.classPath = null;
        if (newPathElement.endsWith(".dex") || newPathElement.endsWith(".apk")) {
            if (this.dexClassPathExtensions == null) {
                this.dexClassPathExtensions = new HashSet<String>();
            }
            this.dexClassPathExtensions.add(newPathElement);
        }
    }

    public Set<String> getDexClassPathExtensions() {
        return this.dexClassPathExtensions;
    }

    public void clearDexClassPathExtensions() {
        this.dexClassPathExtensions = null;
    }

    protected static enum ClassSourceType {
        jar,
        zip,
        apk,
        dex,
        directory,
        jrt,
        unknown;

    }
}

