/*
 * Decompiled with CFR 0.152.
 */
package soot.baf.internal;

import soot.AbstractJasminClass;
import soot.SootField;
import soot.SootFieldRef;
import soot.UnitPrinter;
import soot.baf.InstSwitch;
import soot.baf.StaticPutInst;
import soot.baf.internal.AbstractInst;
import soot.util.Switch;

public class BStaticPutInst
extends AbstractInst
implements StaticPutInst {
    SootFieldRef fieldRef;

    public BStaticPutInst(SootFieldRef fieldRef) {
        if (!fieldRef.isStatic()) {
            throw new RuntimeException("wrong static-ness");
        }
        this.fieldRef = fieldRef;
    }

    @Override
    public Object clone() {
        return new BStaticPutInst(this.fieldRef);
    }

    @Override
    public int getInCount() {
        return 1;
    }

    @Override
    public int getInMachineCount() {
        return AbstractJasminClass.sizeOfType(this.fieldRef.type());
    }

    @Override
    public int getOutCount() {
        return 0;
    }

    @Override
    public int getOutMachineCount() {
        return 0;
    }

    @Override
    public final String getName() {
        return "staticput";
    }

    @Override
    final String getParameters() {
        return " " + this.fieldRef.getSignature();
    }

    @Override
    protected void getParameters(UnitPrinter up) {
        up.literal(" ");
        up.fieldRef(this.fieldRef);
    }

    @Override
    public SootFieldRef getFieldRef() {
        return this.fieldRef;
    }

    @Override
    public SootField getField() {
        return this.fieldRef.resolve();
    }

    @Override
    public void apply(Switch sw) {
        ((InstSwitch)sw).caseStaticPutInst(this);
    }

    @Override
    public boolean containsFieldRef() {
        return true;
    }
}

