/*
 * Decompiled with CFR 0.152.
 */
package soot.dava;

import soot.AbstractUnitPrinter;
import soot.ArrayType;
import soot.RefType;
import soot.SootClass;
import soot.SootFieldRef;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.dava.DavaBody;
import soot.dava.toolkits.base.renamer.RemoveFullyQualifiedName;
import soot.jimple.ClassConstant;
import soot.jimple.Constant;
import soot.jimple.IdentityRef;
import soot.jimple.ThisRef;

public class DavaUnitPrinter
extends AbstractUnitPrinter {
    private boolean eatSpace = false;
    DavaBody body;

    public DavaUnitPrinter(DavaBody body) {
        this.body = body;
    }

    @Override
    public void methodRef(SootMethodRef m) {
        this.handleIndent();
        this.output.append(m.getName());
    }

    @Override
    public void fieldRef(SootFieldRef f) {
        this.handleIndent();
        this.output.append(f.name());
    }

    @Override
    public void identityRef(IdentityRef r) {
        this.handleIndent();
        if (!(r instanceof ThisRef)) {
            throw new RuntimeException();
        }
        this.literal("this");
    }

    @Override
    public void literal(String s) {
        this.handleIndent();
        if (this.eatSpace && " ".equals(s)) {
            this.eatSpace = false;
            return;
        }
        this.eatSpace = false;
        switch (s) {
            case "staticinvoke": 
            case "virtualinvoke": 
            case "interfaceinvoke": {
                this.eatSpace = true;
                return;
            }
        }
        this.output.append(s);
    }

    @Override
    public void type(Type t) {
        this.handleIndent();
        if (t instanceof RefType) {
            SootClass sootClass = ((RefType)t).getSootClass();
            String name = sootClass.getJavaStyleName();
            if (!name.equals(sootClass.toString())) {
                name = RemoveFullyQualifiedName.getReducedName(this.body.getImportList(), sootClass.toString(), t);
            }
            this.output.append(name);
        } else if (t instanceof ArrayType) {
            ((ArrayType)t).toString(this);
        } else {
            this.output.append(t.toString());
        }
    }

    @Override
    public void unitRef(Unit u, boolean branchTarget) {
        throw new RuntimeException("Dava doesn't have unit references!");
    }

    @Override
    public void constant(Constant c) {
        if (c instanceof ClassConstant) {
            this.handleIndent();
            this.output.append(((ClassConstant)c).value.replace('/', '.')).append(".class");
        } else {
            super.constant(c);
        }
    }

    public void addNot() {
        this.output.append(" !");
    }

    public void addAggregatedOr() {
        this.output.append(" || ");
    }

    public void addAggregatedAnd() {
        this.output.append(" && ");
    }

    public void addLeftParen() {
        this.output.append(" (");
    }

    public void addRightParen() {
        this.output.append(") ");
    }

    public void printString(String s) {
        this.output.append(s);
    }
}

